/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.MAmbience;
import me.andre111.mambience.accessor.AccessorBukkit;
import me.andre111.mambience.data.fallback.FallbackDatapackDataLocator;
import me.andre111.mambience.data.loader.DataLoader;
import me.andre111.mambience.resources.Generator;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MAmbienceBukkit
extends JavaPlugin
implements Listener {
    public void onLoad() {
        MAmbience.init(new MALogger(this.getLogger()::info, this.getLogger()::warning), this.getDataFolder());
        Bukkit.getScheduler().runTaskTimer((Plugin)this, MAmbience.getScheduler()::runTick, 1L, 1L);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "mambience:server");
        String datapackPath = "./" + ((World)Bukkit.getWorlds().get(0)).getName() + "/datapacks/";
        if (!Files.exists(Generator.getFilePath("data", datapackPath), new LinkOption[0])) {
            try {
                MAmbience.getLogger().log("Extracting datapack to default world, if this location has been changed please move the generated datapack accordingly!");
                MAmbience.getLogger().log("Please ensure that only one mambience datapack exists if you previously ran an older version of MAmbience.");
                Files.createDirectories(Paths.get(datapackPath, new String[0]), new FileAttribute[0]);
                Generator.generate("data", datapackPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FallbackDatapackDataLocator locator = new FallbackDatapackDataLocator(new File(datapackPath));
        DataLoader.reload(locator);
        locator.close();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        MAmbience.addPlayer(event.getPlayer().getUniqueId(), new AccessorBukkit(event.getPlayer().getUniqueId()));
    }

    @EventHandler
    public void onPlayerRegisterChannel(PlayerRegisterChannelEvent event) {
        if (event.getChannel().equals("mambience:server")) {
            event.getPlayer().sendPluginMessage((Plugin)this, "mambience:server", "enabled".getBytes());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent event) {
        MAmbience.getScheduler().triggerEvents(event.getPlayer().getUniqueId(), "ATTACK_BLOCK");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MAmbience.getScheduler().triggerEvents(player.getUniqueId(), "ATTACK_HIT");
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        switch (event.getAction()) {
            case LEFT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: {
                MAmbience.getScheduler().triggerEvents(event.getPlayer().getUniqueId(), "ATTACK_SWING");
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                MAmbience.getScheduler().triggerEvents(event.getPlayer().getUniqueId(), event.getHand() == EquipmentSlot.HAND ? "USE_ITEM_MAINHAND" : "USE_ITEM_OFFHAND");
                break;
            }
        }
    }
}

