/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.util;

import com.legacy.structure_gel.core.StructureGelMod;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public abstract class AbstractConfigUtil {
    protected final String name;

    public AbstractConfigUtil(String name) {
        this.name = name;
        if (FMLJavaModLoadingContext.get() != null) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            bus.addListener(this::onConfigLoad);
            bus.addListener(this::onConfigReload);
        }
    }

    protected void onConfigLoad(ModConfigEvent.Loading event) {
        this.reload();
    }

    protected void onConfigReload(ModConfigEvent.Reloading event) {
        this.reload();
    }

    protected abstract void reload();

    protected String configComment(String description, Object defaultVal, Object example) {
        return String.format("\n %s\n Example: %s\n Default: %s", description, this.valString(example), this.valString(defaultVal));
    }

    protected String configComment(String description, Object defaultVal) {
        return String.format("\n %s\n Default: %s", description, this.valString(defaultVal));
    }

    protected String valString(Object val) {
        if (val instanceof List) {
            List list = (List)val;
            if (list.isEmpty()) {
                return "[]";
            }
            return "[\"" + String.join((CharSequence)"\", \"", list.stream().map(Object::toString).collect(Collectors.toList())) + "\"]";
        }
        return val.toString();
    }

    protected void logResourceLocationError(String invalidResourceLocation, String message) {
        StructureGelMod.logError("Couldn't read a ResourceLocation in the config for {}. It was {}. {}", this.name, invalidResourceLocation, message);
    }
}

