/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.registry;

import com.legacy.structure_gel.api.block.AxisStructureGelBlock;
import com.legacy.structure_gel.api.block.StructureGelBlock;
import com.legacy.structure_gel.api.block.base.IStructureGel;
import com.legacy.structure_gel.api.item.StructureGelItem;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block.DataHandlerBlock;
import com.legacy.structure_gel.core.block.DynamicSpawnerBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SGBlocks {
    protected static List<BlockItem> blockItems = new ArrayList<BlockItem>();
    public static final Lazy<StructureGelBlock> RED_GEL = Lazy.of(() -> new StructureGelBlock(new IStructureGel.IBehavior[0]));
    public static final Lazy<StructureGelBlock> BLUE_GEL = Lazy.of(() -> new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE));
    public static final Lazy<StructureGelBlock> GREEN_GEL = Lazy.of(() -> new StructureGelBlock(IStructureGel.Behavior.DIAGONAL_SPREAD));
    public static final Lazy<StructureGelBlock> CYAN_GEL = Lazy.of(() -> new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE, IStructureGel.Behavior.DIAGONAL_SPREAD));
    public static final Lazy<StructureGelBlock> ORANGE_GEL = Lazy.of(() -> new StructureGelBlock(IStructureGel.Behavior.DYNAMIC_SPREAD_DIST));
    public static final Lazy<StructureGelBlock> YELLOW_GEL = Lazy.of(() -> new AxisStructureGelBlock(IStructureGel.Behavior.AXIS_SPREAD));
    public static final Lazy<DataHandlerBlock> DATA_HANDLER = Lazy.of(() -> new DataHandlerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50677_)));
    public static final Lazy<DynamicSpawnerBlock> DYNAMIC_SPAWNER = Lazy.of(() -> new DynamicSpawnerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50085_).lootFrom(() -> Blocks.f_50085_)));

    @SubscribeEvent
    protected static void onRegistry(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        SGBlocks.register((IForgeRegistry<Block>)registry, "red_gel", RED_GEL, null, StructureGelItem::new);
        SGBlocks.register((IForgeRegistry<Block>)registry, "blue_gel", BLUE_GEL, null, StructureGelItem::new);
        SGBlocks.register((IForgeRegistry<Block>)registry, "green_gel", GREEN_GEL, null, StructureGelItem::new);
        SGBlocks.register((IForgeRegistry<Block>)registry, "cyan_gel", CYAN_GEL, null, StructureGelItem::new);
        SGBlocks.register((IForgeRegistry<Block>)registry, "orange_gel", ORANGE_GEL, null, StructureGelItem::new);
        SGBlocks.register((IForgeRegistry<Block>)registry, "yellow_gel", YELLOW_GEL, null, StructureGelItem::new);
        SGBlocks.register((IForgeRegistry<Block>)registry, "data_handler", DATA_HANDLER, new Item.Properties().m_41497_(Rarity.EPIC));
        SGBlocks.register((IForgeRegistry<Block>)registry, "dynamic_spawner", DYNAMIC_SPAWNER, new Item.Properties().m_41497_(Rarity.EPIC));
    }

    private static <B extends Block> void register(IForgeRegistry<Block> registry, String key, Lazy<B> lazy) {
        Block obj = (Block)lazy.get();
        obj.setRegistryName(StructureGelMod.locate(key));
        registry.register((IForgeRegistryEntry)obj);
    }

    private static <B extends Block> void register(IForgeRegistry<Block> registry, String key, Lazy<B> block, CreativeModeTab creativeTab) {
        SGBlocks.register(registry, key, block, new Item.Properties().m_41491_(creativeTab));
    }

    private static <B extends Block> void register(IForgeRegistry<Block> registry, String key, Lazy<B> block, Item.Properties itemProperties) {
        SGBlocks.register(registry, key, block, itemProperties, BlockItem::new);
    }

    private static <B extends Block> void register(IForgeRegistry<Block> registry, String key, Lazy<B> block, Item.Properties itemProperties, BiFunction<B, Item.Properties, BlockItem> blockItemFactory) {
        SGBlocks.register(registry, key, block);
        Block b = (Block)block.get();
        BlockItem blockItem = blockItemFactory.apply(b, itemProperties);
        blockItem.setRegistryName(b.getRegistryName());
        blockItems.add(blockItem);
    }
}

