/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.core.capability.entity.GelCapability;
import com.legacy.structure_gel.core.capability.entity.GelEntity;
import com.legacy.structure_gel.core.capability.entity.IGelEntity;
import com.legacy.structure_gel.core.util.Internal;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class UpdateGelPlayerPacket {
    protected final IGelEntity gelEntity;

    public UpdateGelPlayerPacket(IGelEntity gelEntity) {
        this.gelEntity = gelEntity;
    }

    public static void encoder(UpdateGelPlayerPacket packet, FriendlyByteBuf buff) {
        UpdateGelPlayerPacket.putPortal(buff, packet.gelEntity.getPortal());
    }

    public static UpdateGelPlayerPacket decoder(FriendlyByteBuf buff) {
        GelEntity gelEntity = new GelEntity();
        gelEntity.setPortal(UpdateGelPlayerPacket.getPortal(buff));
        return new UpdateGelPlayerPacket(gelEntity);
    }

    @Internal
    private static void putPortal(FriendlyByteBuf buff, GelPortalBlock portal) {
        buff.m_130070_(portal != null ? portal.getRegistryName().toString() : GelEntity.EMPTY.toString());
    }

    @Internal
    private static GelPortalBlock getPortal(FriendlyByteBuf buff) {
        ResourceLocation portal = new ResourceLocation(buff.m_130277_());
        return !portal.equals((Object)GelEntity.EMPTY) && ForgeRegistries.BLOCKS.containsKey(portal) && ForgeRegistries.BLOCKS.getValue(portal) instanceof GelPortalBlock ? (GelPortalBlock)ForgeRegistries.BLOCKS.getValue(portal) : null;
    }

    public static void handler(UpdateGelPlayerPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateGelPlayerPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(UpdateGelPlayerPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        GelCapability.ifPresent(mc.f_91074_, ge -> ge.setPortal(packet.gelEntity.getPortal()));
    }
}

