/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin;

import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.legacy.structure_gel.core.mixin.ChunkAccessMixin;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ConfiguredStructureFeature.class})
public class ConfiguredStructureFeatureMixin {
    @Inject(at={@At(value="HEAD")}, method={"generate"}, cancellable=true)
    private void checkDimension(RegistryAccess registryAccess, ChunkGenerator chunkGen, BiomeSource biomeSource, StructureManager structureManager, long levelSeed, ChunkPos chunkPos, int refs, LevelHeightAccessor levelHeight, Predicate<Holder<Biome>> biomeTest, CallbackInfoReturnable<StructureStart> callback) {
        ChunkAccessMixin.Access access;
        LevelHeightAccessor levelHeightAccessor;
        if (levelHeight instanceof ChunkAccessMixin.Access && (levelHeightAccessor = (access = (ChunkAccessMixin.Access)levelHeight).getHeightAccessor()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelHeightAccessor;
            if (StructureAccessHelper.isValidDimension(registryAccess.m_175515_(Registry.f_122882_).m_7854_((Object)((ConfiguredStructureFeature)this)), (ResourceKey<Level>)level.m_46472_())) {
                return;
            }
        }
        callback.setReturnValue((Object)StructureStart.f_73561_);
    }

    @ModifyVariable(at=@At(value="LOAD", ordinal=1), ordinal=0, method={"generate"})
    private StructurePiecesBuilder generateHook(StructurePiecesBuilder pieceBuilder, RegistryAccess registryAccess, ChunkGenerator chunkGen, BiomeSource biomeSource, StructureManager structureManager, long levelSeed, ChunkPos chunkPos, int refs, LevelHeightAccessor levelHeight) {
        ConfiguredStructureFeature me = (ConfiguredStructureFeature)this;
        StructureFeature structure = me.f_65403_;
        if (structure instanceof IPieceBuilderModifier) {
            IPieceBuilderModifier modifier = (IPieceBuilderModifier)structure;
            FeatureConfiguration config = me.f_65404_;
            modifier.modifyPieceBuilder(pieceBuilder, new IPieceBuilderModifier.Context<FeatureConfiguration>(config, registryAccess, chunkGen, biomeSource, structureManager, levelSeed, chunkPos, levelHeight));
        }
        return pieceBuilder;
    }
}

