/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.dimension.portal;

import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.core.util.Internal;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class GelTeleporter
implements ITeleporter {
    private final ServerLevel level;
    private final Supplier<ResourceKey<Level>> dimension1;
    private final Supplier<ResourceKey<Level>> dimension2;
    private final Supplier<PoiType> portalPOI;
    private final Supplier<GelPortalBlock> portalBlock;
    private final Supplier<BlockState> frameBlock;
    private final ICreatePortalFuncion placementBehavior;

    public GelTeleporter(ServerLevel serverLevel, Supplier<ResourceKey<Level>> dimension1, Supplier<ResourceKey<Level>> dimension2, Supplier<PoiType> portalPOI, Supplier<GelPortalBlock> portalBlock, Supplier<BlockState> frameBlock, ICreatePortalFuncion placementBehavior) {
        this.level = serverLevel;
        this.dimension1 = dimension1;
        this.dimension2 = dimension2;
        this.portalPOI = portalPOI;
        this.portalBlock = portalBlock;
        this.frameBlock = frameBlock;
        this.placementBehavior = placementBehavior;
    }

    public GelTeleporter(ServerLevel serverLevel, Supplier<ResourceKey<Level>> dimension1, Supplier<ResourceKey<Level>> dimension2, Supplier<PoiType> portalPOI, Supplier<GelPortalBlock> portalBlock, Supplier<BlockState> frameBlock, CreatePortalBehavior placementBehavior) {
        this(serverLevel, dimension1, dimension2, portalPOI, portalBlock, frameBlock, placementBehavior.get());
    }

    @Internal
    public ResourceKey<Level> getOpposite() {
        if (this.level != null && this.level.m_46472_().m_135782_().equals((Object)this.dimension1.get().m_135782_())) {
            return this.dimension2.get();
        }
        return this.dimension1.get();
    }

    public Supplier<ResourceKey<Level>> getDimension1() {
        return this.dimension1;
    }

    public Supplier<ResourceKey<Level>> getDimension2() {
        return this.dimension2;
    }

    public Supplier<PoiType> getPortalPOI() {
        return this.portalPOI;
    }

    public Supplier<GelPortalBlock> getPortalBlock() {
        return this.portalBlock;
    }

    public Supplier<BlockState> getFrameBlock() {
        return this.frameBlock;
    }

    public ICreatePortalFuncion getPlacementBehavior() {
        return this.placementBehavior;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public boolean shouldIgnoreBlock(BlockState state, BlockPos pos) {
        return state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13106_) || this.level.m_46859_(pos) || state.m_60812_((BlockGetter)this.level, pos).m_83281_() && !state.m_60767_().m_76332_();
    }

    public int getDefaultHeight() {
        return 70;
    }

    public Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos startPos, boolean toNether) {
        PoiManager poiManager = this.level.m_8904_();
        int dist = (int)Math.max(DimensionType.m_63908_((DimensionType)this.level.m_142572_().m_129880_(this.getOpposite()).m_6042_(), (DimensionType)this.level.m_6042_()) * 16.0, 16.0);
        poiManager.m_27056_((LevelReader)this.level, startPos, dist);
        Optional<PoiRecord> optional = poiManager.m_27166_(poiType -> poiType == this.portalPOI.get(), startPos, dist, PoiManager.Occupancy.ANY).filter(poi -> poiManager.m_27177_(poi.m_27257_().m_7495_()).orElse(null) != poi.m_27258_()).filter(poi -> this.level.m_8055_(poi.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_)).min(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)startPos)).thenComparingInt(poi -> poi.m_27257_().m_123342_()));
        return optional.map(poi -> {
            BlockPos blockpos = poi.m_27257_();
            this.level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.m_8055_(blockpos);
            return BlockUtil.m_124334_((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> this.level.m_8055_(pos) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos startPos, Direction.Axis enterAxis) {
        return this.placementBehavior.apply(this, startPos, enterAxis);
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        Vec3 offset;
        Direction.Axis portalAxis;
        WorldBorder worldborder = destLevel.m_6857_();
        double minX = Math.max(-2.9999872E7, worldborder.m_61955_() + 16.0);
        double minZ = Math.max(-2.9999872E7, worldborder.m_61956_() + 16.0);
        double maxX = Math.min(2.9999872E7, worldborder.m_61957_() - 16.0);
        double maxZ = Math.min(2.9999872E7, worldborder.m_61958_() - 16.0);
        double scaling = DimensionType.m_63908_((DimensionType)entity.f_19853_.m_6042_(), (DimensionType)destLevel.m_6042_());
        BlockPos scaledPos = new BlockPos(Mth.m_14008_((double)(entity.m_20185_() * scaling), (double)minX, (double)maxX), entity.m_20186_(), Mth.m_14008_((double)(entity.m_20189_() * scaling), (double)minZ, (double)maxZ));
        BlockPos portalPos = entity.f_19819_;
        BlockState blockstate = entity.f_19853_.m_8055_(portalPos);
        if (blockstate.m_61138_((Property)BlockStateProperties.f_61364_)) {
            portalAxis = (Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_);
            BlockUtil.FoundRectangle motionTpResult = BlockUtil.m_124334_((BlockPos)portalPos, (Direction.Axis)portalAxis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, bp -> entity.f_19853_.m_8055_(bp) == blockstate);
            offset = PortalShape.m_77738_((BlockUtil.FoundRectangle)motionTpResult, (Direction.Axis)portalAxis, (Vec3)entity.m_20182_(), (EntityDimensions)entity.m_6972_(entity.m_20089_()));
        } else {
            portalAxis = Direction.Axis.X;
            offset = new Vec3(0.5, 0.0, 0.0);
        }
        Optional<BlockUtil.FoundRectangle> result = this.findPortalAround(scaledPos, false);
        if (entity instanceof ServerPlayer && !result.isPresent()) {
            result = this.createPortal(scaledPos, portalAxis);
        }
        if (!result.isPresent()) {
            return null;
        }
        PortalInfo portalInfo = PortalShape.m_77699_((ServerLevel)destLevel, (BlockUtil.FoundRectangle)result.get(), (Direction.Axis)portalAxis, (Vec3)offset, (EntityDimensions)entity.m_6972_(entity.m_20089_()), (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        return new PortalInfo(new Vec3((double)result.get().f_124348_.m_123341_() + 0.5, (double)result.get().f_124348_.m_123342_() + 0.05, (double)result.get().f_124348_.m_123343_() + 0.5), portalInfo.f_77677_, portalInfo.f_77678_, portalInfo.f_77679_);
    }

    public static Optional<BlockUtil.FoundRectangle> createAndFindPortalSurface(GelTeleporter teleporter, BlockPos startPos, Direction.Axis enterAxis) {
        int x1;
        int i;
        ServerLevel serverLevel = teleporter.level;
        int x = startPos.m_123341_();
        int y = serverLevel.m_141928_();
        int z = startPos.m_123343_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(x, y, z);
        BlockState state = serverLevel.m_8055_((BlockPos)mutablePos);
        for (i = y; i > 0 && teleporter.shouldIgnoreBlock(state, (BlockPos)mutablePos); --i) {
            state = serverLevel.m_8055_((BlockPos)mutablePos.m_122173_(Direction.DOWN));
        }
        y = i <= 0 ? teleporter.getDefaultHeight() : i + 1;
        BlockState frameState = teleporter.getFrameBlock().get();
        for (int horizontalOffset = -1; horizontalOffset < 3; ++horizontalOffset) {
            for (int verticalOffset = -1; verticalOffset < 4; ++verticalOffset) {
                if (horizontalOffset != -1 && horizontalOffset != 2 && verticalOffset != -1 && verticalOffset != 3) continue;
                BlockPos pos2 = new BlockPos(x, y + verticalOffset, z + horizontalOffset);
                serverLevel.m_7731_(pos2, frameState, 3);
            }
        }
        BlockState portalState = (BlockState)teleporter.getPortalBlock().get().m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)Direction.Axis.Z);
        for (int horizontalOffset = 0; horizontalOffset < 2; ++horizontalOffset) {
            for (int verticalOffset = 0; verticalOffset < 3; ++verticalOffset) {
                BlockPos pos2 = new BlockPos(x, y + verticalOffset, z + horizontalOffset);
                serverLevel.m_7731_(pos2, portalState, 18);
            }
        }
        boolean placePlatform = true;
        block5: for (x1 = -1; x1 < 2; ++x1) {
            for (int z1 = 0; z1 < 2; ++z1) {
                BlockPos pos2 = new BlockPos(x + x1, y - 1, z + z1);
                BlockState existingState = serverLevel.m_8055_(pos2);
                if (teleporter.shouldIgnoreBlock(existingState, pos2) || existingState.m_60767_().m_76332_() || existingState.m_60734_() == frameState.m_60734_()) continue;
                placePlatform = false;
                break block5;
            }
        }
        if (placePlatform) {
            for (x1 = -1; x1 < 2; ++x1) {
                for (int z1 = 0; z1 < 2; ++z1) {
                    serverLevel.m_46597_(new BlockPos(x + x1, y - 1, z + z1), frameState);
                }
            }
        }
        return teleporter.findPortalAround(startPos, false);
    }

    public static Optional<BlockUtil.FoundRectangle> createAndFindPortalNether(GelTeleporter teleporter, BlockPos startPos, Direction.Axis enterAxis) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)enterAxis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = teleporter.level.m_6857_();
        int i = teleporter.level.m_141928_() - 1;
        BlockPos.MutableBlockPos blockpos$mutable = startPos.m_122032_();
        for (BlockPos.MutableBlockPos blockpos$mutable1 : BlockPos.m_121935_((BlockPos)startPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, teleporter.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, blockpos$mutable1.m_123341_(), blockpos$mutable1.m_123343_()));
            if (!worldborder.m_61937_((BlockPos)blockpos$mutable1) || !worldborder.m_61937_((BlockPos)blockpos$mutable1.m_122175_(direction, 1))) continue;
            blockpos$mutable1.m_122175_(direction.m_122424_(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.m_142448_(l);
                if (!teleporter.level.m_46859_((BlockPos)blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && teleporter.level.m_46859_((BlockPos)blockpos$mutable1.m_122173_(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.m_142448_(l);
                if (!teleporter.checkRegionForPlacement((BlockPos)blockpos$mutable1, blockpos$mutable, direction, 0)) continue;
                double d2 = startPos.m_123331_((Vec3i)blockpos$mutable1);
                if (teleporter.checkRegionForPlacement((BlockPos)blockpos$mutable1, blockpos$mutable, direction, -1) && teleporter.checkRegionForPlacement((BlockPos)blockpos$mutable1, blockpos$mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.m_7949_();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.m_7949_();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(startPos.m_123341_(), Mth.m_14045_((int)startPos.m_123342_(), (int)70, (int)(teleporter.level.m_141928_() - 10)), startPos.m_123343_()).m_7949_();
            Direction direction1 = direction.m_122427_();
            if (!worldborder.m_61937_(blockpos)) {
                return Optional.empty();
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        BlockState blockstate1 = i3 < 0 ? teleporter.frameBlock.get() : Blocks.f_50016_.m_49966_();
                        blockpos$mutable.m_122154_((Vec3i)blockpos, k2 * direction.m_122429_() + l1 * direction1.m_122429_(), i3, k2 * direction.m_122431_() + l1 * direction1.m_122431_());
                        teleporter.level.m_46597_((BlockPos)blockpos$mutable, blockstate1);
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                blockpos$mutable.m_122154_((Vec3i)blockpos, k1 * direction.m_122429_(), i2, k1 * direction.m_122431_());
                teleporter.level.m_7731_((BlockPos)blockpos$mutable, teleporter.frameBlock.get(), 3);
            }
        }
        BlockState blockstate = (BlockState)teleporter.portalBlock.get().m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)enterAxis);
        for (int j2 = 0; j2 < 2; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutable.m_122154_((Vec3i)blockpos, j2 * direction.m_122429_(), l2, j2 * direction.m_122431_());
                teleporter.level.m_7731_((BlockPos)blockpos$mutable, blockstate, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.m_7949_(), 2, 3));
    }

    private boolean checkRegionForPlacement(BlockPos pos, BlockPos.MutableBlockPos mutablePos, Direction facing, int offset) {
        Direction direction = facing.m_122427_();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                mutablePos.m_122154_((Vec3i)pos, facing.m_122429_() * i + direction.m_122429_() * offset, j, facing.m_122431_() * i + direction.m_122431_() * offset);
                if (j < 0 && !this.level.m_8055_((BlockPos)mutablePos).m_60767_().m_76333_()) {
                    return false;
                }
                if (j < 0 || this.level.m_46859_((BlockPos)mutablePos)) continue;
                return false;
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface ICreatePortalFuncion {
        public Optional<BlockUtil.FoundRectangle> apply(GelTeleporter var1, BlockPos var2, Direction.Axis var3);
    }

    public static enum CreatePortalBehavior {
        NETHER(GelTeleporter::createAndFindPortalNether),
        ON_SURFACE(GelTeleporter::createAndFindPortalSurface);

        private final ICreatePortalFuncion function;

        private CreatePortalBehavior(ICreatePortalFuncion function) {
            this.function = function;
        }

        public ICreatePortalFuncion get() {
            return this.function;
        }
    }
}

