/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.data_handler.handlers;

import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.core.SGAccessor;
import com.legacy.structure_gel.core.util.Internal;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public abstract class DataHandler<T extends DataHandler<T>> {
    public DataHandler(DataMap data) {
    }

    @Internal
    public void handleAll(BlockState dataHandler, BlockPos pos, WorldGenLevel level, Random rand, BoundingBox bounds, StructurePiece piece, boolean alwaysGenerate) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
        float chance = this.getProbability();
        if (alwaysGenerate || chance >= 1.0f || rand.nextFloat() < chance) {
            this.handle(dataHandler, pos, level, rand, bounds, piece);
        }
    }

    protected float getProbability() {
        return 1.0f;
    }

    protected abstract void handle(BlockState var1, BlockPos var2, WorldGenLevel var3, Random var4, BoundingBox var5, StructurePiece var6);

    protected BlockState createState(BlockState dataHandler, BlockState state) {
        BlockState newState = state;
        Direction facing = (Direction)dataHandler.m_61143_((Property)BlockStateProperties.f_61372_);
        newState = this.mergeProperty((Comparable)facing, newState, (Property)BlockStateProperties.f_61372_);
        newState = this.mergeProperty((Comparable)facing, newState, (Property)BlockStateProperties.f_61374_);
        newState = this.mergeProperty((Comparable)facing, newState, (Property)BlockStateProperties.f_61373_);
        Direction.Axis axis = facing.m_122434_();
        newState = this.mergeProperty((Comparable)axis, newState, (Property)BlockStateProperties.f_61365_);
        newState = this.mergeProperty((Comparable)axis, newState, (Property)BlockStateProperties.f_61364_);
        boolean waterlogged = (Boolean)dataHandler.m_61143_((Property)BlockStateProperties.f_61362_);
        newState = this.mergeProperty(waterlogged, newState, (Property)BlockStateProperties.f_61362_);
        return newState;
    }

    protected boolean createChest(StructurePiece piece, ServerLevelAccessor level, BoundingBox bounds, Random rand, BlockPos pos, ResourceLocation lootTable, @Nullable BlockState chestState) {
        return SGAccessor.STRUCTURE_PIECE_CREATE_CHEST.invoke(piece, level, bounds, rand, pos, lootTable, chestState);
    }

    protected <B extends Comparable<B>> BlockState mergeProperty(B valueToMerge, BlockState mergeInto, Property<B> property) {
        if (mergeInto.m_61138_(property) && property.m_6908_().contains(valueToMerge)) {
            return (BlockState)mergeInto.m_61124_(property, valueToMerge);
        }
        return mergeInto;
    }
}

