/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.api.biome_dictionary.IBiomeFilter;
import com.legacy.structure_gel.api.util.GelCollectors;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.AbstractConfigUtil;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.SimpleMapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraftforge.common.ForgeConfigSpec;

public final class StructureConfig
extends AbstractConfigUtil {
    private static final String DEFAULT_CONFIGURED_KEY = "configured";
    private final Storage storage = new Storage();
    @Nullable
    private ForgeConfigSpec.IntValue probability;
    @Nullable
    private ForgeConfigSpec.IntValue spacing;
    @Nullable
    private ForgeConfigSpec.IntValue offset;
    private final Map<String, ConfiguredConfig> configured = new HashMap<String, ConfiguredConfig>();

    private StructureConfig(Builder builder) {
        super(builder.structureName);
        ForgeConfigSpec.Builder configBuilder = builder.builder;
        configBuilder.push(builder.structureName);
        Builder.PlacementBuilder placementBuilder = builder.placementBuilder;
        if (placementBuilder != null) {
            configBuilder.push("placement");
            if (placementBuilder.spacing != null) {
                this.spacing = configBuilder.comment(this.configComment("The average distance between structures of this type, measured in chunks.", placementBuilder.spacing)).defineInRange("spacing", placementBuilder.spacing.intValue(), 1, Integer.MAX_VALUE);
            }
            if (placementBuilder.offset != null) {
                this.offset = configBuilder.comment(this.configComment("A random offset applied to spacing. Values closer to 0 produce a grid effect while values closer to spacing are more random.", placementBuilder.offset)).defineInRange("offset", placementBuilder.offset.intValue(), 0, Integer.MAX_VALUE);
            }
            if (placementBuilder.probability != null) {
                this.probability = configBuilder.comment(this.configComment("Percent chance of generating in an allowed chunk.", placementBuilder.probability)).defineInRange("probability", placementBuilder.probability.intValue(), 0, 100);
            }
            configBuilder.pop();
        }
        if (!builder.configuredBuilders.isEmpty()) {
            configBuilder.push("configured_structures");
            for (Map.Entry<String, Builder.ConfiguredBuilder> entry : builder.configuredBuilders.entrySet()) {
                String key = entry.getKey();
                configBuilder.push(key);
                ConfiguredConfig configuredConfig = new ConfiguredConfig();
                this.configured.put(key, configuredConfig);
                Builder.ConfiguredBuilder configuredBuilder = entry.getValue();
                if (configuredBuilder.biomes != null) {
                    configBuilder.push("biomes");
                    configuredConfig.biomes = configBuilder.comment(this.configComment("A filter for which biomes this structure should generate in. Entries are formatted as follows:\n - Biome: \"minecraft:plains\"\n - Biome Dictionary Entry: \"##structure_gel:birch_forest\"\n - Add ! to the start of an entry to exclude it: \"!##structure_gel:frozen_ocean\"\n - Biome Tag: \"#minecraft:is_ocean\". If using a biome tag, only one can be used and it must be by itself. This does not support \"!\"", configuredBuilder.biomes, "[\"##structure_gel:wooded\", \"!minecraft:flower_forest\"] This will include all wooded biomes except for flower forests.")).defineList("biomes", configuredBuilder.biomes, o -> true);
                    configBuilder.pop();
                }
                if (!configuredBuilder.spawns.isEmpty()) {
                    configBuilder.push("spawns");
                    JsonElement spawnsJson = (JsonElement)ConfiguredConfig.SPAWNS_CODEC.encode(configuredBuilder.spawns, (DynamicOps)JsonOps.INSTANCE, JsonOps.INSTANCE.mapBuilder()).build((Object)new JsonObject()).getOrThrow(false, s -> {});
                    String spawnsString = spawnsJson.toString().replace("\"", "'");
                    configuredConfig.spawns = configBuilder.comment(this.configComment("The mob spawns for this structure, formatted in json the same way that configured structure features have their data formatted in datapacks.", "\"" + spawnsString + "\"\n")).define("spawns", (Object)spawnsString);
                    configBuilder.pop();
                }
                if (configuredBuilder.dimensions != null) {
                    configBuilder.push("dimensions");
                    configuredConfig.dimensions = configBuilder.comment(this.configComment("What dimensions this structure should generate in. Leave empty to allow all dimensions.", configuredBuilder.dimensions, List.of("minecraft:overworld", "minecraft:the_nether"))).defineList("dimensions", configuredBuilder.dimensions, o -> true);
                    configBuilder.pop();
                }
                configBuilder.pop();
            }
            configBuilder.pop();
        }
        configBuilder.pop();
    }

    public static Builder builder(ForgeConfigSpec.Builder builder, String structureName) {
        return new Builder(builder, structureName);
    }

    public int getSpacing() {
        return this.storage.spacing;
    }

    public int getOffset() {
        return this.storage.offset;
    }

    public float getProbability() {
        return this.storage.probability;
    }

    public ConfiguredConfig getConfigured(String key) {
        ConfiguredConfig configured = this.configured.get(key);
        if (configured == null) {
            throw new NullPointerException("Attempted to get a ConfiguredConfig under a key that does not exist: \"" + key + "\"");
        }
        return configured;
    }

    public ConfiguredConfig getConfigured() {
        return this.getConfigured(DEFAULT_CONFIGURED_KEY);
    }

    @Override
    protected void reload() {
        if (this.spacing != null) {
            this.storage.spacing = (Integer)this.spacing.get();
        }
        this.storage.offset = this.offset != null ? (Integer)this.offset.get() : Math.max(this.storage.spacing, 0);
        if (this.probability != null) {
            this.storage.probability = (float)((Integer)this.probability.get()).intValue() / 100.0f;
        }
        for (ConfiguredConfig configured : this.configured.values()) {
            configured.reload();
        }
    }

    @Internal
    public void reloadBiomes() {
        this.configured.values().forEach(ConfiguredConfig::reloadBiomes);
    }

    public static final class Builder {
        private final ForgeConfigSpec.Builder builder;
        private final String structureName;
        @Nullable
        private PlacementBuilder placementBuilder = null;
        private final Map<String, ConfiguredBuilder> configuredBuilders = new HashMap<String, ConfiguredBuilder>();

        private Builder(ForgeConfigSpec.Builder builder, String structureName) {
            this.builder = builder;
            this.structureName = structureName;
        }

        public PlacementBuilder pushPlacement() {
            this.placementBuilder = new PlacementBuilder();
            return this.placementBuilder;
        }

        public Builder placement(int spacing, int offset, int probability) {
            this.pushPlacement().spacing(spacing).offset(offset).probability(probability).popPlacement();
            return this;
        }

        public ConfiguredBuilder pushConfigured(String key) throws IllegalArgumentException {
            if (this.configuredBuilders.containsKey(key)) {
                throw new IllegalArgumentException("A ConfiguredBuilder already exists under the name \"" + key + "\"");
            }
            ConfiguredBuilder configuredBuilder = new ConfiguredBuilder();
            this.configuredBuilders.put(key, configuredBuilder);
            return configuredBuilder;
        }

        public ConfiguredBuilder pushConfigured() throws IllegalArgumentException {
            return this.pushConfigured(StructureConfig.DEFAULT_CONFIGURED_KEY);
        }

        public StructureConfig build() {
            return new StructureConfig(this);
        }

        public final class PlacementBuilder {
            @Nullable
            private Integer spacing = null;
            @Nullable
            private Integer offset = null;
            @Nullable
            private Integer probability = null;

            private PlacementBuilder() {
            }

            public PlacementBuilder spacing(int spacing) {
                this.spacing = spacing;
                return this;
            }

            public PlacementBuilder offset(int offset) {
                this.offset = offset;
                return this;
            }

            public PlacementBuilder probability(int probability) {
                this.probability = probability;
                return this;
            }

            public Builder popPlacement() {
                return Builder.this;
            }
        }

        public final class ConfiguredBuilder {
            @Nullable
            private List<String> biomes;
            private final Map<MobCategory, StructureSpawnOverride> spawns = new HashMap<MobCategory, StructureSpawnOverride>();
            @Nullable
            private List<String> dimensions;

            private ConfiguredBuilder() {
            }

            public ConfiguredBuilder biomes(Collection<String> biomes) {
                this.biomes = List.copyOf(biomes);
                return this;
            }

            public ConfiguredBuilder biomes(String ... biomes) {
                return this.biomes(List.of(biomes));
            }

            public ConfiguredBuilder biomes(BiomeType biomes) {
                return this.biomes(biomes.toFilterStrings(true));
            }

            public ConfiguredBuilder biomes(BiomeType included, BiomeType excluded) {
                return this.biomes(GelCollectors.addToList(included.toFilterStrings(true), excluded.toFilterStrings(false)));
            }

            public ConfiguredBuilder biomes(TagKey<Biome> biomeTag) {
                return this.biomes(List.of("#" + biomeTag.f_203868_()));
            }

            public ConfiguredBuilder spawns(MobCategory category, StructureSpawnOverride.BoundingBoxType boundingBoxType, MobSpawnSettings.SpawnerData ... spawns) {
                this.spawns.put(category, new StructureSpawnOverride(boundingBoxType, WeightedRandomList.m_146330_((WeightedEntry[])spawns)));
                return this;
            }

            public ConfiguredBuilder dimensions(Collection<String> dimensions) {
                this.dimensions = List.copyOf(dimensions);
                return this;
            }

            public ConfiguredBuilder dimensions(String ... dimensions) {
                return this.dimensions(List.of(dimensions));
            }

            @SafeVarargs
            public final ConfiguredBuilder dimensions(ResourceKey<Level> ... dimensions) {
                return this.dimensions(Arrays.stream(dimensions).map(ResourceKey::m_135782_).map(ResourceLocation::toString).toList());
            }

            public Builder popConfigured() {
                return Builder.this;
            }
        }
    }

    private static class Storage {
        private int spacing = 16;
        private int offset = Math.max(this.spacing, 0);
        private float probability = 1.0f;

        private Storage() {
        }

        private static class ConfiguredStorage {
            private HolderSet<Biome> biomeFilter = BiomeDictionary.EMPTY;
            private Map<MobCategory, StructureSpawnOverride> spawns = new HashMap<MobCategory, StructureSpawnOverride>();
            private Set<ResourceKey<Level>> dimensions = new HashSet<ResourceKey<Level>>();

            private ConfiguredStorage() {
            }
        }
    }

    public class ConfiguredConfig {
        private final Storage.ConfiguredStorage storage = new Storage.ConfiguredStorage();
        @Nullable
        private ForgeConfigSpec.ConfigValue<List<? extends String>> biomes;
        @Nullable
        private ForgeConfigSpec.ConfigValue<String> spawns;
        @Nullable
        private ForgeConfigSpec.ConfigValue<List<? extends String>> dimensions;
        private static final SimpleMapCodec<MobCategory, StructureSpawnOverride> SPAWNS_CODEC = Codec.simpleMap((Codec)MobCategory.f_21584_, (Codec)StructureSpawnOverride.f_210042_, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])MobCategory.values()));

        private ConfiguredConfig() {
        }

        public HolderSet<Biome> getBiomes() {
            return this.storage.biomeFilter;
        }

        @Nullable
        public StructureSpawnOverride getSpawns(MobCategory category) {
            return this.storage.spawns.get(category);
        }

        public Set<ResourceKey<Level>> getDimensions() {
            return this.storage.dimensions;
        }

        private void reload() {
            this.reloadBiomes();
            this.parseSpawns();
            this.parseDimensions();
        }

        public void reloadBiomes() {
            if (this.biomes != null) {
                this.storage.biomeFilter = this.parseBiomeFilter((List)this.biomes.get());
            }
        }

        private HolderSet<Biome> parseBiomeFilter(List<? extends String> biomeConfig) {
            if (biomeConfig.size() == 1) {
                String s = biomeConfig.get(0);
                boolean isExcluded = s.startsWith("!");
                String active = s.replace("!", "");
                if (active.startsWith("#") && !active.startsWith("##")) {
                    if (ResourceLocation.m_135830_((String)(active = active.replace("#", "")))) {
                        if (isExcluded) {
                            StructureGelMod.logWarn("A vanilla biome tag exists in a config for {} and is formatted with \"!\". This behavior is not supported for vanilla tags: {}", StructureConfig.this.name, s);
                        }
                        return BuiltinRegistries.f_123865_.m_203561_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(active)));
                    }
                    StructureConfig.this.logResourceLocationError(s, "It should be formatted as \"#mod_name:biome_tag_name\"");
                }
            }
            if (!biomeConfig.isEmpty()) {
                BiomeType.Builder included = BiomeType.builder(StructureGelMod.locate("included"));
                BiomeType.Builder excluded = BiomeType.builder(StructureGelMod.locate("excluded"));
                for (String string : biomeConfig) {
                    boolean isExcluded = string.startsWith("!");
                    String active = string.replace("!", "");
                    int mode = active.startsWith("##") ? 2 : (active.startsWith("#") ? 1 : 0);
                    if (ResourceLocation.m_135830_((String)(active = active.replace("#", "")))) {
                        BiomeType.Builder builder;
                        ResourceLocation location = new ResourceLocation(active);
                        BiomeType.Builder builder2 = builder = isExcluded ? excluded : included;
                        if (mode == 2) {
                            builder.parents(location);
                            continue;
                        }
                        if (mode == 1) {
                            StructureGelMod.logWarn("A vanilla biome tag exists in a config for {}, but multiple biome entries are present. Only one vanilla biome tag is allowed, and it must be by itself. Tag: {}", StructureConfig.this.name, string);
                            continue;
                        }
                        if (mode != 0) continue;
                        builder.biomes(location);
                        continue;
                    }
                    String string2 = isExcluded ? "!" : "";
                    String format = string2 + (switch (mode) {
                        case 2 -> "##mod_name:biome_dictionary_entry_name";
                        case 1 -> "#mod_name:biome_tag_name";
                        default -> "mod_name:biome_name";
                    });
                    StructureConfig.this.logResourceLocationError(string, "It should be formatted as \"" + format + "\"");
                }
                return new IBiomeFilter.IncludeExcludeBiomeFilter(included.build(), excluded.build());
            }
            return HolderSet.m_205809_((Holder[])new Holder[0]);
        }

        private void parseSpawns() {
            if (this.spawns != null) {
                try {
                    Map decoded;
                    JsonElement json = JsonParser.parseString((String)((String)this.spawns.get()));
                    this.storage.spawns = decoded = (Map)SPAWNS_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (MapLike)JsonOps.INSTANCE.getMap(json).getOrThrow(false, s -> {})).getOrThrow(false, s -> {});
                }
                catch (Exception e) {
                    StructureGelMod.logError("Config based mob spawns could not be read for structure = {}", StructureConfig.this.name);
                    StructureGelMod.logError(e, new Object[0]);
                }
            }
        }

        private void parseDimensions() {
            if (this.dimensions != null) {
                HashSet<ResourceKey<Level>> dims = new HashSet<ResourceKey<Level>>();
                for (String dim : (List)this.dimensions.get()) {
                    try {
                        if (ResourceLocation.m_135830_((String)dim)) {
                            ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dim));
                            dims.add((ResourceKey<Level>)levelKey);
                            continue;
                        }
                        StructureConfig.this.logResourceLocationError(dim, "It should be formatted as \"#mod_name:dimension_name\"");
                    }
                    catch (Exception e) {
                        StructureGelMod.logError("Dimension config could not be read for structure = {}", StructureConfig.this.name);
                        StructureGelMod.logError(e, new Object[0]);
                    }
                }
                this.storage.dimensions = dims;
            }
        }
    }
}

