/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures;

import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.entities.passive.ShadeMonitorEntity;
import com.legacy.blue_skies.entities.villager.GatekeeperEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.StructureChestUtil;
import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.api.structure.GelJigsawStructure;
import com.legacy.structure_gel.api.structure.jigsaw.AbstractGelStructurePiece;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class GatekeeperHouseStructure
extends GelJigsawStructure<JigsawConfiguration> {
    public static final Map<BiomeType, String> BIOMES = Map.of(BiomeDictionary.PLAINS, "plains", BiomeDictionary.SAVANNA, "plains", BiomeDictionary.SNOWY, "snowy", BiomeDictionary.SNOWY_SPRUCE_FOREST, "snowy", BiomeDictionary.SPRUCE_FOREST, "snowy", BiomeDictionary.MOUNTAIN, "mountain");

    public GatekeeperHouseStructure(Codec<JigsawConfiguration> config) {
        super(config, 0, true, true, context -> true, Piece::new);
    }

    public float getProbability() {
        return BlueSkiesConfig.COMMON.getGatekeeperHouseChance();
    }

    public int getSpacing() {
        return 33;
    }

    public int getOffset() {
        return this.getSpacing() / 2;
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(StructureManager structureManager, StructurePoolElement jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds) {
            super(structureManager, jigsawPiece, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(context, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, Random rand, BoundingBox bounds) {
            String[] data;
            this.setAir((LevelAccessor)level, pos);
            if (key.equals("gatekeeper")) {
                entity = (GatekeeperEntity)this.createEntity(SkiesEntityTypes.GATEKEEPER, level, pos, this.f_72599_);
                ((GatekeeperEntity)((Object)entity)).m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                ((GatekeeperEntity)((Object)entity)).homePos = pos;
                level.m_7967_((Entity)entity);
            } else if (key.equals("shade_monitor")) {
                entity = (ShadeMonitorEntity)this.createEntity(SkiesEntityTypes.SHADE_MONITOR, level, pos, this.f_72599_);
                ((ShadeMonitorEntity)((Object)entity)).m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                level.m_7967_((Entity)entity);
            }
            if (key.startsWith("barrel")) {
                data = key.split("-");
                if (data.length > 2) {
                    level.m_7731_(pos, ((BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.m_122402_((String)data[1]))).rotate((LevelAccessor)level, pos, this.f_72599_), 2);
                    RandomizableContainerBlockEntity.m_59620_((BlockGetter)level, (Random)rand, (BlockPos)pos, (ResourceLocation)SkiesLootProv.GATEKEEPER_LOOT[Integer.valueOf(data[2])]);
                }
            } else if (key.startsWith("chest") && (data = key.split("-")).length > 4) {
                StructureChestUtil.createChest(pos, level, rand, this.f_72599_, data[1], data[2], data[3], SkiesLootProv.GATEKEEPER_LOOT[Integer.valueOf(data[4])]);
            }
        }

        public StructurePieceType m_210000_() {
            return SkiesStructures.GATEKEEPER_HOUSE.getPieceType();
        }
    }
}

