/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBiomeDict;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesBlockEntityTypes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesConfiguredCarvers;
import com.legacy.blue_skies.registries.SkiesConfiguredFeatures;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesFeaturePlacements;
import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesLootFunctions;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.registries.SkiesRecipes;
import com.legacy.blue_skies.registries.SkiesSchedules;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.structure_gel.api.events.RegisterBiomeDictionaryTypeEvent;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SkiesRegistry {
    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        SkiesContainers.init(event);
    }

    @SubscribeEvent
    public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
        SkiesParticles.init(event);
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        SkiesParticles.registerFactories(event);
    }

    @SubscribeEvent
    public static void registerEffects(RegistryEvent.Register<MobEffect> event) {
        SkiesEffects.init(event);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        SkiesSounds.init();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        SkiesBlocks.init(event);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        SkiesItems.init(event);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<RecipeSerializer<?>> event) {
        SkiesRecipes.init(event);
        SkiesLootFunctions.init();
    }

    @SubscribeEvent
    public static void registerTileEntityTypes(RegistryEvent.Register<BlockEntityType<?>> event) {
        SkiesBlockEntityTypes.init(event);
    }

    @SubscribeEvent
    public static void onRegisterSchedules(RegistryEvent.Register<Schedule> event) {
        SkiesSchedules.init(event);
    }

    @SubscribeEvent
    public static void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        SkiesEntityTypes.init(event);
        SkiesVillagers.initVillagerTypes();
    }

    @SubscribeEvent
    public static void registerVillagerProfessions(RegistryEvent.Register<VillagerProfession> event) {
        SkiesVillagers.init(event);
    }

    @SubscribeEvent
    public static void registerPointsOfInterest(RegistryEvent.Register<PoiType> event) {
        SkiesPoiTypes.init(event);
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        SkiesBiomes.init(event);
    }

    @SubscribeEvent
    public static void registerBiomeDict(RegisterBiomeDictionaryTypeEvent event) {
        SkiesBiomeDict.init(event);
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        SkiesFeatures.init(event);
        SkiesConfiguredFeatures.init();
        SkiesFeaturePlacements.init();
        SkiesConfiguredCarvers.init();
    }

    @SubscribeEvent
    public static void registerWorldCarvers(RegistryEvent.Register<WorldCarver<?>> event) {
        SkiesFeatures.Carvers.init(event);
    }

    @SubscribeEvent
    public static void registerStructures(RegistryEvent.Register<StructureFeature<?>> event) {
        SkiesStructures.init(event);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String key, T object) {
        SkiesRegistry.register(registry, BlueSkies.locate(key), object);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, ResourceLocation key, T object) {
        object.setRegistryName(key);
        registry.register(object);
    }
}

