/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.asm_hooks.PlayerHooks;
import com.legacy.blue_skies.block_entity.KeystoneBlockEntity;
import com.legacy.blue_skies.blocks.misc.SkyWebbingBlock;
import com.legacy.blue_skies.blocks.util.ToolCompat;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.capability.util.CapabilityProvider;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.tags.SkiesItemTags;
import com.legacy.blue_skies.entities.util.base.SkiesBossEntity;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.SpawnParticlePacket;
import com.legacy.blue_skies.network.s_to_c.SyncItemInSlotPacket;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.registries.SkiesStats;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.util.GeometryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SkiesPlayerEvents {
    public static int spawnDimensionID = 0;

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            BlueSkiesData.syncManagersToClient(event.getPlayer());
        } else {
            event.getPlayerList().m_11314_().forEach(player -> BlueSkiesData.syncManagersToClient(player));
        }
    }

    @SubscribeEvent
    public static void onAdvancementGranted(AdvancementEvent event) {
        if (event.getAdvancement().m_138327_().equals((Object)BlueSkies.locate("everbright/enter")) || event.getAdvancement().m_138327_().equals((Object)BlueSkies.locate("everdawn/enter"))) {
            EntityUtil.sendJournalToast(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof Player && !event.getEntity().f_19853_.f_46443_) {
            Player player = (Player)event.getEntityLiving();
            SkiesPlayer.ifPresent(player, skiesPlayer -> {
                skiesPlayer.getArcInventory().getStacks().forEach(stack -> {
                    if (stack.m_41720_() instanceof IArcItem) {
                        ((IArcItem)stack.m_41720_()).onHit((ItemStack)stack, player, event);
                    }
                });
                float newHealth = skiesPlayer.getNatureHealth() - event.getAmount();
                skiesPlayer.setNatureHealth(Math.max(0.0f, newHealth));
                event.setAmount(newHealth < 0.0f ? newHealth * -1.0f : 0.0f);
            });
        }
    }

    @SubscribeEvent
    public static void onCapabilityAttached(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(SkiesPlayer.INSTANCE).isPresent()) {
            event.addCapability(BlueSkies.locate("player_capability"), new CapabilityProvider<SkiesPlayer>(new SkiesPlayer((Player)event.getObject())));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void teleportToKeystone(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            SkiesPlayer.ifPresent((Player)event.getEntity(), skiesPlayer -> {
                if (!skiesPlayer.getPlayer().f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && SkiesPlayerEvents.inBossFight(skiesPlayer.getPlayer())) {
                    skiesPlayer.teleportToNearestKeystone();
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            SkiesPlayer.ifPresent((Player)event.getEntity(), skiesPlayer -> skiesPlayer.onDeath());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        ISkiesPlayer original = SkiesPlayer.get(event.getOriginal());
        ISkiesPlayer clone = SkiesPlayer.get(event.getPlayer());
        CompoundTag compound = new CompoundTag();
        if (original != null && clone != null) {
            if (event.isWasDeath()) {
                clone.syncDataToClient();
                original.writeAdditional(compound);
                clone.read(compound);
                if (!clone.getPlayer().f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                    clone.getArcInventory().m_6211_();
                }
            } else {
                original.writeAdditional(compound);
                clone.read(compound);
                clone.syncDataToClient();
            }
            if (original.getSupporterPet() != null) {
                original.getSupporterPet().m_146870_();
                original.setSupporterPet(null);
            }
            clone.setSupporterPet(null);
            clone.checkAndSpawnPet();
        }
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SkiesPlayer.ifPresent(event.getPlayer(), skiesPlayer -> skiesPlayer.syncDataToClient());
        if (spawnDimensionID > 0 && spawnDimensionID <= 2) {
            MinecraftServer server = event.getPlayer().m_20194_();
            if (server == null || !(event.getPlayer() instanceof ServerPlayer)) {
                return;
            }
            ServerLevel transferWorld = server.m_129880_(spawnDimensionID == 1 ? SkiesDimensions.everbrightKey() : SkiesDimensions.everdawnKey());
            SkiesPlayerEvents.teleportSafely((ServerPlayer)event.getPlayer(), transferWorld, event.getPlayer().m_142538_());
            spawnDimensionID = 0;
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity != null && entity instanceof Player) {
            SkiesPlayer.ifPresent((Player)entity, skiesPlayer -> {
                skiesPlayer.getArcInventory().refreshArcs((Player)entity);
                skiesPlayer.syncDataToClient();
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        SkiesPlayer.ifPresent(event.getPlayer(), skiesPlayer -> {
            if (skiesPlayer.getSupporterPet() != null) {
                skiesPlayer.setSupporterPet(null);
            }
            skiesPlayer.checkAndSpawnPet();
            skiesPlayer.syncDataToClient();
        });
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        SkiesPlayer.ifPresent(event.getPlayer(), skiesPlayer -> skiesPlayer.syncDataToClient());
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        Player player = event.getPlayer();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.m_21120_(hand);
        if (entity instanceof Cow) {
            Cow cow = (Cow)entity;
            if (heldItem.m_41720_() == SkiesItems.ventium_bucket && !player.m_150110_().f_35937_ && !cow.m_6162_()) {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)SkiesItems.ventium_milk_bucket));
                } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)SkiesItems.ventium_milk_bucket))) {
                    player.m_36176_(new ItemStack((ItemLike)SkiesItems.ventium_milk_bucket), false);
                }
            }
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (player.m_6144_() && heldItem.m_41720_() == SkiesBlocks.bag_of_spoils.m_5456_() && !player.m_36335_().m_41519_(heldItem.m_41720_())) {
                if (player.f_19853_.f_46443_) {
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    return;
                }
                if (villager.m_7141_().m_35571_() == SkiesVillagers.NIGHTWATCHER || EntityUtil.canEntitySeePos((LivingEntity)villager, player.m_142538_())) {
                    if (entity.f_19853_ instanceof ServerLevel) {
                        ((ServerLevel)entity.f_19853_).m_8670_(ReputationEventType.f_26987_, (Entity)player, (ReputationEventHandler)villager);
                        entity.f_19853_.m_7605_((Entity)villager, (byte)13);
                    }
                    entity.m_5496_(SoundEvents.f_12507_, 1.0f, EntityUtil.getSoundPitchWithStart(entity.f_19853_.f_46441_, 1.0f));
                    player.m_21011_(hand, true);
                } else {
                    try {
                        CompoundTag compoundnbt = heldItem.m_41737_("BlockEntityTag");
                        NonNullList originalItems = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
                        ArrayList trueItems = Lists.newArrayList();
                        if (compoundnbt == null) {
                            compoundnbt = new CompoundTag();
                            ContainerHelper.m_18976_((CompoundTag)compoundnbt, (NonNullList)originalItems, (boolean)false);
                            heldItem.m_41700_("BlockEntityTag", (Tag)compoundnbt);
                        }
                        if (compoundnbt.m_128425_("Items", 9)) {
                            ContainerHelper.m_18980_((CompoundTag)compoundnbt, (NonNullList)originalItems);
                            for (ItemStack itemstack : originalItems) {
                                if (itemstack.m_41619_()) continue;
                                trueItems.add(itemstack);
                            }
                        }
                        if (trueItems.size() <= 5 && player.f_19853_ instanceof ServerLevel) {
                            List<ItemStack> gifts = SkiesPlayerEvents.getVillagerGifts(villager);
                            ItemStack gift = gifts.get(player.f_19853_.f_46441_.nextInt(gifts.size()));
                            boolean hasItem = false;
                            for (ItemStack stack : trueItems) {
                                if (stack == ItemStack.f_41583_ || stack.m_41720_() != gift.m_41720_() || stack.m_41613_() >= stack.m_41741_()) continue;
                                stack.m_41764_(stack.m_41613_() + 1);
                                hasItem = true;
                                break;
                            }
                            if (!hasItem && trueItems.size() < 5) {
                                originalItems.set(trueItems.size(), (Object)gift);
                            }
                            ContainerHelper.m_18976_((CompoundTag)compoundnbt, (NonNullList)originalItems, (boolean)false);
                            heldItem.m_41700_("BlockEntityTag", (Tag)compoundnbt);
                            if (!hasItem && trueItems.size() < 5 || hasItem) {
                                entity.m_5496_(SoundEvents.f_12019_, 1.0f, 0.8f);
                                player.m_21011_(hand, true);
                                player.m_36220_(SkiesStats.VILLAGERS_PICKPOCKETED);
                                if (!player.m_7500_()) {
                                    player.m_36335_().m_41524_(heldItem.m_41720_(), 120);
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void onToolUse(BlockEvent.BlockToolModificationEvent event) {
        Block result;
        ToolAction toolAction = event.getToolAction();
        if (toolAction == ToolActions.AXE_STRIP) {
            BlockState finalState = event.getFinalState();
            Block result2 = ToolCompat.AXE_STRIPPING.get(finalState.m_60734_());
            if (result2 != null) {
                event.setFinalState(result2.m_152465_(finalState));
            }
        } else if (toolAction == ToolActions.HOE_TILL && (result = ToolCompat.HOE_TILLING.get(event.getFinalState().m_60734_())) != null) {
            event.setFinalState(result.m_49966_());
        }
    }

    private static List<ItemStack> getVillagerGifts(Villager villager) {
        if (villager.m_6162_()) {
            return ImmutableList.of((Object)new ItemStack((ItemLike)Items.f_41940_));
        }
        VillagerProfession villagerprofession = villager.m_7141_().m_35571_();
        if (GiveGiftToHero.f_147550_.containsKey(villagerprofession)) {
            LootTable loottable = villager.f_19853_.m_142572_().m_129898_().m_79217_((ResourceLocation)GiveGiftToHero.f_147550_.get(villagerprofession));
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)villager.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)villager.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)villager).m_78977_(villager.m_21187_());
            return loottable.m_79129_(lootcontext$builder.m_78975_(LootContextParamSets.f_81416_));
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42404_), new ItemStack((ItemLike)Items.f_42401_), new ItemStack((ItemLike)Items.f_41863_), new ItemStack((ItemLike)Items.f_42329_)});
    }

    private static ItemStack getSmeltedResult(ItemStack stack, Level world) {
        ItemStack output = stack;
        SimpleContainer iInventory = new SimpleContainer(new ItemStack[]{stack});
        output = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)iInventory, world).map(arg_0 -> SkiesPlayerEvents.lambda$getSmeltedResult$9((Container)iInventory, arg_0)).orElse(stack);
        output.m_41764_(stack.m_41613_());
        return output;
    }

    @SubscribeEvent
    public static void attackEntity(AttackEntityEvent event) {
        Player player = event.getPlayer();
        if (player.m_21205_().m_204117_(SkiesItemTags.HORIZONITE_TOOLS)) {
            event.getTarget().m_20254_(3);
        }
    }

    @SubscribeEvent
    public static void entityAttackedEvent(LivingAttackEvent event) {
        Player player;
        Item playerItem;
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Player && (playerItem = (player = (Player)entity).m_21205_().m_41720_()) == SkiesItems.debug_sword && !BlueSkies.ML_SUPPORTER.getRank(player).isDeveloper() && !BlueSkies.IDE) {
            BlueSkies.LOGGER.debug(player.m_7755_().m_6111_() + " tried to use the debug sword.");
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onSleepTimeCheck(SleepingTimeCheckEvent event) {
        if (SkiesDimensions.inSkyDimension((Entity)event.getPlayer())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockPos pos = event.getPos();
        BlockState state = event.getPlacedBlock();
        if (player.m_7500_() || !SkiesPlayerEvents.inBossFight((Player)player) && DungeonBalancingChecks.playerCanPlaceInDungeon((Player)player, event.getWorld(), pos, state.m_60734_())) {
            return;
        }
        player.m_5661_((Component)new TranslatableComponent(DungeonBalancingChecks.isPosInBossRoom(player.f_19853_, pos) ? "gui.blue_skies.tooltip.boss_room_denied_interaction" : "gui.blue_skies.tooltip.progression_denied_interaction"), true);
        event.setCanceled(true);
        PacketHandler.sendToClient(new SyncItemInSlotPacket(player.m_21205_(), player.m_21206_(), player.m_150109_().f_35977_), player);
    }

    @SubscribeEvent
    public static void harvestCheck(PlayerEvent.HarvestCheck event) {
        Item item = event.getPlayer().m_21205_().m_41720_();
        if (item != null && PlayerHooks.webHarvestCheck(event.getTargetBlock().m_60734_(), item)) {
            event.setCanHarvest(true);
        }
        if (PlayerHooks.isBreakingNerfed(item, event.getPlayer(), event.getTargetBlock())) {
            event.setCanHarvest(false);
        }
    }

    @SubscribeEvent
    public static void destroyBlock(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        Player player = event.getPlayer();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        Item item = player.m_21205_().m_41720_();
        if (state.m_60734_() instanceof SpawnerBlock && EntityUtil.isInDungeon((Level)level, pos)) {
            event.setExpToDrop(3);
        }
        if (!player.m_7500_()) {
            if (!(state.m_60734_() instanceof BaseFireBlock || !SkiesPlayerEvents.inBossFight(player) && DungeonBalancingChecks.playerCanBreakDungeon(player, level, pos))) {
                player.m_5661_((Component)new TranslatableComponent(DungeonBalancingChecks.isPosInBossRoom(player.f_19853_, pos) ? "gui.blue_skies.tooltip.boss_room_denied_interaction" : "gui.blue_skies.tooltip.progression_denied_interaction"), true);
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                return;
            }
            if (player.m_36298_(state)) {
                if (player.m_21205_().m_204117_(SkiesItemTags.HORIZONITE_TOOLS)) {
                    List drops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)player, (ItemStack)player.m_21205_());
                    drops.forEach(itemStack -> {
                        ItemStack smeltedStack = SkiesPlayerEvents.getSmeltedResult(itemStack, (Level)level);
                        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)smeltedStack);
                        if (smeltedStack != itemStack) {
                            PacketHandler.sendToAllClients(new SpawnParticlePacket(0, pos), (Level)level);
                        }
                    });
                    level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    return;
                }
                if (item == SkiesItems.ventium_shears) {
                    List drops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)player, (ItemStack)new ItemStack((ItemLike)Items.f_42574_));
                    drops.forEach(itemStack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack));
                    level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    return;
                }
            }
            if (PlayerHooks.isBreakingNerfed(item, player, state)) {
                event.setCanceled(true);
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onBucketFill(FillBucketEvent event) {
        Player player = event.getPlayer();
        if (!player.m_7500_() && !DungeonBalancingChecks.isProgressedForPos(player, new BlockPos(event.getTarget().m_82450_()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPearlTeleport(EntityTeleportEvent.EnderPearl event) {
        ServerPlayer player = event.getPlayer();
        if (!(player.m_7500_() || !SkiesDimensions.inSkyDimension((Entity)player) || DungeonBalancingChecks.isProgressedForPos((Player)player, new BlockPos(event.getTarget()).m_7495_()) && DungeonBalancingChecks.isProgressedForPos((Player)player, new BlockPos(event.getTarget())))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onChorusTeleport(EntityTeleportEvent.ChorusFruit event) {
        Player player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_7500_() || !SkiesDimensions.inSkyDimension((Entity)player) || DungeonBalancingChecks.isProgressedForPos(player, new BlockPos(event.getTarget()).m_7495_()) && DungeonBalancingChecks.isProgressedForPos(player, new BlockPos(event.getTarget())))) {
            event.setCanceled(true);
        }
    }

    public static boolean inBossFight(Player player) {
        AABB radiusCheck = new AABB(player.m_142538_()).m_82377_(25.0, 15.0, 25.0);
        List illagerBossList = player.f_19853_.m_45976_(SkiesIllagerBossEntity.class, radiusCheck);
        List bossList = player.f_19853_.m_45976_(SkiesBossEntity.class, radiusCheck);
        return !illagerBossList.isEmpty() || !bossList.isEmpty();
    }

    private static ServerPlayer teleportSafely(ServerPlayer player, ServerLevel transferWorld, BlockPos pos) {
        player.m_8999_(transferWorld, (double)pos.m_123341_(), 100.0, (double)pos.m_123343_(), player.m_146908_(), player.m_146909_());
        int maxY = transferWorld.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
        player.m_8999_(transferWorld, (double)pos.m_123341_(), (double)maxY, (double)pos.m_123343_(), player.m_146908_(), player.m_146909_());
        return player;
    }

    private static /* synthetic */ ItemStack lambda$getSmeltedResult$9(Container iInventory, SmeltingRecipe furnaceRecipe) {
        return furnaceRecipe.m_5874_(iInventory);
    }

    public static class DungeonBalancingChecks {
        private static final Set<Block> GENERIC_PLACEABLES = Set.of(Blocks.f_50081_, Blocks.f_50082_, Blocks.f_50139_, Blocks.f_50140_, SkiesBlocks.moonstone);
        private static final Set<Block> GENERIC_BREAKABLES = Set.of(Blocks.f_50085_, Blocks.f_50033_, Blocks.f_50081_, Blocks.f_50082_, Blocks.f_50139_, Blocks.f_50140_, SkiesBlocks.moonstone);
        private static final Set<Block> NATURE_BREAKABLES = Set.of(SkiesBlocks.starlit_chest, SkiesBlocks.cherry_chest);
        private static final Set<Block> POISON_BREAKABLES = Set.of(SkiesBlocks.maple_chest);

        private static boolean isOurs(String mod) {
            return "blue_skies".equals(mod) || "minecraft".equals(mod);
        }

        public static boolean playerCanPlaceInDungeon(Player player, LevelAccessor levelAccessor, BlockPos pos, Block placingBlock) {
            Level level;
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)levelAccessor;
                v0 = sl;
            } else {
                v0 = level = player.f_19853_;
            }
            if (player instanceof FakePlayer) {
                return !EntityUtil.isInDungeon(level, pos);
            }
            if (DungeonBalancingChecks.isPosInBossRoom(level, pos)) {
                return false;
            }
            return SkiesPlayer.getIfPresent(player, skyPlayer -> {
                if (skyPlayer.getBrightProgression() < 1 && EntityUtil.isPosInStructure(level, pos, SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()) || skyPlayer.getDawnProgression() < 1 && EntityUtil.isPosInStructure(level, pos, SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure())) {
                    return DungeonBalancingChecks.genericBlockPlaceCheck(placingBlock);
                }
                if (skyPlayer.getBrightProgression() < 2 && EntityUtil.isPosInStructure(level, pos, SkiesStructures.NATURE_DUNGEON.getStructure()) || pos.m_123342_() < 64 && skyPlayer.getDawnProgression() < 2 && EntityUtil.isPosInStructure(level, pos, SkiesStructures.POISON_DUNGEON.getStructure())) {
                    return DungeonBalancingChecks.genericBlockPlaceCheck(placingBlock);
                }
                return true;
            }, () -> {
                BlueSkies.LOGGER.error("Blue Skies' player capability wasn't present for {} when trying to do a dungeon block place check. This should be reported if happening consistently!", (Object)player.m_142081_().toString());
                return !EntityUtil.isInDungeon(level, pos);
            });
        }

        private static boolean genericBlockPlaceCheck(Block block) {
            return GENERIC_PLACEABLES.contains(block) || block instanceof BedBlock;
        }

        public static boolean playerCanBreakDungeon(Player player, ServerLevel level, BlockPos pos) {
            if (player instanceof FakePlayer) {
                return !EntityUtil.isInDungeon((Level)level, pos);
            }
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            ResourceLocation registryName = block.getRegistryName();
            if (registryName == null) {
                return true;
            }
            if (DungeonBalancingChecks.isPosInBossRoom((Level)level, pos)) {
                return !DungeonBalancingChecks.isOurs(registryName.m_135827_());
            }
            return SkiesPlayer.getIfPresent(player, skyPlayer -> {
                if (skyPlayer.getBrightProgression() < 1 && EntityUtil.isPosInStructure((Level)level, pos, SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()) || skyPlayer.getDawnProgression() < 1 && EntityUtil.isPosInStructure((Level)level, pos, SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure())) {
                    return DungeonBalancingChecks.genericBlockBreakCheck(block, registryName);
                }
                if (skyPlayer.getBrightProgression() < 2 && EntityUtil.isPosInStructure((Level)level, pos, SkiesStructures.NATURE_DUNGEON.getStructure())) {
                    return NATURE_BREAKABLES.contains(block) || DungeonBalancingChecks.genericBlockBreakCheck(block, registryName);
                }
                if (pos.m_123342_() < 64 && skyPlayer.getDawnProgression() < 2 && EntityUtil.isPosInStructure((Level)level, pos, SkiesStructures.POISON_DUNGEON.getStructure())) {
                    return POISON_BREAKABLES.contains(block) || block instanceof SkyWebbingBlock && (Boolean)state.m_61143_((Property)SkyWebbingBlock.HAS_COLLISION) == false || DungeonBalancingChecks.genericBlockBreakCheck(block, registryName);
                }
                return true;
            }, () -> {
                BlueSkies.LOGGER.error("Blue Skies' player capability wasn't present for {} when trying to do a dungeon block break check. This should be reported if happening consistently!", (Object)player.m_142081_().toString());
                return !EntityUtil.isInDungeon((Level)level, pos);
            });
        }

        private static boolean genericBlockBreakCheck(Block block, @Nonnull ResourceLocation registryName) {
            return GENERIC_BREAKABLES.contains(block) || block instanceof BedBlock || !DungeonBalancingChecks.isOurs(registryName.m_135827_());
        }

        public static boolean isProgressedForPos(Player player, BlockPos pos) {
            if (player instanceof FakePlayer) {
                return !EntityUtil.isInDungeon(player.f_19853_, pos);
            }
            if (DungeonBalancingChecks.isPosInBossRoom(player.f_19853_, pos)) {
                return false;
            }
            return SkiesPlayer.getIfPresent(player, skyPlayer -> {
                if (skyPlayer.getBrightProgression() < 1 && EntityUtil.isPosInStructure(player.f_19853_, pos, SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()) || skyPlayer.getDawnProgression() < 1 && EntityUtil.isPosInStructure(player.f_19853_, pos, SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure())) {
                    return false;
                }
                if (skyPlayer.getBrightProgression() < 2 && EntityUtil.isPosInStructure(player.f_19853_, pos, SkiesStructures.NATURE_DUNGEON.getStructure())) {
                    return false;
                }
                if (pos.m_123342_() < 64 && skyPlayer.getDawnProgression() < 2 && EntityUtil.isPosInStructure(player.f_19853_, pos, SkiesStructures.POISON_DUNGEON.getStructure())) {
                    return false;
                }
                return true;
            }, () -> {
                BlueSkies.LOGGER.error("Blue Skies' player capability wasn't present for {} when trying to a positional progression check. This should be reported if happening consistently!", (Object)player.m_142081_().toString());
                return false;
            });
        }

        public static boolean isPosInBossRoom(Level level, BlockPos pos) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (EntityUtil.isInDungeon(level, pos)) {
                    BlockEntity blockEntity;
                    int distance = 45;
                    PoiManager poiManager = serverLevel.m_8904_();
                    poiManager.m_27056_((LevelReader)serverLevel, pos, distance);
                    Optional optional = serverLevel.m_8904_().m_27166_(poiType -> poiType == SkiesPoiTypes.KEYSTONE, pos, distance, PoiManager.Occupancy.ANY).findFirst();
                    if (optional.isPresent() && (blockEntity = serverLevel.m_7702_(((PoiRecord)optional.get()).m_27257_())) instanceof KeystoneBlockEntity) {
                        boolean isInCeilingRange;
                        KeystoneBlockEntity keystoneTile = (KeystoneBlockEntity)blockEntity;
                        BlockPos bossRoomCenter = keystoneTile.m_58899_().m_141952_((Vec3i)keystoneTile.getSpawnOffset());
                        boolean bl = isInCeilingRange = keystoneTile.getBossRoomCeilingSize() == 0 || pos.m_123342_() <= bossRoomCenter.m_123342_() + keystoneTile.getBossRoomCeilingSize();
                        if (isInCeilingRange && pos.m_123342_() >= bossRoomCenter.m_123342_() - 1 && GeometryHelper.isPointInsideRec((Vec3i)pos, (Vec3i)new BlockPos(bossRoomCenter.m_123341_() - keystoneTile.getBossRoomSize(), pos.m_123342_(), bossRoomCenter.m_123343_() - keystoneTile.getBossRoomSize()), (Vec3i)new BlockPos(bossRoomCenter.m_123341_() + keystoneTile.getBossRoomSize(), pos.m_123342_(), bossRoomCenter.m_123343_() + keystoneTile.getBossRoomSize()))) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    }
}

