/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.blocks.dungeon.SkyDecayingSpikeBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class DecayingSpikeEntity
extends FallingBlockEntity {
    public static final EntityDataAccessor<Boolean> DOWNWARD = SynchedEntityData.m_135353_(DecayingSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private BlockState state = this.getDownwards() ? (BlockState)SkiesBlocks.decaying_spike.m_49966_().m_61124_((Property)SkyDecayingSpikeBlock.DOWNWARD, (Comparable)Boolean.valueOf(false)) : SkiesBlocks.decaying_spike.m_49966_();
    private int timeExisted = 0;
    public boolean upward;
    private LivingEntity caster;
    private UUID casterUuid;

    public DecayingSpikeEntity(EntityType<? extends DecayingSpikeEntity> type, Level worldIn) {
        super(SkiesEntityTypes.DECAYING_SPIKE, worldIn);
    }

    public DecayingSpikeEntity(Level world, BlockPos pos, BlockState state, LivingEntity casterIn) {
        this(SkiesEntityTypes.DECAYING_SPIKE, world);
        this.f_19850_ = true;
        this.setCaster(casterIn);
        this.setState(state);
        this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }

    public DecayingSpikeEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(SkiesEntityTypes.DECAYING_SPIKE, world);
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.m_142081_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        if (this.f_19853_.f_46443_ && (this.state == null || this.state == Blocks.f_50016_.m_49966_())) {
            this.state = this.f_19853_.m_8055_(this.m_142538_());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DOWNWARD, (Object)true);
    }

    public void m_8119_() {
        if (this.m_31980_() == null || this.m_31980_() != null && this.m_31980_().m_60795_()) {
            this.killSpike();
            return;
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        ++this.timeExisted;
        if (!this.m_20068_() || !this.upward) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Block block = SkiesBlocks.decaying_spike;
        if (!this.f_19853_.f_46443_) {
            BlockPos blockpos1 = this.m_142538_();
            if (!this.f_19861_) {
                if (this.timeExisted > 100 && !this.f_19853_.f_46443_ && (blockpos1.m_123342_() < 1 || blockpos1.m_123342_() > 256) || this.timeExisted > 600 || !this.getDownwards() && this.timeExisted >= 15) {
                    if (this.f_19853_ instanceof ServerLevel) {
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, SkiesBlocks.lunar_stone.m_49966_()), this.m_20185_(), this.m_20227_(0.6), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
                    }
                    this.killSpike();
                }
            } else {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos1);
                if (this.f_19853_.m_46859_(new BlockPos(this.m_20185_(), this.m_20186_() - (double)0.01f, this.m_20189_())) && FallingBlock.m_53241_((BlockState)this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20186_() - (double)0.01f, this.m_20189_())))) {
                    this.f_19861_ = false;
                    return;
                }
                if (blockstate.m_60734_() != Blocks.f_50110_) {
                    this.killSpike();
                    if (!(this.getCaster() instanceof Player) || this.getCaster() instanceof Player && !EntityUtil.isInDungeon(this.f_19853_, blockpos1)) {
                        boolean flag2 = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, blockpos1, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
                        boolean flag3 = this.state.m_60710_((LevelReader)this.f_19853_, blockpos1);
                        if (flag2 && flag3) {
                            if (this.state.m_61138_((Property)BlockStateProperties.f_61362_) && this.f_19853_.m_6425_(blockpos1).m_76152_() == Fluids.f_76193_) {
                                this.state = (BlockState)this.state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                            }
                            this.f_19853_.m_7731_(blockpos1, this.state, 3);
                        }
                    } else if (this.f_19853_ instanceof ServerLevel) {
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, SkiesBlocks.lunar_stone.m_49966_()), this.m_20185_(), this.m_20227_(0.6), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
                    }
                    if (block instanceof Fallable) {
                        ((Fallable)block).m_142525_(this.f_19853_, blockpos1, (FallingBlockEntity)this);
                    }
                }
            }
            if (this.m_20184_().m_7098_() != 0.0) {
                ArrayList list = Lists.newArrayList((Iterable)this.f_19853_.m_45933_((Entity)this, this.m_142469_()));
                for (Entity entity : list) {
                    this.damage(entity, 0.0f);
                }
            }
        }
        if (this.timeExisted > 100) {
            if (this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, SkiesBlocks.lunar_stone.m_49966_()), this.m_20185_(), this.m_20227_(0.6), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
            }
            this.killSpike();
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        int i = Mth.m_14167_((float)(distance - 1.0f));
        if (i > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.f_19853_.m_45933_((Entity)this, this.m_142469_()));
            for (Entity entity : list) {
                this.damage(entity, 1.0f);
            }
        }
        return false;
    }

    private void damage(Entity hitEntityIn, float amp) {
        LivingEntity caster = this.getCaster();
        if (hitEntityIn.m_6084_() && !hitEntityIn.m_20147_() && hitEntityIn != caster) {
            if (caster == null) {
                hitEntityIn.m_6469_(EntityUtil.DamageSources.SPIKE, 5.0f + amp);
            } else {
                if (caster.m_7307_(hitEntityIn)) {
                    return;
                }
                hitEntityIn.m_6469_(EntityUtil.DamageSources.causeIndirectSpikeDamage((Entity)caster), 5.0f + amp);
            }
        }
    }

    private void killSpike() {
        this.m_146870_();
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public BlockState m_31980_() {
        return this.state;
    }

    public boolean getDownwards() {
        return (Boolean)this.f_19804_.m_135370_(DOWNWARD);
    }

    public void setDownwards(boolean downwardIn) {
        this.f_19804_.m_135381_(DOWNWARD, (Object)downwardIn);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setDownwards(compound.m_128471_("Downward"));
        this.state = Block.m_49803_((int)compound.m_128451_("blockstateId"));
        this.casterUuid = compound.m_128342_("OwnerUUID");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("Downward", this.getDownwards());
        compound.m_128405_("blockstateId", Block.m_49956_((BlockState)this.state));
        if (this.casterUuid != null) {
            compound.m_128362_("OwnerUUID", this.casterUuid);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

