/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DiophydeProwlerEntity
extends SkiesMonsterEntity {
    private float prevChargeAnim;
    private float chargeAnim;
    private boolean playChargeAnim;

    public DiophydeProwlerEntity(EntityType<? extends DiophydeProwlerEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new LungeAtTargetGoal());
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return DiophydeProwlerEntity.this.m_5448_() == null && super.m_8036_();
            }

            public boolean m_8045_() {
                return DiophydeProwlerEntity.this.m_5448_() == null && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.prevChargeAnim = this.chargeAnim;
            this.chargeAnim = this.playChargeAnim ? Mth.m_14036_((float)(this.chargeAnim + 2.0f), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.chargeAnim - 2.0f), (float)0.0f, (float)6.0f);
        } else if (this.m_5448_() == null && this.playChargeAnim) {
            this.setCharging(false);
        }
    }

    public void setCharging(boolean chargingIn) {
        if (chargingIn) {
            this.playChargeAnim = true;
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        } else {
            this.playChargeAnim = false;
            this.f_19853_.m_7605_((Entity)this, (byte)5);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getChargingAnimationScale(float pctIn) {
        return Mth.m_14179_((float)pctIn, (float)this.prevChargeAnim, (float)this.chargeAnim) / 6.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                this.playChargeAnim = true;
                break;
            }
            case 5: {
                this.playChargeAnim = false;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_DIOPHYDE_PROWLER_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_DIOPHYDE_PROWLER_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_DIOPHYDE_PROWLER_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12624_, 0.35f, 1.0f);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public int m_5792_() {
        return 1;
    }

    class LungeAtTargetGoal
    extends Goal {
        private final DiophydeProwlerEntity attacker;
        private int chargeTime;

        public LungeAtTargetGoal() {
            this.attacker = DiophydeProwlerEntity.this;
        }

        public boolean m_8036_() {
            return this.attacker.m_5448_() != null;
        }

        public boolean m_8045_() {
            return this.attacker.m_5448_() != null && this.chargeTime > 0;
        }

        public void m_8056_() {
            this.chargeTime = 60 + this.attacker.f_19796_.nextInt(40);
        }

        public void m_8037_() {
            if (this.attacker.m_5448_() == null) {
                return;
            }
            Level world = this.attacker.f_19853_;
            this.attacker.m_21563_().m_24960_((Entity)this.attacker.m_5448_(), 30.0f, 30.0f);
            if (this.attacker.m_20270_((Entity)this.attacker.m_5448_()) > 7.0f && !this.attacker.playChargeAnim) {
                this.attacker.setCharging(false);
                LivingEntity target = this.attacker.m_5448_();
                this.attacker.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), (double)1.3f);
            } else {
                if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                if (this.chargeTime > 30 && this.attacker.f_19861_) {
                    this.attacker.m_19920_(0.3f, new Vec3(-0.1, 0.0, 0.5));
                } else if (this.chargeTime > 15 && this.chargeTime <= 30) {
                    this.attacker.setCharging(true);
                } else {
                    this.attacker.setCharging(false);
                }
                if (this.chargeTime == 20) {
                    Vec3 vec3d = this.attacker.m_20184_();
                    Vec3 vec3d1 = new Vec3(this.attacker.m_5448_().m_20185_() - this.attacker.m_20185_(), 0.0, this.attacker.m_5448_().m_20189_() - this.attacker.m_20189_());
                    if (vec3d1.m_82556_() > 1.0E-7) {
                        vec3d1 = vec3d1.m_82541_().m_82490_(1.5).m_82549_(vec3d.m_82490_(1.5));
                    }
                    this.attacker.m_20334_(vec3d1.f_82479_, 0.4, vec3d1.f_82481_);
                    this.attacker.m_5496_(SkiesSounds.ENTITY_DIOPHYDE_PROWLER_LUNGE, this.attacker.m_6121_(), this.attacker.m_6100_());
                }
                int rotAmount = this.chargeTime > 20 ? 90 : 0;
                double d1 = this.attacker.m_5448_().m_20185_() - this.attacker.m_20185_();
                double d2 = this.attacker.m_5448_().m_20189_() - this.attacker.m_20189_();
                this.attacker.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f - (float)rotAmount);
                if (rotAmount > 0) {
                    this.attacker.f_20883_ = this.attacker.m_146908_() + 60.0f;
                    this.attacker.f_20885_ = this.attacker.m_146908_() + 60.0f;
                }
                List list = world.m_45933_((Entity)this.attacker, this.attacker.m_142469_());
                for (Entity entity : list) {
                    if (!(entity instanceof LivingEntity) || ((LivingEntity)entity).f_19802_ > 0) continue;
                    LivingEntity living = (LivingEntity)entity;
                    boolean attack = this.chargeTime <= 20 && this.attacker.m_7327_((Entity)living);
                    if (!attack) continue;
                    this.attacker.m_20256_(Vec3.f_82478_);
                    return;
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

