/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.world;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.audio.ambient.SkiesWeatherAmbientSounds;
import com.legacy.blue_skies.client.audio.ambient.SnowstormAmbientSoundHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.client.IWeatherRenderHandler;

public class BrightWeatherRenderer
implements IWeatherRenderHandler {
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    private static final ResourceLocation SNOW_DUSTING_TEXTURES = BlueSkies.locate("textures/environment/snow_dusting.png");
    private int rendererUpdateCount;
    private final float[] rainXCoords = new float[1024];
    private final float[] rainYCoords = new float[1024];
    private SoundInstance snowWind;
    private AmbientSoundHandler ambientSoundHandler;
    public static final BrightWeatherRenderer INSTANCE = new BrightWeatherRenderer();

    public BrightWeatherRenderer() {
        this.ambientSoundHandler = new SnowstormAmbientSoundHandler(Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().m_91106_());
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.m_14116_((float)(f * f + f1 * f1));
                this.rainXCoords[i << 5 | j] = -f1 / f2;
                this.rainYCoords[i << 5 | j] = f / f2;
            }
        }
    }

    public void render(int ticks, float partialTicks, ClientLevel world, Minecraft mc, LightTexture lightmapIn, double xIn, double yIn, double zIn) {
        this.renderRainSnow(partialTicks, mc, xIn, yIn, zIn);
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        this.playWeatherSounds(mc);
    }

    public void onUpdate() {
        if (!Minecraft.m_91087_().m_91104_()) {
            ++this.rendererUpdateCount;
        }
    }

    protected void renderRainSnow(float partialTicks, Minecraft mc, double xIn, double yIn, double zIn) {
        LightTexture lightmapIn = mc.f_91063_.m_109154_();
        float f = mc.f_91073_.m_46722_(partialTicks);
        if (!(f <= 0.0f)) {
            lightmapIn.m_109896_();
            ClientLevel world = mc.f_91073_;
            int i = Mth.m_14107_((double)xIn);
            int j = Mth.m_14107_((double)yIn);
            int k = Mth.m_14107_((double)zIn);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int l = 5;
            if (Minecraft.m_91405_()) {
                l = 10;
            }
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            int i1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.rainXCoords[l1] * 0.5;
                    double d1 = (double)this.rainYCoords[l1] * 0.5;
                    blockpos$mutable.m_122178_(k1, 0, j1);
                    Biome biome = (Biome)world.m_204166_((BlockPos)blockpos$mutable).m_203334_();
                    if (biome.m_47530_() == Biome.Precipitation.NONE) continue;
                    int i2 = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)blockpos$mutable).m_123342_();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    Random random = new Random(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761);
                    blockpos$mutable.m_122178_(k1, j2, j1);
                    if (biome.m_198906_((BlockPos)blockpos$mutable)) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tessellator.m_85914_();
                            }
                            i1 = 0;
                            RenderSystem.m_157456_((int)0, (ResourceLocation)RAIN_TEXTURES);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        int i3 = this.rendererUpdateCount + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)((float)k1 + 0.5f) - xIn;
                        double d4 = (double)((float)j1 + 0.5f) - zIn;
                        float f4 = Mth.m_14116_((float)((float)(d2 * d2 + d4 * d4))) / (float)l;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        blockpos$mutable.m_122178_(k1, l2, j1);
                        int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)blockpos$mutable);
                        bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tessellator.m_85914_();
                        }
                        i1 = 1;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)SNOW_TEXTURES);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float f6 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.005 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.0);
                    double d3 = (double)((float)k1 + 0.5f) - xIn;
                    double d5 = (double)((float)j1 + 0.5f) - zIn;
                    float f9 = Mth.m_14116_((float)((float)(d3 * d3 + d5 * d5))) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutable.m_122178_(k1, l2, j1);
                    int k3 = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)blockpos$mutable);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = (k3 & 0xFFFF) * 3;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).m_7421_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).m_7421_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                }
            }
            if (i1 >= 0) {
                tessellator.m_85914_();
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            lightmapIn.m_109891_();
        }
    }

    private void playWeatherSounds(Minecraft mc) {
        mc.f_91073_.f_46441_.setSeed((long)this.rendererUpdateCount * 312987231L);
        Entity entity = mc.m_91288_();
        BlockPos blockpos = entity.m_142538_();
        SoundManager soundHandler = mc.m_91106_();
        ClientLevel world = mc.f_91073_;
        if (mc.f_91073_.m_46471_() && ((Biome)mc.f_91073_.m_204166_(blockpos).m_203334_()).m_47530_() == Biome.Precipitation.SNOW && mc.f_91074_ != null) {
            boolean shouldPlay;
            this.ambientSoundHandler.m_7551_();
            boolean shouldStopPlaying = world.m_45517_(LightLayer.SKY, blockpos) <= 0;
            boolean bl = shouldPlay = world.m_46471_() && ((Biome)world.m_204166_(blockpos).m_203334_()).m_47530_() != Biome.Precipitation.NONE && !shouldStopPlaying;
            if (shouldPlay && (this.snowWind != null && !soundHandler.m_120403_(this.snowWind) || this.snowWind == null && !soundHandler.m_120403_(this.snowWind))) {
                this.snowWind = new SkiesWeatherAmbientSounds.SnowWindSound(mc.f_91074_);
                soundHandler.m_120367_(this.snowWind);
            }
        }
    }
}

