/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.footstep;

import java.util.List;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.config.FootstepLoader;
import me.andre111.mambience.footstep.FSEvent;
import me.andre111.mambience.footstep.FSMaterial;
import me.andre111.mambience.sound.Sound;

public class Footsteps {
    private final MAPlayer player;
    private final Accessor accessor;
    private double accumulatedDistance;
    private boolean wasPracticallyStanding;
    private boolean isInAir;
    private double fallDistance;
    private boolean rightFoot;

    public Footsteps(MAPlayer player) {
        this.player = player;
        this.accessor = player.getAccessor();
    }

    public void update() {
        double dx = this.accessor.getDeltaX();
        double dy = this.accessor.getDeltaY();
        double dz = this.accessor.getDeltaZ();
        double speed = Math.sqrt(dx * dx + dz * dz);
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (speed > 5.0) {
            speed = 5.0;
        }
        if (distance > 5.0) {
            distance = 5.0;
        }
        this.updateSteps(speed, distance);
        this.updateJumping(speed, distance);
    }

    private void updateSteps(double speed, double distance) {
        FSEvent event;
        boolean isPracticallyStanding;
        if (this.accessor.isSneaking() || this.accessor.isSubmerged() || !this.accessor.isOnGround()) {
            return;
        }
        this.accumulatedDistance += speed;
        boolean bl = isPracticallyStanding = speed < 0.01;
        if (isPracticallyStanding && !this.wasPracticallyStanding) {
            this.playEvent(FSEvent.WANDER, false, -0.0625);
        }
        this.wasPracticallyStanding = isPracticallyStanding;
        double strideDistance = 1.5;
        FSEvent fSEvent = event = speed >= (double)0.22f ? FSEvent.RUN : FSEvent.WALK;
        if (this.accumulatedDistance >= strideDistance) {
            this.accumulatedDistance -= strideDistance;
            if (event != null) {
                this.playEvent(event, false, 0.0);
                this.rightFoot = !this.rightFoot;
            }
        }
    }

    private void updateJumping(double speed, double distance) {
        if (this.accessor.isOnGround() == this.isInAir) {
            boolean bl = this.isInAir = !this.isInAir;
            if (this.isInAir && this.accessor.isJumping() && this.accessor.getDeltaY() > 0.0) {
                this.playEvent(FSEvent.JUMP, speed > 0.05, -0.125);
            }
            if (!this.isInAir && this.fallDistance > 0.01) {
                this.playEvent(FSEvent.LAND, this.fallDistance > 2.8, -0.125);
            }
        }
        if (this.isInAir) {
            if (this.accessor.getDeltaY() < 0.0) {
                this.fallDistance += -this.accessor.getDeltaY();
            }
        } else {
            this.fallDistance = 0.0;
        }
    }

    private void playEvent(FSEvent event, boolean doubleFooted, double yOffset) {
        this.findAndPlaySounds(event, this.rightFoot, yOffset);
        if (doubleFooted) {
            this.findAndPlaySounds(event, !this.rightFoot, yOffset);
        }
    }

    private void findAndPlaySounds(FSEvent event, boolean rightFoot, double yOffset) {
        int footBlockZ;
        int footBlockY;
        double feetDistance = rightFoot ? -0.2 : 0.2;
        double rotation = this.accessor.getRotation();
        double footX = this.accessor.getX() + Math.cos(rotation) * feetDistance;
        double footY = this.accessor.getY() + yOffset;
        double footZ = this.accessor.getZ() + Math.sin(rotation) * feetDistance;
        int footBlockX = (int)Math.floor(footX);
        List<FSMaterial> materials = FootstepLoader.BLOCK_MAP.get(this.accessor.getBlock(footBlockX, footBlockY = (int)Math.floor(footY), footBlockZ = (int)Math.floor(footZ)));
        if (this.isEmpty(materials)) {
            materials = FootstepLoader.BLOCK_MAP.get(this.accessor.getBlock(footBlockX, footBlockY - 1, footBlockZ));
        }
        if (materials == null) {
            return;
        }
        this.playSounds(event, footX, footY, footZ, materials);
        List<FSMaterial> armorMaterials = FootstepLoader.ARMOR_MAP.get(this.accessor.getArmor(2));
        if (this.isEmpty(armorMaterials)) {
            armorMaterials = FootstepLoader.ARMOR_MAP.get(this.accessor.getArmor(1));
        }
        List<FSMaterial> feetMaterials = FootstepLoader.ARMOR_MAP.get(this.accessor.getArmor(0));
        if (armorMaterials != null) {
            this.playSounds(event, footX, footY, footZ, armorMaterials);
        }
        if (feetMaterials != null && !feetMaterials.equals(armorMaterials)) {
            this.playSounds(event, footX, footY, footZ, feetMaterials);
        }
    }

    private boolean isEmpty(List<FSMaterial> materials) {
        return materials == null || materials.isEmpty() || materials.size() == 1 && materials.get(0).id().equals("mambience:none");
    }

    private void playSounds(FSEvent event, double x, double y, double z, List<FSMaterial> materials) {
        for (FSMaterial material : materials) {
            this.playSounds(event, x, y, z, material);
        }
    }

    private void playSounds(FSEvent event, double x, double y, double z, FSMaterial material) {
        Sound[] sounds = null;
        switch (event) {
            case WANDER: {
                sounds = material.wanderSounds();
                break;
            }
            case WALK: {
                sounds = material.walkSounds();
                break;
            }
            case RUN: {
                sounds = material.runSounds();
                break;
            }
            case JUMP: {
                sounds = material.jumpSounds();
                break;
            }
            case LAND: {
                sounds = material.landSounds();
                break;
            }
        }
        if (sounds == null) {
            return;
        }
        for (Sound sound : sounds) {
            this.player.getSoundPlayer().playSound(sound, x, y, z, true);
        }
    }
}

