/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.effect;

import java.util.List;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.effect.Effects;
import me.andre111.mambience.effect.instance.DustWind;
import me.andre111.mambience.effect.instance.FallingLeaves;
import me.andre111.mambience.effect.instance.Fireflies;
import me.andre111.mambience.effect.instance.FlameJet;

public record Effect(String type, String[] parameters, String block, String blockAbove, String blockBelow, double chance, List<Condition> conditions, List<Condition> restrictions) {
    public void update(MAPlayer maplayer, String block, int x, int y, int z) {
        if (this.conditionsMet(maplayer, block, x, y, z)) {
            switch (this.type) {
                case "fire_jet": {
                    int height = (int)(Math.random() * 3.0 + 1.0);
                    for (int i = 1; i <= height; ++i) {
                        if (maplayer.getAccessor().getBlock(x, y + i, z).equals("minecraft:air")) continue;
                        height = i - 1;
                        break;
                    }
                    if (height <= 0) break;
                    Effects.addInstance(new FlameJet(maplayer, height, (double)x + Math.random(), (double)y + 0.5, (double)z + Math.random()));
                    break;
                }
                case "fireflies": {
                    Effects.addInstance(new Fireflies(maplayer, x, y, z, 5));
                    break;
                }
                case "dust_wind": {
                    Effects.addInstance(new DustWind(maplayer, this.parameters[0], DustWind.WIND_X, DustWind.WIND_Z, x, y, z));
                    break;
                }
                case "falling_leaves": {
                    Effects.addInstance(new FallingLeaves(maplayer, this.parameters[0], x, y, z));
                }
            }
        }
    }

    private boolean conditionsMet(MAPlayer maplayer, String block, int x, int y, int z) {
        if (this.chance < 1.0 && Math.random() > this.chance) {
            return false;
        }
        if (!block.equals(this.block)) {
            return false;
        }
        if (!this.blockAbove.isEmpty() && !maplayer.getAccessor().getBlock(x, y + 1, z).equals(this.blockAbove)) {
            return false;
        }
        if (!this.blockBelow.isEmpty() && !maplayer.getAccessor().getBlock(x, y - 1, z).equals(this.blockBelow)) {
            return false;
        }
        for (Condition condition : this.conditions) {
            if (condition.matches(maplayer)) continue;
            return false;
        }
        for (Condition restriction : this.restrictions) {
            if (!restriction.matches(maplayer)) continue;
            return false;
        }
        return true;
    }
}

