/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.andre111.mambience.config.MaterialLoader;
import me.andre111.mambience.footstep.FSMaterial;

public final class FootstepLoader {
    public static final Map<String, List<FSMaterial>> BLOCK_MAP = new HashMap<String, List<FSMaterial>>();
    public static final Map<String, List<FSMaterial>> ARMOR_MAP = new HashMap<String, List<FSMaterial>>();

    public static void reset() {
        BLOCK_MAP.clear();
        ARMOR_MAP.clear();
    }

    public static void loadFootsteps(JsonObject obj) {
        FootstepLoader.loadToMap(BLOCK_MAP, obj.get("blocks").getAsJsonObject());
        FootstepLoader.loadToMap(ARMOR_MAP, obj.get("armor").getAsJsonObject());
    }

    private static void loadToMap(Map<String, List<FSMaterial>> map, JsonObject obj) {
        for (Map.Entry e : obj.entrySet()) {
            map.put((String)e.getKey(), Arrays.stream(((JsonElement)e.getValue()).getAsString().split(",")).map(id -> MaterialLoader.getMaterial(id)).toList());
        }
    }
}

