/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.condition.Parser;
import me.andre111.mambience.sound.Sound;

public class ConfigUtil {
    public static List<Condition> loadConditions(MALogger logger, JsonArray array) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (int i = 0; i < array.size(); ++i) {
            Condition condition = ConfigUtil.loadCondition(logger, array.get(i).getAsJsonObject());
            if (condition != null) {
                conditions.add(condition);
                continue;
            }
            logger.log("Warning: Ignored unknown condition: " + array.get(i));
        }
        return conditions;
    }

    private static Condition loadCondition(MALogger logger, JsonObject obj) {
        String name = ConfigUtil.getString(obj, "condition", "");
        return Parser.parse(name, obj);
    }

    public static Sound[] loadSounds(JsonElement element, float volumeMultiplier) {
        if (element == null) {
            return new Sound[0];
        }
        if (element.isJsonPrimitive()) {
            Object name = element.getAsString();
            if (!((String)name).contains(":")) {
                name = "mambience:" + (String)name;
            }
            return new Sound[]{new Sound((String)name, volumeMultiplier, volumeMultiplier, 1.0f, 1.0f, 0, 1.0)};
        }
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            Object name = object.get("name").getAsString();
            if (!((String)name).contains(":")) {
                name = "mambience:" + (String)name;
            }
            float volumeMin = ConfigUtil.getFloat(object, "volumeMin", ConfigUtil.getFloat(object, "volume", 100.0f)) / 100.0f;
            float volumeMax = ConfigUtil.getFloat(object, "volumeMax", ConfigUtil.getFloat(object, "volume", 100.0f)) / 100.0f;
            float pitchMin = ConfigUtil.getFloat(object, "pitchMin", ConfigUtil.getFloat(object, "pitch", 100.0f)) / 100.0f;
            float pitchMax = ConfigUtil.getFloat(object, "pitchMax", ConfigUtil.getFloat(object, "pitch", 100.0f)) / 100.0f;
            int delay = ConfigUtil.getInt(object, "delay", 0);
            double probability = ConfigUtil.getDouble(object, "probability", 1.0f);
            return new Sound[]{new Sound((String)name, volumeMin *= volumeMultiplier, volumeMax *= volumeMultiplier, pitchMin, pitchMax, delay, probability)};
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<Sound> sounds = new ArrayList<Sound>();
            for (int i = 0; i < array.size(); ++i) {
                for (Sound sound : ConfigUtil.loadSounds(array.get(i), volumeMultiplier)) {
                    sounds.add(sound);
                }
            }
            return sounds.toArray(new Sound[0]);
        }
        throw new RuntimeException("Unsupported sound format: " + element);
    }

    public static String getString(JsonObject obj, String memberName, String defaultValue) {
        return obj.has(memberName) ? obj.get(memberName).getAsString() : defaultValue;
    }

    public static double getDouble(JsonObject obj, String memberName, float defaultValue) {
        return obj.has(memberName) ? obj.get(memberName).getAsDouble() : (double)defaultValue;
    }

    public static float getFloat(JsonObject obj, String memberName, float defaultValue) {
        return obj.has(memberName) ? obj.get(memberName).getAsFloat() : defaultValue;
    }

    public static int getInt(JsonObject obj, String memberName, int defaultValue) {
        return obj.has(memberName) ? obj.get(memberName).getAsInt() : defaultValue;
    }

    public static boolean getBoolean(JsonObject obj, String memberName, boolean defaultValue) {
        return obj.has(memberName) ? obj.get(memberName).getAsBoolean() : defaultValue;
    }

    public static String[] getStringArray(JsonObject obj, String memberName, String[] defaultValue) {
        if (obj.has(memberName) && obj.get(memberName).isJsonArray()) {
            JsonArray jsonArray = obj.get(memberName).getAsJsonArray();
            String[] stringArray = new String[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                stringArray[i] = jsonArray.get(i).getAsString();
            }
            return stringArray;
        }
        return defaultValue;
    }
}

