/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.condition;

import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.condition.Condition;

public class ConditionVariable
extends Condition {
    private final String variable;
    private final boolean previous;
    private final double minValue;
    private final double maxValue;
    private final String stringValue;

    public ConditionVariable(String variable, boolean previous) {
        this(variable, previous, 0.0, 0.0, "");
    }

    public ConditionVariable(String variable, boolean previous, double minValue, double maxValue) {
        this(variable, previous, minValue, maxValue, "");
    }

    public ConditionVariable(String variable, boolean previous, String stringValue) {
        this(variable, previous, 0.0, 0.0, stringValue);
    }

    public ConditionVariable(String variable, boolean previous, double minValue, double maxValue, String stringValue) {
        if (variable == null || variable.isBlank()) {
            throw new IllegalArgumentException("Variable cannot be null/blank");
        }
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue cannot be larger than maxValue");
        }
        this.variable = variable;
        this.previous = previous;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stringValue = stringValue;
    }

    @Override
    public boolean matches(MAPlayer player) {
        Object value;
        Object object = value = this.previous ? player.getVariables().getPrevious(this.variable) : player.getVariables().get(this.variable);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            double d = n.doubleValue();
            return this.minValue <= d && d <= this.maxValue;
        }
        if (value instanceof String) {
            String s = (String)value;
            return s.equals(this.stringValue);
        }
        player.getLogger().error("Accessing unknown/unsupported variable: " + this.variable + " with value: " + value);
        return false;
    }
}

