/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.condition.Condition;

public final class ConditionBlocks
extends Condition {
    private final String blockOrTag;
    private final float minPercentage;
    private List<String> cachedBlocks;

    public ConditionBlocks(String blockOrTag, float minPercentage) {
        if (blockOrTag == null) {
            throw new IllegalArgumentException("Block / Blocktag cannot be null");
        }
        if (minPercentage < 0.0f || minPercentage > 1.0f) {
            throw new IllegalArgumentException("Minimum percentage is outside valid range [0,1]");
        }
        this.blockOrTag = blockOrTag;
        this.minPercentage = minPercentage;
    }

    @Override
    public boolean matches(MAPlayer player) {
        float percentage;
        if (this.cachedBlocks == null) {
            this.cachedBlocks = new ArrayList<String>();
            if (this.blockOrTag.startsWith("#")) {
                this.cachedBlocks.addAll(player.getAccessor().getBlockTag(this.blockOrTag.substring(1)));
            } else {
                this.cachedBlocks.add(this.blockOrTag);
            }
        }
        Map<String, Integer> scanData = player.getScanner().getScanBlockData();
        int count = 0;
        if (scanData != null) {
            for (String block : this.cachedBlocks) {
                count += scanData.getOrDefault(block, 0).intValue();
            }
        }
        return (percentage = (float)count / (float)player.getScanner().getScanBlockCount()) >= this.minPercentage;
    }
}

