/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.ambient;

import java.util.List;
import java.util.Random;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.sound.Sound;

public record AmbientEvent(String id, Sound[] sounds, List<Condition> conditions, List<Condition> restrictions, int cooldownMin, int cooldownMax) {
    private static final Random RANDOM = new Random();

    public AmbientEvent {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (sounds == null || sounds.length == 0) {
            throw new IllegalArgumentException("No sounds defined");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("Conditions list cannot be null");
        }
        if (restrictions == null) {
            throw new IllegalArgumentException("Restrictions list cannot be null");
        }
        if (cooldownMin < 0) {
            throw new IllegalArgumentException("Cooldown Minimum cannot be negative");
        }
        if (cooldownMax < 0) {
            throw new IllegalArgumentException("Cooldown Maximum cannot be negative");
        }
        if (cooldownMax < cooldownMin) {
            throw new IllegalArgumentException("Cooldown Minimum cannot be larger than Cooldown Maximum");
        }
    }

    public void init(MAPlayer maplayer) {
        this.setCooldown(maplayer);
    }

    public void update(MAPlayer maplayer) {
        if (this.conditionsMet(maplayer)) {
            if (maplayer.updateCooldown(this.id) <= 0) {
                for (Sound sound : this.sounds) {
                    maplayer.getSoundPlayer().playSound(sound, maplayer.getAccessor().getX(), maplayer.getAccessor().getY(), maplayer.getAccessor().getZ(), false);
                }
                this.setCooldown(maplayer);
            }
        } else if (Config.ambientEvents().isStopSounds() && maplayer.getCooldown(this.id) > 0 && this.isRestricted(maplayer)) {
            for (Sound sound : this.sounds) {
                maplayer.getLogger().log("Stop sound " + sound.name());
                maplayer.getAccessor().stopSound(sound.name());
            }
            maplayer.setCooldown(this.id, 0);
        }
    }

    private boolean conditionsMet(MAPlayer maplayer) {
        return this.isInConditions(maplayer) && !this.isRestricted(maplayer);
    }

    private boolean isInConditions(MAPlayer maplayer) {
        for (Condition condition : this.conditions) {
            if (condition.matches(maplayer)) continue;
            return false;
        }
        return true;
    }

    private boolean isRestricted(MAPlayer maplayer) {
        for (Condition restriction : this.restrictions) {
            if (!restriction.matches(maplayer)) continue;
            return true;
        }
        return false;
    }

    private void setCooldown(MAPlayer maplayer) {
        maplayer.setCooldown(this.id, this.cooldownMin + RANDOM.nextInt(this.cooldownMax - this.cooldownMin + 1));
    }
}

