/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.ambient.AmbientEvent;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.config.EventLoader;
import me.andre111.mambience.effect.Effects;
import me.andre111.mambience.scan.BlockScanner;

public class MAScheduler {
    private MALogger logger;
    private long timer;
    private Set<MAPlayer> players = new HashSet<MAPlayer>();
    private Queue<BlockScanner> scannerQueue = new LinkedList<BlockScanner>();
    private boolean clearPlayers = false;
    private List<MAPlayer> newPlayers = new ArrayList<MAPlayer>();

    public MAScheduler(MALogger logger) {
        this.logger = logger;
        this.timer = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(UUID player, Accessor accessor, MALogger logger) {
        MAPlayer maplayer = new MAPlayer(player, accessor, logger);
        EventLoader.forAllEvents((MessagePassingQueue.Consumer<AmbientEvent>)((MessagePassingQueue.Consumer)event -> event.init(maplayer)));
        List<MAPlayer> list = this.newPlayers;
        synchronized (list) {
            this.newPlayers.add(maplayer);
        }
    }

    public MAPlayer getPlayer(UUID player) {
        for (MAPlayer maplayer : this.players) {
            if (!maplayer.getPlayerUUID().equals(player)) continue;
            return maplayer;
        }
        return null;
    }

    public void clearPlayers() {
        this.clearPlayers = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTick() {
        long startTime = System.currentTimeMillis();
        ++this.timer;
        List<MAPlayer> list = this.newPlayers;
        synchronized (list) {
            if (this.clearPlayers) {
                this.players.clear();
                this.clearPlayers = false;
            }
            this.players.addAll(this.newPlayers);
            this.newPlayers.clear();
        }
        Iterator<MAPlayer> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            MAPlayer maplayer = iterator.next();
            if (!maplayer.getAccessor().updatePlayerInstance()) {
                iterator.remove();
                continue;
            }
            maplayer.getVariables().update();
            if (Config.ambientEvents().isEnabled()) {
                this.triggerEvents(maplayer, "TICK");
            }
            if (Config.footsteps().isEnabled()) {
                maplayer.getFootsteps().update();
            }
            maplayer.getSoundPlayer().update();
            if (maplayer.getScanner().getLastScan() + (long)Config.scanner().getInterval() <= this.timer && !this.scannerQueue.contains(maplayer.getScanner())) {
                this.scannerQueue.add(maplayer.getScanner());
            }
            maplayer.getAccessor().updateLastPosition();
        }
        long playerTime = System.currentTimeMillis();
        int refreshed = 0;
        int perTick = (int)Math.max(1.0, Math.ceil((double)this.players.size() / (double)Config.scanner().getInterval() * 1.5));
        for (int i = 0; i < perTick; ++i) {
            BlockScanner scanner = this.scannerQueue.poll();
            if (scanner == null) continue;
            scanner.performScan();
            scanner.setLastScan(this.timer);
            ++refreshed;
        }
        long scannerTime = System.currentTimeMillis();
        Effects.tick();
        long endTime = System.currentTimeMillis();
        if (this.timer % 20L == 0L) {
            this.logger.log("Refreshing " + refreshed + "/" + this.players.size() + " Player(s) last tick took " + (endTime - startTime) + "ms!");
            this.logger.log("\tPlayers (Vars+TICK+Footsteps+Soundplayer): " + (playerTime - startTime) + "ms      Scanners: " + (scannerTime - playerTime) + "ms      Effects: " + (endTime - scannerTime) + "ms!");
            this.runSecond();
        }
    }

    private void runSecond() {
        long startTime = System.currentTimeMillis();
        if (Config.ambientEvents().isEnabled()) {
            for (MAPlayer maplayer : this.players) {
                this.triggerEvents(maplayer, "SECOND");
            }
        }
        long soundTime = System.currentTimeMillis();
        if (Config.effects().isEnabled()) {
            for (MAPlayer maplayer : this.players) {
                Effects.update(maplayer);
            }
        }
        long endTime = System.currentTimeMillis();
        this.logger.log("SECOND took " + (soundTime - startTime) + "ms - Effect update took " + (endTime - soundTime) + "ms!");
    }

    public void triggerEvents(MAPlayer maplayer, String trigger) {
        for (AmbientEvent event : EventLoader.getEvents(trigger)) {
            event.update(maplayer);
        }
    }

    public void triggerEvents(UUID player, String trigger) {
        MAPlayer maplayer = this.getPlayer(player);
        if (maplayer != null) {
            this.triggerEvents(maplayer, trigger);
        }
    }
}

