/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.LogicUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class MoonstoneSpikeFeature
extends Feature<Config> {
    protected static final BlockState SPIKE = SkiesBlocks.vitreous_moonstone.m_49966_();

    public MoonstoneSpikeFeature(Codec<Config> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = world.m_5822_();
        Config config = (Config)context.m_159778_();
        int maxHeight = rand.nextInt(config.maxHeight - config.minHeight + 1) + config.minHeight;
        for (int height = 0; height < 26; ++height) {
            if (world.m_8055_(pos.m_6630_(height - 1)).m_60734_() != SkiesBlocks.crystal_sand || world.m_8055_(pos.m_6630_(height)).m_60734_() != Blocks.f_50016_) continue;
            for (int y = height; y <= maxHeight + height; ++y) {
                this.setBlock((LevelAccessor)world, pos.m_6630_(y));
            }
            int radius = rand.nextInt(config.maxRadius - config.minRadius + 1) + config.minRadius;
            double slope = (double)maxHeight / ((double)radius + 1.0);
            for (int i = 1; i <= radius; ++i) {
                for (int x = -i; x <= i; ++x) {
                    for (int z = -i; z <= i; ++z) {
                        if (Math.abs(x) + Math.abs(z) != i) continue;
                        for (int y = height; y <= Math.max(1, maxHeight + height - LogicUtil.plusOrMinus((int)(slope * (double)i), 2, rand)); ++y) {
                            this.setBlock((LevelAccessor)world, pos.m_142082_(x, y, z));
                        }
                    }
                }
            }
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) + Math.abs(z) > radius + 1) continue;
                    for (int y = -2; y <= 0; ++y) {
                        this.setBlock((LevelAccessor)world, pos.m_142082_(x, height + y, z));
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void setBlock(LevelAccessor world, BlockPos pos) {
        world.m_7731_(pos, SPIKE, 2);
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_height").forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(config -> config.maxHeight), (App)Codec.INT.fieldOf("min_radius").forGetter(config -> config.minRadius), (App)Codec.INT.fieldOf("max_radius").forGetter(config -> config.maxRadius)).apply((Applicative)instance, Config::new));
        public final int minHeight;
        public final int maxHeight;
        public final int minRadius;
        public final int maxRadius;

        public Config(int minHeight, int maxHeight, int minRadius, int maxRadius) {
            this.minHeight = Math.max(0, minHeight);
            this.maxHeight = Math.max(minHeight, maxHeight);
            this.minRadius = Math.max(0, minRadius);
            this.maxRadius = Math.max(minRadius, maxRadius);
        }
    }
}

