/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class LargeDuskTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.dusk_log.m_49966_();
    private static final BlockState LEAF = SkiesBlocks.dusk_leaves.m_49966_();

    public LargeDuskTreeFeature(Codec<TreeConfiguration> config, boolean natural) {
        super(config, natural);
    }

    @Override
    public boolean place(WorldGenLevel world, Random rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int z1;
        int x1;
        int z;
        int x;
        int height = rand.nextInt(5) + 16;
        if (!this.isAreaOk(world, pos, height, 2, height - 2, 3)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x2 = 0; x2 < 2; ++x2) {
                for (int z2 = 0; z2 < 2; ++z2) {
                    this.setBlockIfOk(changedLogs, world, pos.m_142082_(x2, y, z2), LOG);
                }
            }
        }
        for (x = -4; x <= 4; ++x) {
            for (z = -4; z <= 4; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.m_142082_(x > 0 ? x - 1 : x, height - 2, z > 0 ? z - 1 : z).m_142082_(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 >= 4 && z1 == 4 && x1 == 4) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF);
                if (!((double)rand.nextFloat() < 0.3)) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos.m_7495_(), LEAF);
            }
        }
        for (x = -4; x <= 4; ++x) {
            for (z = -4; z <= 4; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.m_142082_(x > 0 ? x - 1 : x, height - 1, z > 0 ? z - 1 : z).m_142082_(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 + x1 >= 7) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF);
            }
        }
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.m_142082_(x > 0 ? x - 1 : x, height, z > 0 ? z - 1 : z).m_142082_(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 == 3 && x1 == 3) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF);
            }
        }
        this.setLowerBranch(changedLogs, changedLeaves, rand, world, pos.m_142082_(rand.nextInt(2), rand.nextInt(5) + 6, -1), Direction.NORTH);
        this.setLowerBranch(changedLogs, changedLeaves, rand, world, pos.m_142082_(2, rand.nextInt(5) + 6, rand.nextInt(2)), Direction.EAST);
        this.setLowerBranch(changedLogs, changedLeaves, rand, world, pos.m_142082_(rand.nextInt(2), rand.nextInt(5) + 6, 2), Direction.SOUTH);
        this.setLowerBranch(changedLogs, changedLeaves, rand, world, pos.m_142082_(-1, rand.nextInt(5) + 6, rand.nextInt(2)), Direction.WEST);
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if (!rand.nextBoolean() || !((x == -1 || x == 2) ^ (z == -1 || z == 2))) continue;
                this.setBlockIfOk(changedLogs, world, pos.m_142082_(x, 0, z), LOG);
                if (!rand.nextBoolean()) continue;
                this.setBlockIfOk(changedLogs, world, pos.m_142082_(x, 1, z), LOG);
                this.setBlockIfOk(changedLogs, world, pos.m_142082_(x, 2, z), LOG);
                if (!rand.nextBoolean()) continue;
                this.setBlockIfOk(changedLogs, world, pos.m_142082_(x, 3, z), LOG);
            }
        }
        if (this.natural) {
            AbstractSkyTreeFeature.placeVines(world, pos, rand, 13, height, 4, 6, 0.05f, SkiesBlocks.dusk_vine, (Set<Block>)ImmutableSet.of((Object)((Object)SkiesBlocks.dusk_leaves)));
        }
        return true;
    }

    protected void setLowerBranch(BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves, Random rand, WorldGenLevel world, BlockPos pos, Direction direction) {
        BlockState axisLog = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
        this.setBlockIfOk(changedLogs, world, pos, axisLog);
        this.setBlockIfOk(changedLogs, world, pos.m_5484_(direction, 1), axisLog);
        this.setBlockIfOk(changedLogs, world, pos.m_5484_(direction, 2).m_7494_(), axisLog);
        this.setBlockIfOk(changedLogs, world, pos.m_5484_(direction, 3).m_7494_(), axisLog);
        this.setBlockIfOk(changedLogs, world, pos.m_5484_(direction, 4).m_6630_(2), LOG);
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                int x1 = Math.abs(x);
                int z1 = Math.abs(z);
                this.setBlockIfOk(changedLeaves, world, pos.m_5484_(direction, 4).m_142082_(x, 2, z), LEAF);
                if (z1 != 2 || x1 != 2) {
                    this.setBlockIfOk(changedLeaves, world, pos.m_5484_(direction, 4).m_142082_(x, 3, z), LEAF);
                }
                if (!((double)rand.nextFloat() < 0.3)) continue;
                this.setBlockIfOk(changedLeaves, world, pos.m_5484_(direction, 4).m_142082_(x, 1, z), LEAF);
            }
        }
    }

    @Override
    public boolean isValidGround(WorldGenLevel world, BlockState state, BlockPos pos) {
        if (this.natural) {
            return super.isValidGround(world, state, pos) && state.m_60734_() != SkiesBlocks.coarse_lunar_dirt;
        }
        return super.isValidGround(world, state, pos);
    }
}

