/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesConfiguredCarvers;
import com.legacy.blue_skies.registries.SkiesConfiguredFeatures;
import java.util.List;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.BiasedToBottomHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.VeryBiasedToBottomHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class SkiesFeaturePlacements {
    public static final PlacedFeature NATURE_DUNGEON_CHERRY_TREE = SkiesFeaturePlacements.register("nature_cherry_tree", SkiesConfiguredFeatures.NATURE_DUNGEON_CHERRY_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)1), (Block)SkiesBlocks.cherry_sapling)));
    public static final PlacedFeature NATURE_DUNGEON_STARLIT_BUSH = SkiesFeaturePlacements.register("nature_dungeon_starlit_bush", SkiesConfiguredFeatures.NATURE_DUNGEON_STARLIT_BUSH.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)3), (Block)SkiesBlocks.starlit_sapling)));
    public static final PlacedFeature CAVE_TURQUOISE_DRIPSTONE = SkiesFeaturePlacements.register("cave_turquoise_dripstone", SkiesConfiguredFeatures.CAVE_TURQUOISE_DRIPSTONE.m_190821_(SkiesFeaturePlacements.countRange(69, 25)));
    public static final PlacedFeature EVERBRIGHT_CAVE_SPAWNER_CONFIGURED = SkiesFeaturePlacements.register("everbright_cave_spawner", SkiesConfiguredFeatures.EVERBRIGHT_CAVE_SPAWNER_CONFIGURED.m_190821_(SkiesFeaturePlacements.countRangeRare(49, 1, (PlacementModifier)RarityFilter.m_191900_((int)4))));
    public static final PlacedFeature CAVE_LUNAR_LAVA_SPIRE = SkiesFeaturePlacements.register("cave_lunar_lava_spire", SkiesConfiguredFeatures.CAVE_LUNAR_LAVA_SPIRE.m_190821_(SkiesFeaturePlacements.countRange(29, 30)));
    public static final PlacedFeature CAVE_LUNAR_DRIPSTONE = SkiesFeaturePlacements.register("cave_lunar_dripstone", SkiesConfiguredFeatures.CAVE_LUNAR_DRIPSTONE.m_190821_(SkiesFeaturePlacements.countRange(69, 25)));
    public static final PlacedFeature EVERDAWN_CAVE_SPAWNER_CONFIGURED = SkiesFeaturePlacements.register("everdawn_cave_spawner", SkiesConfiguredFeatures.EVERDAWN_CAVE_SPAWNER_CONFIGURED.m_190821_(SkiesFeaturePlacements.countRangeRare(49, 1, (PlacementModifier)RarityFilter.m_191900_((int)4))));
    private static final List<PlacementModifier> OLD_EMERALD_PLACEMENT = List.of(CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)3, (int)8)), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)4), (VerticalAnchor)VerticalAnchor.m_158922_((int)31)), BiomeFilter.m_191561_());
    public static final PlacedFeature ORE_MOONSTONE = SkiesFeaturePlacements.register("ore_moonstone", SkiesConfiguredFeatures.ORE_MOONSTONE.m_190821_(SkiesFeaturePlacements.countRange(127, 20)));
    public static final PlacedFeature ORE_PYROPE = SkiesFeaturePlacements.register("ore_pyrope", SkiesConfiguredFeatures.ORE_PYROPE.m_190821_(SkiesFeaturePlacements.countRange(83, 17)));
    public static final PlacedFeature ORE_AQUITE = SkiesFeaturePlacements.register("ore_aquite", SkiesConfiguredFeatures.ORE_AQUITE.m_190821_(SkiesFeaturePlacements.countRange(54, 15)));
    public static final PlacedFeature ORE_DIOPSIDE = SkiesFeaturePlacements.register("ore_diopside", SkiesConfiguredFeatures.ORE_DIOPSIDE.m_190821_(SkiesFeaturePlacements.countRange(19, 1)));
    public static final PlacedFeature ORE_CHAROITE = SkiesFeaturePlacements.register("ore_charoite", SkiesConfiguredFeatures.ORE_CHAROITE.m_190821_(SkiesFeaturePlacements.countRange(13, 1)));
    public static final PlacedFeature ORE_EVERBRIGHT_FALSITE = SkiesFeaturePlacements.register("ore_everbright_falsite", SkiesConfiguredFeatures.ORE_EVERBRIGHT_FALSITE.m_190821_(SkiesFeaturePlacements.countRange(63, 20)));
    public static final PlacedFeature ORE_EVERBRIGHT_VENTIUM = SkiesFeaturePlacements.register("ore_everbright_ventium", SkiesConfiguredFeatures.ORE_EVERBRIGHT_VENTIUM.m_190821_(SkiesFeaturePlacements.countRange(63, 20)));
    public static final PlacedFeature ORE_EVERBRIGHT_EMERALD = SkiesFeaturePlacements.register("ore_everbright_emerald", SkiesConfiguredFeatures.ORE_EVERBRIGHT_EMERALD.m_190821_(OLD_EMERALD_PLACEMENT));
    public static final PlacedFeature ORE_EVERDAWN_HORIZONITE = SkiesFeaturePlacements.register("ore_everdawn_horizonite", SkiesConfiguredFeatures.ORE_EVERDAWN_HORIZONITE.m_190821_(SkiesFeaturePlacements.countRange(24, 10)));
    public static final PlacedFeature ORE_EVERDAWN_EMERALD = SkiesFeaturePlacements.register("ore_everdawn_emerald", SkiesConfiguredFeatures.ORE_EVERDAWN_EMERALD.m_190821_(OLD_EMERALD_PLACEMENT));
    public static final PlacedFeature COARSE_TURQUOISE_DIRT_BLOB = SkiesFeaturePlacements.register("coarse_turquoise_dirt_blob", SkiesConfiguredFeatures.COARSE_TURQUOISE_DIRT_BLOB.m_190821_(SkiesFeaturePlacements.countRange(255, 10)));
    public static final PlacedFeature RIMESTONE_BLOB = SkiesFeaturePlacements.register("rimestone_blob", SkiesConfiguredFeatures.RIMESTONE_BLOB.m_190823_(new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), SkiesFeaturePlacements.range(31), BiomeFilter.m_191561_()}));
    public static final PlacedFeature TARATITE_BLOB = SkiesFeaturePlacements.register("taratite_blob", SkiesConfiguredFeatures.TARATITE_BLOB.m_190823_(new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), SkiesFeaturePlacements.range(89), BiomeFilter.m_191561_()}));
    public static final PlacedFeature COARSE_LUNAR_DIRT_BLOB = SkiesFeaturePlacements.register("coarse_lunar_dirt_blob", SkiesConfiguredFeatures.COARSE_LUNAR_DIRT_BLOB.m_190821_(SkiesFeaturePlacements.countRange(255, 10)));
    public static final PlacedFeature UMBER_BLOB = SkiesFeaturePlacements.register("umber_blob", SkiesConfiguredFeatures.UMBER_BLOB.m_190823_(new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), SkiesFeaturePlacements.range(79), BiomeFilter.m_191561_()}));
    public static final PlacedFeature CINDERSTONE_BLOB = SkiesFeaturePlacements.register("cinderstone_blob", SkiesConfiguredFeatures.CINDERSTONE_BLOB.m_190823_(new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), SkiesFeaturePlacements.range(31), BiomeFilter.m_191561_()}));
    private static final List<PlacementModifier> LAKE_PLACEMENT = List.of(RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_());
    public static final PlacedFeature EVERBRIGHT_LAKE_CONFIGURED = SkiesFeaturePlacements.register("everbright_lake", SkiesConfiguredFeatures.EVERBRIGHT_LAKE_CONFIGURED.m_190821_(LAKE_PLACEMENT));
    public static final PlacedFeature EVERDAWN_LAKE_CONFIGURED = SkiesFeaturePlacements.register("everdawn_lake", SkiesConfiguredFeatures.EVERDAWN_LAKE_CONFIGURED.m_190821_(LAKE_PLACEMENT));
    public static final PlacedFeature SPRING_WATER = SkiesFeaturePlacements.register("spring_water", SkiesConfiguredFeatures.SPRING_WATER.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)50), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191683_((HeightProvider)BiasedToBottomHeight.m_161931_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158935_((int)8), (int)8)), BiomeFilter.m_191561_()}));
    public static final PlacedFeature SPRING_LAVA = SkiesFeaturePlacements.register("spring_lava", SkiesConfiguredFeatures.SPRING_LAVA.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)20), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191683_((HeightProvider)VeryBiasedToBottomHeight.m_162058_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158935_((int)8), (int)8)), BiomeFilter.m_191561_()}));
    public static final PlacedFeature PATCHY_SNOW = SkiesFeaturePlacements.register("patchy_snow", SkiesConfiguredFeatures.PATCHY_SNOW.m_190823_(new PlacementModifier[]{BiomeFilter.m_191561_()}));
    public static final PlacedFeature ICE_AND_SNOW_NO_PATH_CONFIGURED = SkiesFeaturePlacements.register("ice_and_snow_no_path", SkiesConfiguredFeatures.ICE_AND_SNOW_NO_PATH_CONFIGURED.m_190823_(new PlacementModifier[]{BiomeFilter.m_191561_()}));
    public static final PlacedFeature CAMELLIA_2 = SkiesFeaturePlacements.register("camellia_2", SkiesConfiguredFeatures.CAMELLIA_PATCH.m_190821_(SkiesFeaturePlacements.flower(2)));
    public static final PlacedFeature CAMELLIA_3 = SkiesFeaturePlacements.register("camellia_3", SkiesConfiguredFeatures.CAMELLIA_PATCH.m_190821_(SkiesFeaturePlacements.flower(3)));
    public static final PlacedFeature CAMELLIA_4 = SkiesFeaturePlacements.register("camellia_4", SkiesConfiguredFeatures.CAMELLIA_PATCH.m_190821_(SkiesFeaturePlacements.flower(4)));
    public static final PlacedFeature POLAR_POSY_3 = SkiesFeaturePlacements.register("polar_posy_3", SkiesConfiguredFeatures.POLAR_POSY_PATCH.m_190821_(SkiesFeaturePlacements.flower(3)));
    public static final PlacedFeature POLAR_POSY_6 = SkiesFeaturePlacements.register("polar_posy_6", SkiesConfiguredFeatures.POLAR_POSY_PATCH.m_190821_(SkiesFeaturePlacements.flower(6)));
    public static final PlacedFeature SNOWBLOOM_2 = SkiesFeaturePlacements.register("snowbloom_2", SkiesConfiguredFeatures.SNOWBLOOM_PATCH.m_190821_(SkiesFeaturePlacements.flower(2)));
    public static final PlacedFeature MOONLIT_BLOOM_2 = SkiesFeaturePlacements.register("moonlit_bloom_2", SkiesConfiguredFeatures.MOONLIT_BLOOM_PATCH.m_190821_(SkiesFeaturePlacements.flower(2)));
    public static final PlacedFeature LUCENTROOT_2 = SkiesFeaturePlacements.register("lucentroot_2", SkiesConfiguredFeatures.LUCENTROOT_PATCH.m_190821_(SkiesFeaturePlacements.flower(2)));
    public static final PlacedFeature NIGHTCRESS_2 = SkiesFeaturePlacements.register("nightcress_2", SkiesConfiguredFeatures.NIGHTCRESS_PATCH.m_190821_(SkiesFeaturePlacements.flower(2)));
    public static final PlacedFeature CRYSTAL_FLOWER_2 = SkiesFeaturePlacements.register("crystal_flower_2", SkiesConfiguredFeatures.CRYSTAL_FLOWER_PATCH.m_190821_(SkiesFeaturePlacements.flower(2)));
    public static final PlacedFeature MIDDAY_BAYHOP_6 = SkiesFeaturePlacements.register("midday_bayhop_6", SkiesConfiguredFeatures.MIDDAY_BAYHOP_PATCH.m_190821_(SkiesFeaturePlacements.flower(6)));
    public static final PlacedFeature FLARE_FLORET_BLAZE_BUD_LUCENTROOT_4 = SkiesFeaturePlacements.register("flare_floret_blaze_bud_lucentroot_4", SkiesConfiguredFeatures.FLARE_FLORET_BLAZE_BUD_LUCENTROOT_PATCH.m_190821_(SkiesFeaturePlacements.flower(4)));
    public static final PlacedFeature FLARE_FLORET_BLAZE_BUD_LUCENTROOT_5 = SkiesFeaturePlacements.register("flare_floret_blaze_bud_lucentroot_5", SkiesConfiguredFeatures.FLARE_FLORET_BLAZE_BUD_LUCENTROOT_PATCH.m_190821_(SkiesFeaturePlacements.flower(5)));
    public static final PlacedFeature SNOWCAP_PINHEAD_8 = SkiesFeaturePlacements.register("snowcap_pinhead_8", SkiesConfiguredFeatures.SNOWCAP_PINHEAD_PATCH.m_190821_(SkiesFeaturePlacements.flower(8)));
    public static final PlacedFeature BREWBERRY_2 = SkiesFeaturePlacements.register("brewberry_2", SkiesConfiguredFeatures.BREWBERRY_PATCH.m_190821_(SkiesFeaturePlacements.flower(2)));
    public static final PlacedFeature BREWBERRY_3 = SkiesFeaturePlacements.register("brewberry_3", SkiesConfiguredFeatures.BREWBERRY_PATCH.m_190821_(SkiesFeaturePlacements.flower(3)));
    public static final PlacedFeature BANEFUL_MUSHROOM_5 = SkiesFeaturePlacements.register("baneful_mushroom_5", SkiesConfiguredFeatures.BANEFUL_MUSHROOM_PATCH.m_190821_(SkiesFeaturePlacements.flower(5)));
    private static final List<PlacementModifier> DEFAULT_NOISE = SkiesFeaturePlacements.countNoise(-0.8, 5, 10);
    public static final PlacedFeature TURQUOISE_GRASS_2 = SkiesFeaturePlacements.register("turquoise_grass_2", SkiesConfiguredFeatures.TURQUOISE_GRASS_PATCH.m_190821_(SkiesFeaturePlacements.flower(2, false)));
    public static final PlacedFeature TURQUOISE_GRASS_3 = SkiesFeaturePlacements.register("turquoise_grass_3", SkiesConfiguredFeatures.TURQUOISE_GRASS_PATCH.m_190821_(SkiesFeaturePlacements.flower(3, false)));
    public static final PlacedFeature TURQUOISE_GRASS_5 = SkiesFeaturePlacements.register("turquoise_grass_5", SkiesConfiguredFeatures.TURQUOISE_GRASS_PATCH.m_190821_(SkiesFeaturePlacements.flower(5, false)));
    public static final PlacedFeature TURQUOISE_GRASS_8 = SkiesFeaturePlacements.register("turquoise_grass_8", SkiesConfiguredFeatures.TURQUOISE_GRASS_PATCH.m_190821_(SkiesFeaturePlacements.flower(8, false)));
    public static final PlacedFeature TURQUOISE_GRASS_NOISE = SkiesFeaturePlacements.register("turquoise_grass_noise", SkiesConfiguredFeatures.TURQUOISE_GRASS_PATCH.m_190821_(DEFAULT_NOISE));
    public static final PlacedFeature TALL_TURQUOISE_GRASS_NOISE = SkiesFeaturePlacements.register("tall_turquoise_grass_noise", SkiesConfiguredFeatures.TALL_TURQUOISE_GRASS_PATCH.m_190821_(DEFAULT_NOISE));
    public static final PlacedFeature BRITTLEBUSH_3 = SkiesFeaturePlacements.register("brittlebush_3", SkiesConfiguredFeatures.BRITTLEBUSH_PATCH.m_190821_(SkiesFeaturePlacements.flower(3)));
    public static final PlacedFeature BRITTLEBUSH_5 = SkiesFeaturePlacements.register("brittlebush_5", SkiesConfiguredFeatures.BRITTLEBUSH_PATCH.m_190821_(SkiesFeaturePlacements.flower(5)));
    public static final PlacedFeature CHILLWEED_3 = SkiesFeaturePlacements.register("chillweed_3", SkiesConfiguredFeatures.CHILLWEED_PATCH.m_190821_(SkiesFeaturePlacements.flower(3)));
    public static final PlacedFeature CHILLWEED_5 = SkiesFeaturePlacements.register("chillweed_5", SkiesConfiguredFeatures.CHILLWEED_PATCH.m_190821_(SkiesFeaturePlacements.flower(5)));
    public static final PlacedFeature LUNAR_GRASS_4 = SkiesFeaturePlacements.register("lunar_grass_4", SkiesConfiguredFeatures.LUNAR_GRASS_PATCH.m_190821_(SkiesFeaturePlacements.flower(4, false)));
    public static final PlacedFeature LUNAR_GRASS_5 = SkiesFeaturePlacements.register("lunar_grass_5", SkiesConfiguredFeatures.LUNAR_GRASS_PATCH.m_190821_(SkiesFeaturePlacements.flower(5, false)));
    public static final PlacedFeature LUNAR_GRASS_7 = SkiesFeaturePlacements.register("lunar_grass_7", SkiesConfiguredFeatures.LUNAR_GRASS_PATCH.m_190821_(SkiesFeaturePlacements.flower(7, false)));
    public static final PlacedFeature TALL_LUNAR_GRASS_NOISE = SkiesFeaturePlacements.register("tall_lunar_grass_noise", SkiesConfiguredFeatures.TALL_LUNAR_GRASS_PATCH.m_190821_(DEFAULT_NOISE));
    public static final PlacedFeature MUCKWEED_5 = SkiesFeaturePlacements.register("muckweed_5", SkiesConfiguredFeatures.MUCKWEED_PATCH.m_190821_(SkiesFeaturePlacements.flower(5)));
    public static final PlacedFeature LUNAR_GRASS_MUCKWEED_20 = SkiesFeaturePlacements.register("lunar_grass_muckweed_20", SkiesConfiguredFeatures.LUNAR_GRASS_MUCKWEED_PATCH.m_190821_(SkiesFeaturePlacements.flower(20)));
    public static final PlacedFeature LUNAR_GRASS_MUCKWEED_NOISE = SkiesFeaturePlacements.register("lunar_grass_muckweed_noise", SkiesConfiguredFeatures.LUNAR_GRASS_MUCKWEED_PATCH.m_190821_(DEFAULT_NOISE));
    public static final PlacedFeature CRYSTALLIZED_GRASS_5 = SkiesFeaturePlacements.register("crystallized_grass_5", SkiesConfiguredFeatures.CRYSTALLIZED_GRASS_PATCH.m_190821_(SkiesFeaturePlacements.flower(5, false)));
    public static final PlacedFeature LIGHT_CRYSTALLIZED_GRASS_2 = SkiesFeaturePlacements.register("light_crystallized_grass_2", SkiesConfiguredFeatures.LIGHT_CRYSTALLIZED_GRASS_PATCH.m_190821_(SkiesFeaturePlacements.flower(2, false)));
    public static final PlacedFeature CALMING_SKIES_BLUEBRIGHT_TREE = SkiesFeaturePlacements.register("calming_skies_bluebright_tree", SkiesConfiguredFeatures.BLUEBRIGHT_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)2), (Block)SkiesBlocks.bluebright_sapling)));
    public static final PlacedFeature CALMING_SKIES_STARLIT_TREE = SkiesFeaturePlacements.register("calming_skies_starlit_tree", SkiesConfiguredFeatures.STARLIT_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)3), (Block)SkiesBlocks.starlit_sapling)));
    public static final PlacedFeature CALMING_SKIES_CAVE_DRIPSTONE = SkiesFeaturePlacements.register("calming_skies_cave_dripstone", SkiesConfiguredFeatures.CAVE_DENSE_TURQUOISE_DRIPSTONE.m_190821_(SkiesFeaturePlacements.countRange(69, 25)));
    public static final PlacedFeature BRIGHTLANDS_FALLEN_LOG = SkiesFeaturePlacements.register("brightlands_fallen_log", SkiesConfiguredFeatures.FALLEN_STARLIT_LOG.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)5))));
    public static final PlacedFeature BRIGHTLANDS_STARLIT_TREE = SkiesFeaturePlacements.register("brightlands_starlit_tree", SkiesConfiguredFeatures.STARLIT_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)5), (Block)SkiesBlocks.starlit_sapling)));
    public static final PlacedFeature BRIGHTLANDS_CAVE_GRASS = SkiesFeaturePlacements.register("brightlands_cave_grass", SkiesConfiguredFeatures.BRIGHTLANDS_CAVE_GRASS.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature BRIGHTLANDS_GIANT_CAVE_ICICLE = SkiesFeaturePlacements.register("brightlands_giant_icicle", SkiesConfiguredFeatures.GIANT_CAVE_ICICLE.m_190821_(SkiesFeaturePlacements.countRange(59, 40)));
    public static final PlacedFeature BRIGHTLANDS_CAVE_WALL = SkiesFeaturePlacements.register("brightlands_cave_wall", SkiesConfiguredFeatures.BRIGHTLANDS_CAVE_WALL.m_190821_(SkiesFeaturePlacements.countRange(19, 30)));
    public static final PlacedFeature SLUSHLANDS_LARGE_SNOWCAP_MUSHROOM = SkiesFeaturePlacements.register("slushlands_large_snowcap_mushroom", SkiesConfiguredFeatures.GIANT_SNOWCAP_MUSHROOM.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, SurfaceWaterDepthFilter.m_191950_((int)1), BiomeFilter.m_191561_()}));
    public static final PlacedFeature SLUSHLANDS_SNOWCAP_MUSHROOM = SkiesFeaturePlacements.register("slushlands_snowcap_mushroom", SkiesConfiguredFeatures.SNOWCAP_MUSHROOM_PATCH.m_190821_(SkiesFeaturePlacements.flower(6)));
    public static final PlacedFeature SLUSHLANDS_CHILLED_LILY = SkiesFeaturePlacements.register("slushlands_chilled_lily", SkiesConfiguredFeatures.CHILLED_LILY.m_190821_(SkiesFeaturePlacements.flower(23)));
    public static final PlacedFeature SLUSHLANDS_CAVE_WALL = SkiesFeaturePlacements.register("slushlands_cave_wall", SkiesConfiguredFeatures.SLUSHLANDS_CAVE_WALL.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature SLUSHLANDS_CAVE_BLUEBRIGHT_VINE = SkiesFeaturePlacements.register("slushlands_cave_bluebright_vine", SkiesConfiguredFeatures.SLUSHLANDS_CAVE_BLUEBRIGHT_VINE.m_190821_(SkiesFeaturePlacements.countRange(59, 30)));
    public static final PlacedFeature SLUSHLANDS_CAVE_PINHEAD = SkiesFeaturePlacements.register("slushlands_cave_pinhead", SkiesConfiguredFeatures.SLUSHLANDS_CAVE_PINHEAD.m_190821_(SkiesFeaturePlacements.countRange(59, 17)));
    public static final PlacedFeature FROSTBITTEN_FOREST_BUSH = SkiesFeaturePlacements.register("frostbitten_forest_bush", SkiesConfiguredFeatures.FROSTBRIGHT_BUSH.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)4), (Block)SkiesBlocks.frostbright_sapling)));
    public static final PlacedFeature FROSTBITTEN_FOREST_FROSTBRIGHT_TREE = SkiesFeaturePlacements.register("frostbitten_forest_frostbright_tree", SkiesConfiguredFeatures.SNOWY_FROSTBRIGHT_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)8), (Block)SkiesBlocks.frostbright_sapling)));
    public static final PlacedFeature FROSTBITTEN_FOREST_SMALL_FROSTBRIGHT_TREE = SkiesFeaturePlacements.register("frostbitten_forest_small_frostbright_tree", SkiesConfiguredFeatures.SMALL_FROSTBRIGHT_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)5, (int)6)), (Block)SkiesBlocks.frostbright_sapling)));
    public static final PlacedFeature FROSTBITTEN_FOREST_BLUEBRIGHT_TREE = SkiesFeaturePlacements.register("frostbitten_forest_bluebright_tree", SkiesConfiguredFeatures.BLUEBRIGHT_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)5, (int)6)), (Block)SkiesBlocks.bluebright_sapling)));
    public static final PlacedFeature FROSTBITTEN_FOREST_CAVE_FROSTBRIGHT_VINE = SkiesFeaturePlacements.register("frostbitten_forest_cave_frostbright_vine", SkiesConfiguredFeatures.FROSTBITTEN_FOREST_CAVE_FROSTBRIGHT_VINE.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature FROSTBITTEN_FOREST_CAVE_GRASS = SkiesFeaturePlacements.register("frostbitten_forest_cave_grass", SkiesConfiguredFeatures.FROSTBITTEN_FOREST_CAVE_GRASS.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature FROSTBITTEN_FOREST_CAVE_WALL = SkiesFeaturePlacements.register("frostbitten_forest_cave_wall", SkiesConfiguredFeatures.FROSTBITTEN_FOREST_CAVE_WALL.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature PEEKING_OCEAN_SEA_MOSS = SkiesFeaturePlacements.register("peeking_ocean_sea_moss", SkiesConfiguredFeatures.PEEKING_OCEAN_SEA_MOSS.m_190823_(new PlacementModifier[]{BiomeFilter.m_191561_()}));
    public static final PlacedFeature PEEKING_OCEAN_BRUMBLE = SkiesFeaturePlacements.register("peeking_ocean_brumble", SkiesConfiguredFeatures.PEEKING_OCEAN_BRUMBLE.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)48), PlacementUtils.f_195353_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature PEEKING_OCEAN_BRUMBLE_VINE = SkiesFeaturePlacements.register("peeking_ocean_brumble_vine", SkiesConfiguredFeatures.PEEKING_OCEAN_BRUMBLE_VINE.m_190823_(new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature PEEKING_OCEAN_SPIKE = SkiesFeaturePlacements.register("peeking_ocean_spike", SkiesConfiguredFeatures.PEEKING_OCEAN_SPIKE.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature PEEKING_OCEAN_CAVE_MOSS_CARPET = SkiesFeaturePlacements.register("peeking_ocean_cave_moss_carpet", SkiesConfiguredFeatures.PEEKING_OCEAN_CAVE_MOSS_CARPET.m_190821_(SkiesFeaturePlacements.countRange(59, 25)));
    public static final PlacedFeature PEEKING_OCEAN_CAVE_DENSE_MOSS_WALL = SkiesFeaturePlacements.register("peeking_ocean_cave_dense_moss_wall", SkiesConfiguredFeatures.PEEKING_OCEAN_CAVE_DENSE_MOSS_WALL.m_190821_(SkiesFeaturePlacements.countRange(59, 25)));
    public static final PlacedFeature PEEKING_OCEAN_CAVE_MOSS_WALL = SkiesFeaturePlacements.register("peeking_ocean_cave_moss_wall", SkiesConfiguredFeatures.PEEKING_OCEAN_CAVE_MOSS_WALL.m_190821_(SkiesFeaturePlacements.countRange(59, 15)));
    public static final PlacedFeature BRUMBLE_FOREST_BRUMBLE_VINE = SkiesFeaturePlacements.register("brumble_forest_brumble_vine", SkiesConfiguredFeatures.PEEKING_OCEAN_BRUMBLE_VINE.m_190823_(new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)8, (int)10)), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature SNOW_COVERED_PINES_STARLIT_TREE = SkiesFeaturePlacements.register("snow_covered_pines_starlit_tree", SkiesConfiguredFeatures.SNOW_COVERED_PINES_VEGETATION.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)3), (Block)SkiesBlocks.starlit_sapling)));
    public static final PlacedFeature SNOW_COVERED_PINES_CAVE_STARLIT_VINE = SkiesFeaturePlacements.register("snow_covered_pines_cave_starlit_vine", SkiesConfiguredFeatures.SNOW_COVERED_PINES_CAVE_STARLIT_VINE.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature SNOW_COVERED_PINES_WALL_MOONSTONE = SkiesFeaturePlacements.register("snow_covered_pines_wall_moonstone", SkiesConfiguredFeatures.SNOW_COVERED_PINES_WALL_MOONSTONE.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature SNOW_COVERED_PINES_CAVE_WALL = SkiesFeaturePlacements.register("snow_covered_pines_cave_wall", SkiesConfiguredFeatures.SNOW_COVERED_PINES_CAVE_WALL.m_190821_(SkiesFeaturePlacements.countRange(59, 10)));
    public static final PlacedFeature BRISK_MEADOW_BLUEBRIGHT_TREE = SkiesFeaturePlacements.register("brisk_meadow_bluebright_tree", SkiesConfiguredFeatures.BLUEBRIGHT_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), (Block)SkiesBlocks.bluebright_sapling)));
    public static final PlacedFeature BRISK_MEADOW_BUSH = SkiesFeaturePlacements.register("brisk_meadow_bush", SkiesConfiguredFeatures.BLUEBRIGHT_BUSH.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)1, (int)2)), (Block)SkiesBlocks.starlit_sapling)));
    public static final PlacedFeature BRISK_MEADOW_FLOWER = SkiesFeaturePlacements.register("brisk_meadow_flower", SkiesConfiguredFeatures.BRISK_MEADOW_FLOWER.m_190821_(DEFAULT_NOISE));
    public static final PlacedFeature BRISK_MEADOW_CAVE_WALL_STONE_RIMESTONE = SkiesFeaturePlacements.register("brisk_meadow_cave_wall_stone_rimestone", SkiesConfiguredFeatures.BRISK_MEADOW_CAVE_WALL_STONE_RIMESTONE.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature BRISK_MEADOW_CAVE_WALL_RIMESTONE_STONE = SkiesFeaturePlacements.register("brisk_meadow_cave_wall_rimestone_stone", SkiesConfiguredFeatures.BRISK_MEADOW_CAVE_WALL_RIMESTONE_STONE.m_190821_(SkiesFeaturePlacements.countRange(59, 10)));
    public static final PlacedFeature BRISK_MEADOW_CAVE_FROSE = SkiesFeaturePlacements.register("brisk_meadow_cave_frose", SkiesConfiguredFeatures.BRISK_MEADOW_CAVE_FROSE.m_190821_(SkiesFeaturePlacements.countRange(59, 17)));
    public static final PlacedFeature POLAR_HIGHLAND_ROCK = SkiesFeaturePlacements.register("polar_highland_rock", SkiesConfiguredFeatures.TURQUOISE_COBBLESTONE_ROCK.m_190823_(new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)0, (int)2)), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature POLAR_HIGHLAND_VEGETATION = SkiesFeaturePlacements.register("polar_highland_vegetation", SkiesConfiguredFeatures.POLAR_HIGHLAND_VEGETATION.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)8, (float)0.1f, (int)1), (Block)SkiesBlocks.bluebright_sapling)));
    public static final PlacedFeature POLAR_HIGHLAND_CAVE_WALL_TARATITE = SkiesFeaturePlacements.register("polar_highland_cave_wall_taratite", SkiesConfiguredFeatures.POLAR_HIGHLAND_CAVE_WALL_TARATITE.m_190821_(SkiesFeaturePlacements.countRange(59, 30)));
    public static final PlacedFeature POLAR_HIGHLAND_CAVE_GRASS = SkiesFeaturePlacements.register("polar_highland_cave_grass", SkiesConfiguredFeatures.POLAR_HIGHLAND_CAVE_GRASS.m_190821_(SkiesFeaturePlacements.countRange(59, 25)));
    public static final PlacedFeature POLAR_HIGHLAND_CAVE_POSY = SkiesFeaturePlacements.register("polar_highland_cave_posy", SkiesConfiguredFeatures.POLAR_HIGHLAND_CAVE_POSY.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature UNORTHODOX_VALLEY_BUSH = SkiesFeaturePlacements.register("unorthodox_valley_bush", SkiesConfiguredFeatures.DUSK_BUSH.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)2, (float)0.1f, (int)2), (Block)SkiesBlocks.dusk_sapling)));
    public static final PlacedFeature UNORTHODOX_VALLEY_DUSK_LUNAR_TREE = SkiesFeaturePlacements.register("unorthodox_valley_dusk_lunar_tree", SkiesConfiguredFeatures.UNORTHODOX_VALLEY_VEGETATION.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)2), (Block)SkiesBlocks.lunar_sapling)));
    public static final PlacedFeature UNORTHODOX_VALLEY_CRESCENT_FRUIT_TREE = SkiesFeaturePlacements.register("unorthodox_valley_crescent_fruit_tree", SkiesConfiguredFeatures.CRESCENT_FRUIT_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), (Block)SkiesBlocks.crescent_fruit_sapling)));
    public static final PlacedFeature UNORTHODOX_VALLEY_CAVE_DRIPSTONE = SkiesFeaturePlacements.register("unorthodox_valley_cave_dripstone", SkiesConfiguredFeatures.CAVE_LUNAR_DRIPSTONE.m_190821_(SkiesFeaturePlacements.countRange(69, 25)));
    public static final PlacedFeature SHADED_WOODLANDS_LARGE_DUSK_TREE = SkiesFeaturePlacements.register("shaded_woodlands_large_dusk_tree", SkiesConfiguredFeatures.VINED_LARGE_DUSK_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)30, (float)0.1f, (int)1), (Block)SkiesBlocks.dusk_sapling)));
    public static final PlacedFeature SHADED_WOODLANDS_FLOWER = SkiesFeaturePlacements.register("shaded_woodlands_flower", SkiesConfiguredFeatures.SHADED_WOODLANDS_FLOWER_PATCH.m_190821_(DEFAULT_NOISE));
    public static final PlacedFeature SHADED_WOODLANDS_CAVE_DUSK_VINE = SkiesFeaturePlacements.register("shaded_woodlands_cave_dusk_vine", SkiesConfiguredFeatures.SHADED_WOODLANDS_CAVE_DUSK_VINE.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature SHADED_WOODLANDS_CAVE_WALL = SkiesFeaturePlacements.register("shaded_woodlands_cave_wall", SkiesConfiguredFeatures.SHADED_WOODLANDS_CAVE_WALL.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature CRYSTAL_DUNES_MOONSTONE_SPIKE = SkiesFeaturePlacements.register("crystal_dunes_moonstone_spike", SkiesConfiguredFeatures.CRYSTAL_DUNES_MOONSTONE_SPIKE.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature CRYSTAL_DUNES_LARGE_MOONSTONE_SPIKE = SkiesFeaturePlacements.register("crystal_dunes_large_moonstone_spike", SkiesConfiguredFeatures.CRYSTAL_DUNES_LARGE_MOONSTONE_SPIKE.m_190823_(new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)2, (int)3)), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature CRYSTAL_DUNES_CAVE_MOONSTONE_CRYSTAL = SkiesFeaturePlacements.register("crystal_dunes_cave_moonstone_crystal", SkiesConfiguredFeatures.CRYSTAL_DUNES_CAVE_MOONSTONE_CRYSTAL.m_190821_(SkiesFeaturePlacements.countRange(59, 60)));
    public static final PlacedFeature CRYSTAL_DUNES_CAVE_GRASS = SkiesFeaturePlacements.register("crystal_dunes_cave_grass", SkiesConfiguredFeatures.CRYSTAL_DUNES_CAVE_GRASS.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature CRYSTAL_DUNES_CAVE_WALL_MOONSTONE = SkiesFeaturePlacements.register("crystal_dunes_cave_wall_moonstone", SkiesConfiguredFeatures.CRYSTAL_DUNES_CAVE_WALL_MOONSTONE.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature RISING_CREEK_MOONLIT_WATER_LILY = SkiesFeaturePlacements.register("rising_creek_moonlit_water_lily", SkiesConfiguredFeatures.MOONLIT_WATER_LILY.m_190823_(new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)1, (int)2)), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature MOONLIT_RESERVOIR_DUSK_TREE = SkiesFeaturePlacements.register("moonlit_reservoir_dusk_tree", SkiesConfiguredFeatures.RESERVOIR_DUSK_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)1), (Block)SkiesBlocks.dusk_sapling)));
    public static final PlacedFeature MOONLIT_RESERVOIR_GLIMMER_REEDS = SkiesFeaturePlacements.register("moonlit_reservoir_glimmer_reeds", SkiesConfiguredFeatures.GLIMMER_REEDS.m_190823_(new PlacementModifier[]{NoiseBasedCountPlacement.m_191731_((int)80, (double)80.0, (double)0.0), InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature MOONLIT_RESERVOIR_MOONLIT_WATER_LILY = SkiesFeaturePlacements.register("moonlit_reservoir_moonlit_water_lily", SkiesConfiguredFeatures.MOONLIT_WATER_LILY.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature MOONLIT_RESERVOIR_CAVE_GRASS = SkiesFeaturePlacements.register("moonlit_reservoir_cave_grass", SkiesConfiguredFeatures.MOONLIT_RESERVOIR_CAVE_GRASS.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature MOONLIT_RESERVOIR_CAVE_WALL = SkiesFeaturePlacements.register("moonlit_reservoir_cave_wall", SkiesConfiguredFeatures.MOONLIT_RESERVOIR_CAVE_WALL.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature CRYSTAL_ROUGHS_LUNAR_TREE = SkiesFeaturePlacements.register("crystal_roughs_lunar_tree", SkiesConfiguredFeatures.LUNAR_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)2), (Block)SkiesBlocks.lunar_sapling)));
    public static final PlacedFeature CRYSTAL_ROUGHS_CRYSTALIZED_TREE = SkiesFeaturePlacements.register("crystal_roughs_crystalized_tree", SkiesConfiguredFeatures.CRYSTALIZED_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)2), (Block)SkiesBlocks.crystallized_grass)));
    public static final PlacedFeature CRYSTAL_ROUGHS_SHORT_MOONSTONE_SPIKE = SkiesFeaturePlacements.register("crystal_roughs_short_moonstone_spike", SkiesConfiguredFeatures.SHORT_MOONSTONE_SPIKE.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)2))));
    public static final PlacedFeature CRYSTAL_ROUGHS_CAVE_GRASS = SkiesFeaturePlacements.register("crystal_roughs_cave_grass", SkiesConfiguredFeatures.CRYSTAL_ROUGHS_CAVE_GRASS.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature SUNSET_MAPLE_FOREST_MAPLE_TREE = SkiesFeaturePlacements.register("sunset_maple_forest_maple_tree", SkiesConfiguredFeatures.MAPLE_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)12, (float)0.1f, (int)1), (Block)SkiesBlocks.maple_sapling)));
    public static final PlacedFeature SUNSET_MAPLE_FOREST_CAVE_WALL_SUNSTONE = SkiesFeaturePlacements.register("sunset_maple_forest_cave_wall_sunstone", SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_CAVE_WALL_SUNSTONE.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature SUNSET_MAPLE_FOREST_CAVE_MAGMA = SkiesFeaturePlacements.register("sunset_maple_forest_cave_magma", SkiesConfiguredFeatures.CAVE_MAGMA.m_190821_(SkiesFeaturePlacements.countRange(9, 6)));
    public static final PlacedFeature SUNSET_MAPLE_FOREST_CAVE_MAPLE_VINE = SkiesFeaturePlacements.register("sunset_maple_forest_cave_maple_vine", SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_CAVE_MAPLE_VINE.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature SEARING_GRASSLAND_BUSH = SkiesFeaturePlacements.register("searing_grassland_bush", SkiesConfiguredFeatures.MAPLE_BUSH.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)CountPlacement.m_191628_((int)1), (Block)SkiesBlocks.lunar_sapling)));
    public static final PlacedFeature SEARING_GRASSLAND_ROCK = SkiesFeaturePlacements.register("searing_grassland_rock", SkiesConfiguredFeatures.LUNAR_COBBLESTONE_ROCK.m_190823_(new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)0, (int)1)), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature SEARING_GRASSLAND_CAVE_WALL_SUNSTONE = SkiesFeaturePlacements.register("searing_grassland_cave_wall_sunstone", SkiesConfiguredFeatures.SEARING_GRASSLAND_CAVE_WALL_SUNSTONE.m_190821_(SkiesFeaturePlacements.countRange(59, 20)));
    public static final PlacedFeature SEARING_GRASSLAND_CAVE_MAGMA = SkiesFeaturePlacements.register("searing_grassland_cave_magma", SkiesConfiguredFeatures.CAVE_MAGMA.m_190821_(SkiesFeaturePlacements.countRange(9, 6)));
    public static final PlacedFeature SEARING_GRASSLAND_CAVE_WALL = SkiesFeaturePlacements.register("searing_grassland_cave_wall", SkiesConfiguredFeatures.SEARING_GRASSLAND_CAVE_WALL.m_190821_(SkiesFeaturePlacements.countRange(29, 7)));
    public static final PlacedFeature CRESCENT_ORCHARD_CRESCENT_FRUIT_TREE = SkiesFeaturePlacements.register("crescent_orchard_crescent_fruit_tree", SkiesConfiguredFeatures.CRESCENT_FRUIT_TREE.m_190821_(VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)7, (float)0.1f, (int)1), (Block)SkiesBlocks.crescent_fruit_sapling)));
    public static final PlacedFeature CRESCENT_ORCHARD_CAVE_WALL_UMBER = SkiesFeaturePlacements.register("crescent_orchard_cave_wall_umber", SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_WALL_UMBER.m_190821_(SkiesFeaturePlacements.countRange(59, 35)));
    public static final PlacedFeature CRESCENT_ORCHARD_CAVE_GRASS = SkiesFeaturePlacements.register("crescent_orchard_cave_grass", SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_GRASS.m_190821_(SkiesFeaturePlacements.countRange(59, 15)));
    public static final PlacedFeature CRESCENT_ORCHARD_CAVE_DIRT = SkiesFeaturePlacements.register("crescent_orchard_cave_dirt", SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_DIRT.m_190821_(SkiesFeaturePlacements.countRange(59, 10)));
    public static final PlacedFeature CRESCENT_ORCHARD_CAVE_BLOOM = SkiesFeaturePlacements.register("crescent_orchard_cave_bloom", SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_BLOOM.m_190821_(SkiesFeaturePlacements.countRange(59, 24)));
    public static final PlacedFeature CRESCENT_ORCHARD_CAVE_NIGHTCRESS = SkiesFeaturePlacements.register("crescent_orchard_cave_nightcress", SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_NIGHTCRESS.m_190821_(SkiesFeaturePlacements.countRange(59, 22)));
    public static final PlacedFeature CRESCENT_ORCHARD_CAVE_LUCENTROOT = SkiesFeaturePlacements.register("crescent_orchard_cave_lucentroot", SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_LUCENTROOT.m_190821_(SkiesFeaturePlacements.countRange(59, 18)));

    private static PlacedFeature register(String key, PlacedFeature feature) {
        return PlacementUtils.m_195368_((String)BlueSkies.find(key), (PlacedFeature)feature);
    }

    public static void init() {
    }

    public static void addGeneralBrightFeatures(BiomeGenerationSettings.Builder builder, boolean flowers, boolean mountainous) {
        builder.m_186664_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ICE_AND_SNOW_NO_PATH_CONFIGURED);
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, NATURE_DUNGEON_CHERRY_TREE);
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, NATURE_DUNGEON_STARLIT_BUSH);
        if (flowers) {
            SkiesFeaturePlacements.addBrightFlowers(builder);
        }
        SkiesFeaturePlacements.addDefaultBrightOres(builder, !mountainous);
        SkiesFeaturePlacements.addSprings(builder, false);
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, CAVE_TURQUOISE_DRIPSTONE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, EVERBRIGHT_CAVE_SPAWNER_CONFIGURED);
        SkiesConfiguredCarvers.addBrightCarvers(builder);
    }

    public static void addGeneralDawnFeatures(BiomeGenerationSettings.Builder builder, boolean flowers, boolean superHot) {
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, CAVE_LUNAR_DRIPSTONE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, CAVE_LUNAR_LAVA_SPIRE);
        if (flowers) {
            SkiesFeaturePlacements.addDawnFlowers(builder);
        }
        SkiesFeaturePlacements.addDefaultDawnOres(builder, superHot);
        SkiesFeaturePlacements.addSprings(builder, true);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, EVERDAWN_CAVE_SPAWNER_CONFIGURED);
        SkiesConfiguredCarvers.addDawnCarvers(builder);
    }

    public static void addSprings(BiomeGenerationSettings.Builder builder, boolean allowLava) {
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, SPRING_WATER);
        if (allowLava) {
            builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, SPRING_LAVA);
        }
    }

    public static void addDefaultBrightOres(BiomeGenerationSettings.Builder builder, boolean nonMountainous) {
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_MOONSTONE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_PYROPE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_AQUITE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_DIOPSIDE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_CHAROITE);
        if (nonMountainous) {
            builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_EVERBRIGHT_FALSITE);
            builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_EVERBRIGHT_VENTIUM);
        }
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, COARSE_TURQUOISE_DIRT_BLOB);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, RIMESTONE_BLOB);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, TARATITE_BLOB);
    }

    public static void addDefaultDawnOres(BiomeGenerationSettings.Builder builder, boolean superHot) {
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_MOONSTONE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_PYROPE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_AQUITE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_DIOPSIDE);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_CHAROITE);
        if (superHot) {
            builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, ORE_EVERDAWN_HORIZONITE);
        }
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, COARSE_LUNAR_DIRT_BLOB);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, UMBER_BLOB);
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, CINDERSTONE_BLOB);
    }

    public static void addEmeraldOre(BiomeGenerationSettings.Builder builder, boolean everbright) {
        builder.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, everbright ? ORE_EVERBRIGHT_EMERALD : ORE_EVERDAWN_EMERALD);
    }

    public static void addBrightLakes(BiomeGenerationSettings.Builder builder) {
        builder.m_186664_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, EVERBRIGHT_LAKE_CONFIGURED);
    }

    public static void addDawnLakes(BiomeGenerationSettings.Builder builder) {
        builder.m_186664_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, EVERDAWN_LAKE_CONFIGURED);
    }

    public static void addBrightFlowers(BiomeGenerationSettings.Builder builder) {
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, CAMELLIA_4);
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, BREWBERRY_2);
    }

    public static void addDawnFlowers(BiomeGenerationSettings.Builder builder) {
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, MOONLIT_BLOOM_2);
    }

    public static void addBrightDoubleGrass(BiomeGenerationSettings.Builder builder) {
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, TALL_TURQUOISE_GRASS_NOISE);
    }

    public static void addDawnDoubleGrass(BiomeGenerationSettings.Builder builder) {
        builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, TALL_LUNAR_GRASS_NOISE);
    }

    private static List<PlacementModifier> countRangeRare(int height, int count, PlacementModifier extraModifier) {
        return List.of(CountPlacement.m_191628_((int)count), extraModifier, InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)height)), BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> countRange(int height, int count) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)height)), BiomeFilter.m_191561_());
    }

    private static PlacementModifier range(int height) {
        return HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)height));
    }

    private static List<PlacementModifier> flower(int count) {
        return SkiesFeaturePlacements.flower(count, true);
    }

    private static List<PlacementModifier> flower(int count, boolean legacyFlower) {
        CountPlacement modifier = legacyFlower ? RarityFilter.m_191900_((int)Math.max(2, 32 / count)) : CountPlacement.m_191628_((int)count);
        return List.of(modifier, InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> countNoise(double noise, int x, int y) {
        return SkiesFeaturePlacements.countNoise(noise, x, y, PlacementUtils.f_195352_);
    }

    private static List<PlacementModifier> countNoise(double noise, int x, int y, PlacementModifier heightmap) {
        return List.of(NoiseThresholdCountPlacement.m_191756_((double)noise, (int)x, (int)y), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_());
    }
}

