/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.network.c_to_s.ChangeTomePacket;
import com.legacy.blue_skies.network.c_to_s.GetClientMotionPacket;
import com.legacy.blue_skies.network.c_to_s.OpenInventoryPacket;
import com.legacy.blue_skies.network.c_to_s.OpenedLorePacket;
import com.legacy.blue_skies.network.c_to_s.SpawnSupporterPetPacket;
import com.legacy.blue_skies.network.s_to_c.BossTypePacket;
import com.legacy.blue_skies.network.s_to_c.DisplayToastPacket;
import com.legacy.blue_skies.network.s_to_c.DungeonMusicPacket;
import com.legacy.blue_skies.network.s_to_c.IllagerTeleportPacket;
import com.legacy.blue_skies.network.s_to_c.SetInvisiblePacket;
import com.legacy.blue_skies.network.s_to_c.SetMouseStackPacket;
import com.legacy.blue_skies.network.s_to_c.SpawnParticlePacket;
import com.legacy.blue_skies.network.s_to_c.SyncDataRegistryPacket;
import com.legacy.blue_skies.network.s_to_c.SyncPlayerPacket;
import com.legacy.blue_skies.network.s_to_c.UpdateBlueLorePacket;
import com.legacy.blue_skies.network.s_to_c.UpdateNatureHealthPacket;
import com.legacy.blue_skies.network.s_to_c.UpdateSupportersPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static int index = 0;
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)BlueSkies.locate("main"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        PacketHandler.register(SpawnParticlePacket.class, SpawnParticlePacket::encoder, SpawnParticlePacket::decoder, SpawnParticlePacket::handler);
        PacketHandler.register(BossTypePacket.class, BossTypePacket::encoder, BossTypePacket::decoder, BossTypePacket::handler);
        PacketHandler.register(SetMouseStackPacket.class, SetMouseStackPacket::encoder, SetMouseStackPacket::decoder, SetMouseStackPacket::handler);
        PacketHandler.register(SyncPlayerPacket.class, SyncPlayerPacket::encoder, SyncPlayerPacket::decoder, SyncPlayerPacket::handler);
        PacketHandler.register(SetInvisiblePacket.class, SetInvisiblePacket::encoder, SetInvisiblePacket::decoder, SetInvisiblePacket::handler);
        PacketHandler.register(DungeonMusicPacket.class, DungeonMusicPacket::encoder, DungeonMusicPacket::decoder, DungeonMusicPacket::handler);
        PacketHandler.register(UpdateSupportersPacket.class, UpdateSupportersPacket::encoder, UpdateSupportersPacket::decoder, UpdateSupportersPacket::handler);
        PacketHandler.register(UpdateNatureHealthPacket.class, UpdateNatureHealthPacket::encoder, UpdateNatureHealthPacket::decoder, UpdateNatureHealthPacket::handler);
        PacketHandler.register(UpdateBlueLorePacket.class, UpdateBlueLorePacket::encoder, UpdateBlueLorePacket::decoder, UpdateBlueLorePacket::handler);
        PacketHandler.register(IllagerTeleportPacket.class, IllagerTeleportPacket::encoder, IllagerTeleportPacket::decoder, IllagerTeleportPacket::handler);
        PacketHandler.register(SyncDataRegistryPacket.class, SyncDataRegistryPacket::encoder, SyncDataRegistryPacket::decoder, SyncDataRegistryPacket::handler);
        PacketHandler.register(DisplayToastPacket.class, DisplayToastPacket::encoder, DisplayToastPacket::decoder, DisplayToastPacket::handler);
        PacketHandler.register(OpenInventoryPacket.Arcs.class, OpenInventoryPacket.Arcs::encoder, OpenInventoryPacket.Arcs::decoder, OpenInventoryPacket.Arcs::handler);
        PacketHandler.register(OpenInventoryPacket.Vanilla.class, OpenInventoryPacket.Vanilla::encoder, OpenInventoryPacket.Vanilla::decoder, OpenInventoryPacket.Vanilla::handler);
        PacketHandler.register(OpenInventoryPacket.Mount.class, OpenInventoryPacket.Mount::encoder, OpenInventoryPacket.Mount::decoder, OpenInventoryPacket.Mount::handler);
        PacketHandler.register(GetClientMotionPacket.class, GetClientMotionPacket::encoder, GetClientMotionPacket::decoder, GetClientMotionPacket::handler);
        PacketHandler.register(SpawnSupporterPetPacket.class, SpawnSupporterPetPacket::encoder, SpawnSupporterPetPacket::decoder, SpawnSupporterPetPacket::handler);
        PacketHandler.register(ChangeTomePacket.class, ChangeTomePacket::encoder, ChangeTomePacket::decoder, ChangeTomePacket::handler);
        PacketHandler.register(OpenedLorePacket.class, OpenedLorePacket::encoder, OpenedLorePacket::decoder, OpenedLorePacket::handler);
    }

    private static <MSG> void register(Class<MSG> packet, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(index, packet, encoder, decoder, messageConsumer);
        ++index;
    }

    public static void sendToClient(Object packet, ServerPlayer serverPlayer) {
        if (!(serverPlayer instanceof FakePlayer) && serverPlayer.f_8906_ != null) {
            INSTANCE.sendTo(packet, serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToAllClients(Object packet, Level world) {
        world.m_6907_().forEach(player -> PacketHandler.sendToClient(packet, (ServerPlayer)player));
    }

    public static void sendToServer(Object packet) {
        INSTANCE.sendToServer(packet);
    }
}

