/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools.weapons;

import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.projectile.FluctuantSphereEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SummoningTomeItem
extends Item {
    public SummoningTomeItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack useStack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (useStack.m_41720_() == this && player.m_7655_() == hand) {
            List golems;
            if (SummoningTomeItem.canSummonGolems(useStack) && !(golems = world.m_6443_(ArtificialGolemEntity.class, player.m_142469_().m_82400_(20.0), golem -> golem.playerSpawned() && golem.getCaster().equals((Object)player))).isEmpty()) {
                player.m_5661_((Component)new TranslatableComponent("gui.blue_skies.tooltip.too_many_golems"), true);
                player.m_5810_();
                return InteractionResultHolder.m_19100_((Object)useStack);
            }
            player.f_19853_.m_6269_(null, (Entity)player, SummoningTomeItem.canSummonGolems(useStack) ? SkiesSounds.ENTITY_PLAYER_PREPARE_SUMMONING : SkiesSounds.ENTITY_PLAYER_PREPARE_FLUCTUANT_SPHERE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19098_((Object)useStack);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityIn, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        boolean summonsGolems = SummoningTomeItem.canSummonGolems(stack);
        if (entityIn instanceof Player && i > (summonsGolems ? 20 : 10)) {
            Player player = (Player)entityIn;
            ItemStack itemstack = player.m_21120_(player.m_7655_());
            itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
            if (!worldIn.m_5776_()) {
                if (summonsGolems) {
                    BlockPos pos = player.m_142538_();
                    BlockPos spawnPos = new BlockPos(pos.m_123341_() + (worldIn.f_46441_.nextInt(6) - 3), pos.m_123342_(), pos.m_123343_() + (worldIn.f_46441_.nextInt(6) - 3));
                    if (worldIn instanceof ServerLevelAccessor) {
                        ArtificialGolemEntity golem = new ArtificialGolemEntity(worldIn, (LivingEntity)player);
                        golem.m_20035_(spawnPos, 0.0f, 0.0f);
                        golem.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(new BlockPos(spawnPos.m_123341_(), worldIn.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawnPos.m_123341_(), spawnPos.m_123343_()), spawnPos.m_123343_())), MobSpawnType.MOB_SUMMONED, null, null);
                        golem.m_21051_(Attributes.f_22276_).m_22100_(20.0);
                        golem.m_21153_(golem.m_21233_());
                        if (worldIn.f_46441_.nextFloat() < 0.3f) {
                            golem.setRanged(true);
                        }
                        worldIn.m_7967_((Entity)golem);
                        player.m_36335_().m_41524_((Item)this, 1200);
                        if (worldIn instanceof ServerLevel) {
                            for (int h = 0; h < 20; ++h) {
                                double dx = worldIn.f_46441_.nextGaussian() * 0.02;
                                double dy = worldIn.f_46441_.nextGaussian() * 0.02;
                                double dz = worldIn.f_46441_.nextGaussian() * 0.02;
                                ((ServerLevel)worldIn).m_8767_((ParticleOptions)ParticleTypes.f_123759_, golem.m_20185_() + (double)(worldIn.f_46441_.nextFloat() * golem.m_20205_() * 2.0f) - (double)golem.m_20205_(), golem.m_20186_() + (double)(worldIn.f_46441_.nextFloat() * golem.m_20206_()), golem.m_20189_() + (double)(worldIn.f_46441_.nextFloat() * golem.m_20205_() * 2.0f) - (double)golem.m_20205_(), 1, dx, dy, dz, 0.0);
                            }
                        }
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10580_.m_68256_((ServerPlayer)player, (Entity)golem);
                        }
                    }
                } else {
                    Vec3 lookVector = player.m_20252_(1.0f);
                    FluctuantSphereEntity projectile = new FluctuantSphereEntity(worldIn, (LivingEntity)player, lookVector.f_82479_ * 1.0, lookVector.f_82480_ * 1.0, lookVector.f_82481_ * 1.0);
                    projectile.m_6034_(player.m_20185_() + lookVector.f_82479_ * 1.0, player.m_20186_() + (double)(player.m_20206_() / 2.0f) + (double)0.2f, player.m_20189_() + lookVector.f_82481_ * 1.0);
                    projectile.m_146922_(player.f_20885_);
                    player.f_19853_.m_7967_((Entity)projectile);
                    player.m_36335_().m_41524_((Item)this, 80);
                }
            }
            player.m_5496_(SkiesSounds.ENTITY_PLAYER_CAST_SPELL, 1.0f, 1.0f);
        }
    }

    public static boolean canSummonGolems(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt.m_128471_("SummonsGolems");
    }

    public static ItemStack setSummonsGolems(ItemStack stack, boolean canSummon) {
        CompoundTag compoundnbt = stack.m_41784_();
        compoundnbt.m_128379_("SummonsGolems", canSummon);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> lore, TooltipFlag flagIn) {
        lore.add((Component)new TextComponent(StringUtil.getAbilityText("gui.blue_skies.item.ability.summoning_tome." + (SummoningTomeItem.canSummonGolems(stack) ? "artificial_golem" : "fluctuant_sphere"))));
    }
}

