/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.entities.passive;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.client.init.SkiesRenderRefs;
import com.legacy.blue_skies.client.models.entities.passive.ShadeMonitorModel;
import com.legacy.blue_skies.client.renders.entities.layers.EmissiveRenderLayer;
import com.legacy.blue_skies.entities.passive.ShadeMonitorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShadeMonitorRenderer<T extends ShadeMonitorEntity>
extends MobRenderer<T, ShadeMonitorModel<T>> {
    private static final ResourceLocation TEXTURE_HALLOWEEN = BlueSkies.locate("textures/entity/shade_monitor/shade_monitor_halloween.png");
    private static final ResourceLocation TEXTURE_HALLOWEEN_EYES = BlueSkies.locate("textures/entity/shade_monitor/shade_monitor_halloween_eyes.png");

    public ShadeMonitorRenderer(EntityRendererProvider.Context context) {
        super(context, new ShadeMonitorModel(context.m_174023_(SkiesRenderRefs.SHADE_MONITOR)), 1.0f);
        this.m_115326_(new EmissiveRenderLayer<T, ShadeMonitorModel<T>>((RenderLayerParent)this, TEXTURE_HALLOWEEN_EYES){

            @Override
            protected boolean shouldRenderOverlay(T entity) {
                return ((ShadeMonitorEntity)((Object)entity)).getFestiveStatus() >= 2;
            }
        });
    }

    protected void scale(T entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.m_85841_(1.4f, 1.4f, 1.4f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        int festiveStatus = ((ShadeMonitorEntity)((Object)entity)).getFestiveStatus();
        if (festiveStatus >= 2 || BlueSkiesConfig.COMMON.isHalloween() && festiveStatus >= 1) {
            return TEXTURE_HALLOWEEN;
        }
        return ShadeMonitorEntity.Biomes.byId(((ShadeMonitorEntity)((Object)entity)).getBiome()).getTexture();
    }
}

