/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import team.creative.ambientsounds.AmbientEngine;

public class BiomeEnviroment {
    public final LinkedHashMap<BiomeArea, Float> biomes = new LinkedHashMap();

    public BiomeEnviroment() {
    }

    public BiomeEnviroment(AmbientEngine engine, Player player, Level level, double volume, double surface) {
        if (volume > 0.0) {
            BlockPos center = player.m_146901_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = -engine.biomeScanCount; x <= engine.biomeScanCount; ++x) {
                for (int z = -engine.biomeScanCount; z <= engine.biomeScanCount; ++z) {
                    BiomeArea area;
                    Float before;
                    pos.m_122178_(center.m_123341_() + x * engine.biomeScanDistance, center.m_123342_(), center.m_123343_() + z * engine.biomeScanDistance);
                    Biome biome = level.m_46857_((BlockPos)pos);
                    float biomeVolume = (float)((1.0 - Math.sqrt(center.m_123331_((Vec3i)pos)) / (double)(engine.biomeScanCount * engine.biomeScanDistance * 2)) * volume);
                    if (biome.m_47567_() != Biome.BiomeCategory.UNDERGROUND) {
                        biomeVolume = (float)((double)biomeVolume * surface);
                    }
                    if ((before = this.biomes.get(area = new BiomeArea(level, biome, (BlockPos)pos))) == null) {
                        before = Float.valueOf(0.0f);
                    }
                    this.biomes.put(area, Float.valueOf(Math.max(before.floatValue(), biomeVolume)));
                }
            }
            ArrayList<Map.Entry<BiomeArea, Float>> entries = new ArrayList<Map.Entry<BiomeArea, Float>>(this.biomes.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<BiomeArea, Float>>(){

                @Override
                public int compare(Map.Entry<BiomeArea, Float> o1, Map.Entry<BiomeArea, Float> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            for (Map.Entry entry : entries) {
                this.biomes.put((BiomeArea)entry.getKey(), (Float)entry.getValue());
            }
        }
    }

    public static class BiomeArea {
        public final Biome biome;
        public final ResourceLocation location;
        public final BlockPos pos;

        public BiomeArea(Level level, Biome biome, BlockPos pos) {
            this.biome = biome;
            this.location = level.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
            this.pos = pos;
        }

        public boolean checkBiome(String[] names) {
            for (String name : names) {
                String biomename = this.biome.m_47567_().m_47645_().toLowerCase().replace("_", " ");
                if (biomename.matches(".*" + name.replace("*", ".*") + ".*")) {
                    return true;
                }
                if (!this.location.m_135815_().matches(".*" + name.replace("*", ".*") + ".*")) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof BiomeArea) {
                return ((BiomeArea)object).biome == this.biome;
            }
            return false;
        }

        public int hashCode() {
            return this.biome.hashCode();
        }
    }
}

