/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.scan;

import me.andre111.mambience.accessor.Accessor;

public final class Variables {
    private Accessor accessor;
    private int x;
    private int y;
    private int z;
    private boolean exposed;
    private boolean submerged;
    private long time;
    private boolean raining;
    private boolean thundering;

    public Variables(Accessor a) {
        this.accessor = a;
    }

    public void update() {
        this.x = (int)this.accessor.getX();
        this.y = (int)this.accessor.getY();
        this.z = (int)this.accessor.getZ();
        this.exposed = Variables.fastExposedCheck(this.accessor, this.x, this.y, this.z);
        this.submerged = this.accessor.isSubmerged();
        this.time = this.accessor.getDayTime();
        this.raining = this.accessor.isRaining();
        this.thundering = this.accessor.isThundering();
    }

    public int getHeight() {
        return this.y;
    }

    public boolean isExposed() {
        return this.exposed;
    }

    public boolean isSubmerged() {
        return this.submerged;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isRaining() {
        return this.raining;
    }

    public boolean isThundering() {
        return this.thundering;
    }

    private static boolean fastExposedCheck(Accessor accessor, int x, int y, int z) {
        int mx = x + 1;
        int my = y + 1;
        int mz = z + 1;
        for (int cx = mx - 2; cx <= mx; ++cx) {
            for (int cy = my - 2; cy <= my; ++cy) {
                for (int cz = mz - 2; cz <= mz; ++cz) {
                    if (!accessor.getBlock(cx, cy, cz).equals("minecraft:air") || accessor.getSkyLight(cx, cy, cz) <= 4) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

