/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class Generator {
    protected static void generate(String dir) {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            Path path = Paths.get("./Mambience-" + Generator.getVersion() + "-" + dir + ".zip", new String[0]);
            Files.deleteIfExists(path);
            URI uri = URI.create("jar:" + path.toUri());
            try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
                Generator.transferFile("/pack_template.mcmeta", fs.getPath("/pack.mcmeta", new String[0]));
                Generator.transferFile("/pack.png", fs.getPath("/pack.png", new String[0]));
                Set<String> filePaths = Generator.getResourceFiles(dir + "/");
                for (String filePath : filePaths) {
                    Generator.transferFile("/" + filePath, fs.getPath("/" + filePath, new String[0]));
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static String getVersion() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Generator.class.getResourceAsStream("/version.txt"), "UTF-8"));){
            String string = reader.readLine();
            return string;
        }
    }

    private static Set<String> getResourceFiles(String startPath) throws IOException {
        String me = Generator.class.getName().replace(".", "/") + ".class";
        URL dirURL = Generator.class.getClassLoader().getResource(me);
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            try (JarFile jar = new JarFile(jarPath);){
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(startPath)) continue;
                    result.add(name);
                }
                HashSet<String> hashSet = result;
                return hashSet;
            }
        }
        throw new UnsupportedOperationException("Can only extract resources from jar file!");
    }

    private static void transferFile(String sourcePath, Path targetPath) throws IOException {
        if (Files.isDirectory(targetPath, new LinkOption[0])) {
            return;
        }
        try (InputStream is = Generator.class.getResourceAsStream(sourcePath);){
            if (!Files.exists(targetPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            }
            Files.copy(is, targetPath, new CopyOption[0]);
        }
    }
}

