/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.fabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.andre111.mambience.MAmbience;
import me.andre111.mambience.MAmbienceFabric;
import me.andre111.mambience.config.EffectLoader;
import me.andre111.mambience.config.EventLoader;
import me.andre111.mambience.config.FootstepLoader;
import me.andre111.mambience.config.MaterialLoader;
import me.andre111.mambience.fabric.FootstepBlockMapGenerator;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class MAmbienceResourceReloadListener
implements SimpleSynchronousResourceReloadListener {
    public class_2960 getFabricId() {
        return new class_2960("mambience", "maeffects");
    }

    public void method_14491(class_3300 manager) {
        MaterialLoader.reset();
        EffectLoader.reset();
        EventLoader.reset();
        this.loadEntries(manager, "ma_materials", MaterialLoader::loadMaterial);
        this.loadEntries(manager, "ma_sounds", EventLoader::loadEvent);
        this.loadEntries(manager, "ma_effects", EffectLoader::loadEffect);
        this.loadReplaceable(manager, new class_2960("mambience:ma_footsteps.json"), FootstepLoader::reset, FootstepLoader::loadFootsteps);
        FootstepBlockMapGenerator.scanForMissingBlockMapEntries();
    }

    private void loadEntries(class_3300 manager, String startingPath, BiConsumer<String, JsonObject> callback) {
        HashSet<class_2960> loaded = new HashSet<class_2960>();
        for (class_2960 id : manager.method_14488(startingPath, path -> path.endsWith(".json"))) {
            if (loaded.contains(id)) continue;
            loaded.add(id);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(manager.method_14486(id).method_14482()));){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element instanceof JsonObject) {
                    JsonObject object = (JsonObject)element;
                    String path2 = id.method_12832();
                    class_2960 actualID = new class_2960(id.method_12836(), path2.substring(startingPath.length() + 1, path2.length() - 5));
                    MAmbience.getLogger().log("Loading " + actualID.toString() + " - " + id.toString());
                    callback.accept(actualID.toString(), object);
                    continue;
                }
                throw new RuntimeException("Root is not a json object");
            }
            catch (Exception e) {
                MAmbience.getLogger().error("Exception while loading json " + id.toString() + ": " + e.getMessage());
            }
        }
    }

    private void loadReplaceable(class_3300 manager, class_2960 id, Runnable resetCallback, Consumer<JsonObject> callback) {
        try {
            resetCallback.run();
            for (class_3298 resource : manager.method_14489(id)) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482()));){
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    if (element instanceof JsonObject) {
                        JsonObject object = (JsonObject)element;
                        if (object.has("replace") && object.get("replace").isJsonPrimitive() && object.get("replace").getAsBoolean()) {
                            resetCallback.run();
                        }
                        callback.accept(object);
                        continue;
                    }
                    throw new RuntimeException("Root is not a json object");
                }
                catch (Exception e) {
                    MAmbienceFabric.LOGGER.error("Exception while loading json " + id.toString(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            MAmbienceFabric.LOGGER.error("Exception while loading json " + id.toString(), (Throwable)e);
        }
    }
}

