/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.effect.instance;

import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.effect.EffectInstance;

public class FlameJet
extends EffectInstance {
    private final String type = Math.random() < 0.1 ? "minecraft:lava" : "minecraft:flame";
    private final int strength;
    private final double x;
    private final double y;
    private final double z;
    private boolean firstTick;

    public FlameJet(MAPlayer player, int strength, double x, double y, double z) {
        super(player, (int)(Math.random() * (double)strength + 2.0) * 20);
        this.strength = strength;
        this.x = x;
        this.y = y;
        this.z = z;
        this.firstTick = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.firstTick) {
            this.firstTick = false;
            this.getPlayer().getAccessor().playSound("minecraft:block.fire.ambient", this.x, this.y, this.z, 1.0f, 1.0f);
        }
        if (this.getLife() % 3 == 0) {
            double velocityY = (double)this.strength / 12.0;
            this.getPlayer().getAccessor().addParticle(this.type, "", this.x, this.y, this.z, 0.0, velocityY, 0.0);
            this.getPlayer().getAccessor().addParticle("minecraft:smoke", "", this.x, this.y, this.z, 0.0, velocityY, 0.0);
            this.getPlayer().getAccessor().addParticle(this.type, "", this.x - 0.25, this.y + Math.random() * 0.5, this.z, 0.02 / (double)this.strength, velocityY, 0.0);
            this.getPlayer().getAccessor().addParticle(this.type, "", this.x + 0.25, this.y + Math.random() * 0.5, this.z, -0.02 / (double)this.strength, velocityY, 0.0);
            this.getPlayer().getAccessor().addParticle(this.type, "", this.x, this.y + Math.random() * 0.5, this.z - 0.25, 0.0, velocityY, 0.02 / (double)this.strength);
            this.getPlayer().getAccessor().addParticle(this.type, "", this.x, this.y + Math.random() * 0.5, this.z + 0.25, 0.0, velocityY, -0.02 / (double)this.strength);
        }
    }
}

