/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.MAmbience;
import me.andre111.mambience.ambient.AmbientEvent;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.config.ConfigUtil;
import me.andre111.mambience.sound.Sound;

public final class EventLoader {
    public static final Set<AmbientEvent> EVENTS = new HashSet<AmbientEvent>();

    public static void reset() {
        EVENTS.clear();
    }

    public static void loadEvent(String id, JsonObject obj) {
        EVENTS.add(EventLoader.loadEvent(MAmbience.getLogger(), id, obj));
    }

    private static AmbientEvent loadEvent(MALogger logger, String id, JsonObject obj) {
        Sound[] sounds = ConfigUtil.loadSounds(obj.get("sound"), Config.ambientEvents().getVolume());
        List<Condition> conditions = ConfigUtil.loadConditions(logger, obj.get("conditions").getAsJsonArray());
        List<Condition> restrictions = ConfigUtil.loadConditions(logger, obj.get("restrictions").getAsJsonArray());
        int cooldownMin = ConfigUtil.getInt(obj, "cooldownMin", 1);
        int cooldownMax = ConfigUtil.getInt(obj, "cooldownMax", 1);
        return new AmbientEvent(id, sounds, conditions, restrictions, cooldownMin, cooldownMax);
    }
}

