/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.config.CommentSkippingReader;

public final class DataLoader {
    private static Map<String, List<String>> BIOME_GROUPS;

    public static void loadData(MALogger logger, File file) {
        try (CommentSkippingReader reader = new CommentSkippingReader(new BufferedReader(new FileReader(file)));){
            JsonObject dataElement = JsonParser.parseString((String)reader.readAllLines("\n")).getAsJsonObject();
            DataLoader.loadBiomeGroups(logger, dataElement.get("biomeGroups").getAsJsonArray());
        }
        catch (Exception e) {
            logger.error("Exception loading data: " + file.getAbsolutePath() + ": " + e);
            e.printStackTrace();
        }
    }

    private static void loadBiomeGroups(MALogger logger, JsonArray array) {
        BIOME_GROUPS = new HashMap<String, List<String>>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject obj = array.get(i).getAsJsonObject();
            String name = obj.get("name").getAsString();
            ArrayList<String> biomes = new ArrayList<String>();
            JsonArray biomeArray = obj.get("biomes").getAsJsonArray();
            for (int j = 0; j < biomeArray.size(); ++j) {
                biomes.add(DataLoader.namespaced(biomeArray.get(j).getAsString()));
            }
            BIOME_GROUPS.put(name, biomes);
        }
    }

    public static List<String> getBiomeGroup(String name) {
        return BIOME_GROUPS.get(name);
    }

    public static String namespaced(String name) {
        return name.contains(":") ? name : "minecraft:" + name;
    }
}

