/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.condition;

import java.util.Collections;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.condition.ConditionBiomes;
import me.andre111.mambience.condition.ConditionBlocks;
import me.andre111.mambience.condition.ConditionExposed;
import me.andre111.mambience.condition.ConditionHeight;
import me.andre111.mambience.condition.ConditionRaining;
import me.andre111.mambience.condition.ConditionSubmerged;
import me.andre111.mambience.condition.ConditionThundering;
import me.andre111.mambience.condition.ConditionTime;
import me.andre111.mambience.condition.ConditionUnderground;
import me.andre111.mambience.config.DataLoader;

public final class Parser {
    private static final Condition TIME_MORNING = new ConditionTime(0, 2000);
    private static final Condition TIME_DAY = new ConditionTime(2000, 12000);
    private static final Condition TIME_EVENING = new ConditionTime(12000, 14000);
    private static final Condition TIME_NIGHT = new ConditionTime(14000, 24000);
    private static final Condition EXPOSED = new ConditionExposed();
    private static final Condition SUBMERGED = new ConditionSubmerged();
    private static final Condition UNDERGROUND = new ConditionUnderground();
    private static final Condition RAINING = new ConditionRaining();
    private static final Condition THUNDERING = new ConditionThundering();

    public static Condition parse(String name, String stringValue, float floatValue) {
        switch (name) {
            case "TIME": {
                String[] timeSplit = stringValue.split("\\.\\.");
                int minTime = Integer.parseInt(timeSplit[0]);
                int maxTime = Integer.parseInt(timeSplit[timeSplit.length > 1 ? 1 : 0]);
                return new ConditionTime(minTime, maxTime);
            }
            case "TIME_MORNING": {
                return TIME_MORNING;
            }
            case "TIME_DAY": {
                return TIME_DAY;
            }
            case "TIME_EVENING": {
                return TIME_EVENING;
            }
            case "TIME_NIGHT": {
                return TIME_NIGHT;
            }
            case "BIOME": {
                return new ConditionBiomes(Collections.singletonList(DataLoader.namespaced(stringValue)), floatValue);
            }
            case "BIOME_GROUP": {
                return new ConditionBiomes(DataLoader.getBiomeGroup(stringValue), floatValue);
            }
            case "BLOCK": {
                return new ConditionBlocks(DataLoader.namespaced(stringValue), floatValue);
            }
            case "HEIGHT": {
                float minHeight = Float.parseFloat(stringValue);
                float maxHeight = floatValue;
                return new ConditionHeight(minHeight, maxHeight);
            }
            case "EXPOSED": {
                return EXPOSED;
            }
            case "SUBMERGED": {
                return SUBMERGED;
            }
            case "UNDERGROUND": {
                return UNDERGROUND;
            }
            case "RAINING": {
                return RAINING;
            }
            case "THUNDERING": {
                return THUNDERING;
            }
        }
        return null;
    }
}

