/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.accessor;

import java.util.List;
import java.util.UUID;

public abstract class Accessor {
    protected UUID playerUUID;
    private boolean lastValuesInitialised = false;
    private String lastDimension;
    private double lastX;
    private double lastY;
    private double lastZ;

    public Accessor(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public final void updateLastPosition() {
        this.lastValuesInitialised = true;
        this.lastDimension = this.getDimension();
        this.lastX = this.getX();
        this.lastY = this.getY();
        this.lastZ = this.getZ();
    }

    public final double getDeltaX() {
        if (!this.lastValuesInitialised) {
            return 0.0;
        }
        if (!this.lastDimension.equals(this.getDimension())) {
            return 0.0;
        }
        return this.getX() - this.lastX;
    }

    public final double getDeltaY() {
        if (!this.lastValuesInitialised) {
            return 0.0;
        }
        if (!this.lastDimension.equals(this.getDimension())) {
            return 0.0;
        }
        return this.getY() - this.lastY;
    }

    public final double getDeltaZ() {
        if (!this.lastValuesInitialised) {
            return 0.0;
        }
        if (!this.lastDimension.equals(this.getDimension())) {
            return 0.0;
        }
        return this.getZ() - this.lastZ;
    }

    public abstract boolean updatePlayerInstance();

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getRotation();

    public abstract double getHealth();

    public abstract double getFoodLevel();

    public abstract boolean isSubmerged();

    public abstract boolean isSneaking();

    public abstract boolean isJumping();

    public abstract boolean isOnGround();

    public abstract String getArmor(int var1);

    public abstract void playSound(String var1, float var2, float var3);

    public abstract void playSound(String var1, double var2, double var4, double var6, float var8, float var9);

    public abstract void playGlobalSound(String var1, double var2, double var4, double var6, float var8, float var9);

    public abstract void stopSound(String var1);

    public abstract void addParticle(String var1, String var2, double var3, double var5, double var7, double var9, double var11, double var13);

    public abstract long getDayTime();

    public abstract long getFullTime();

    public abstract boolean isRaining();

    public abstract boolean isThundering();

    public abstract String getBlock(int var1, int var2, int var3);

    public abstract String getBiome(int var1, int var2, int var3);

    public abstract String getDimension();

    public abstract int getLight(int var1, int var2, int var3);

    public abstract int getBlockLight(int var1, int var2, int var3);

    public abstract int getSkyLight(int var1, int var2, int var3);

    public abstract double getTemperature(int var1, int var2, int var3);

    public abstract double getHumidity(int var1, int var2, int var3);

    public abstract List<String> getBlockTag(String var1);
}

