/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience;

import java.util.HashMap;
import java.util.UUID;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.footstep.Footsteps;
import me.andre111.mambience.scan.BlockScanner;
import me.andre111.mambience.scan.Variables;
import me.andre111.mambience.sound.SoundPlayer;

public final class MAPlayer {
    private final UUID playerUUID;
    private final Accessor accessor;
    private final BlockScanner scanner;
    private final Variables variables;
    private final Footsteps footsteps;
    private final SoundPlayer soundPlayer;
    private final MALogger logger;
    private final HashMap<String, Integer> cooldowns;

    public MAPlayer(UUID playerUUID, Accessor accessor, MALogger logger) {
        this.playerUUID = playerUUID;
        this.accessor = accessor;
        this.scanner = new BlockScanner(accessor, Config.scanner().getSizeX(), Config.scanner().getSizeY(), Config.scanner().getSizeZ());
        this.variables = new Variables(accessor);
        this.footsteps = new Footsteps(this);
        this.soundPlayer = new SoundPlayer(accessor, logger);
        this.logger = logger;
        this.cooldowns = new HashMap();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public BlockScanner getScanner() {
        return this.scanner;
    }

    public Variables getVariables() {
        return this.variables;
    }

    public Footsteps getFootsteps() {
        return this.footsteps;
    }

    public SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    public MALogger getLogger() {
        return this.logger;
    }

    public int getCooldown(String key) {
        if (!this.cooldowns.containsKey(key)) {
            return 0;
        }
        return this.cooldowns.get(key);
    }

    public void setCooldown(String key, int value) {
        if (value < 0) {
            value = 0;
        }
        this.cooldowns.put(key, value);
    }

    public int updateCooldown(String key) {
        if (!this.cooldowns.containsKey(key)) {
            return 0;
        }
        int value = this.cooldowns.get(key) - 1;
        this.cooldowns.put(key, value);
        return value;
    }
}

