/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.chococraft.common.blocks.GysahlGreenBlock;
import net.chococraft.common.init.ModEntities;
import net.chococraft.common.init.ModRegistry;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModDatagenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new ModLoot(generator));
        }
        if (event.includeClient()) {
            // empty if block
        }
    }

    private static class ModLoot
    extends LootTableProvider {
        public ModLoot(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(ModBlockTables::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(ModEntityTables::new, (Object)LootContextParamSets.f_81415_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationtracker) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private static class ModEntityTables
        extends EntityLoot {
            private ModEntityTables() {
            }

            protected void addTables() {
                this.m_124371_((EntityType)ModEntities.CHOCOBO.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModRegistry.CHOCOBO_FEATHER.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModRegistry.CHOCOBO_DRUMSTICK_RAW.get())).m_5577_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            }

            protected Iterable<EntityType<?>> getKnownEntities() {
                Stream<EntityType> entityTypeStream = ModEntities.ENTITIES.getEntries().stream().map(RegistryObject::get);
                return entityTypeStream::iterator;
            }
        }

        private static class ModBlockTables
        extends BlockLoot {
            private ModBlockTables() {
            }

            protected void addTables() {
                this.m_124165_((Block)ModRegistry.CHOCOBO_EGG.get(), ModBlockTables.m_124125_());
                this.m_124288_((Block)ModRegistry.STRAW_NEST.get());
                LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)ModRegistry.GYSAHL_GREEN.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)GysahlGreenBlock.AGE, 4));
                this.m_124165_((Block)ModRegistry.GYSAHL_GREEN.get(), (LootTable.Builder)ModBlockTables.m_124131_((ItemLike)((ItemLike)ModRegistry.GYSAHL_GREEN.get()), (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModRegistry.GYSAHL_GREEN.get())))).m_79161_(LootPool.m_79043_().m_6509_((LootItemCondition.Builder)condition).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModRegistry.GYSAHL_GREEN_ITEM.get())).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).m_79161_(LootPool.m_79043_().m_6509_((LootItemCondition.Builder)condition).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ModRegistry.LOVELY_GYSAHL_GREEN.get())).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.02f))))));
            }

            protected Iterable<Block> getKnownBlocks() {
                return ModRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    private static class FarmingItemModels
    extends ItemModelProvider {
        public FarmingItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "chococraft", helper);
        }

        protected void registerModels() {
            ModRegistry.ITEMS.getEntries().stream().map(RegistryObject::get).forEach(item -> {
                String path = Objects.requireNonNull(item.getRegistryName()).m_135815_();
                if (path.equals("straw_nest") || path.equals("chocobo_egg")) {
                    this.withExistingParent(path, this.modLoc("block/" + path));
                } else {
                    this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + path));
                }
            });
        }

        public String m_6055_() {
            return "Item Models";
        }
    }
}

