/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.network.packets;

import java.util.function.Supplier;
import net.chococraft.common.ChocoConfig;
import net.chococraft.common.entities.ChocoboEntity;
import net.chococraft.common.handler.ExperienceHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class UpgradeChocoboMessage {
    public int entityID;
    public int skillID;

    public UpgradeChocoboMessage(ChocoboEntity chocobo, int skillID) {
        this.entityID = chocobo.m_142049_();
        this.skillID = skillID;
    }

    public UpgradeChocoboMessage(int entityID, int skillID) {
        this.entityID = entityID;
        this.skillID = skillID;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.skillID);
    }

    public static UpgradeChocoboMessage decode(FriendlyByteBuf buffer) {
        return new UpgradeChocoboMessage(buffer.readInt(), buffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            Level world;
            Entity entity;
            ServerPlayer player;
            if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER && (player = ctx.getSender()) != null && (entity = (world = player.f_19853_).m_6815_(this.entityID)) instanceof ChocoboEntity) {
                if (this.skillID == 1 && ExperienceHandler.removeExperience((Player)player, (Integer)ChocoConfig.COMMON.ExpCostSprint.get())) {
                    ((ChocoboEntity)entity).setCanSprint(true);
                } else if (this.skillID == 2 && ExperienceHandler.removeExperience((Player)player, (Integer)ChocoConfig.COMMON.ExpCostGlide.get())) {
                    ((ChocoboEntity)entity).setCanGlide(true);
                } else if (this.skillID == 3 && ExperienceHandler.removeExperience((Player)player, (Integer)ChocoConfig.COMMON.ExpCostDive.get())) {
                    ((ChocoboEntity)entity).setCanDive(true);
                } else if (this.skillID == 4 && ExperienceHandler.removeExperience((Player)player, (Integer)ChocoConfig.COMMON.ExpCostFly.get())) {
                    ((ChocoboEntity)entity).setCanFly(true);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

