/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.network.packets;

import java.util.function.Supplier;
import net.chococraft.common.entities.ChocoboEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ChocoboSprintingMessage {
    private boolean sprinting;

    public ChocoboSprintingMessage(boolean sprinting) {
        this.sprinting = sprinting;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.sprinting);
    }

    public static ChocoboSprintingMessage decode(FriendlyByteBuf buffer) {
        return new ChocoboSprintingMessage(buffer.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player;
            if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER && (player = ctx.getSender()) != null) {
                if (player.m_20202_() == null) {
                    return;
                }
                Entity mount = player.m_20202_();
                if (!(mount instanceof ChocoboEntity)) {
                    return;
                }
                mount.m_6858_(this.sprinting);
            }
        });
        ctx.setPacketHandled(true);
    }
}

