/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.inventory;

import net.chococraft.common.entities.ChocoboEntity;
import net.chococraft.common.inventory.SlotChocoboSaddle;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SaddleBagContainer
extends AbstractContainerMenu {
    private ChocoboEntity chocobo;

    public SaddleBagContainer(int id, Inventory player, ChocoboEntity chocobo) {
        super(null, id);
        this.chocobo = chocobo;
        this.refreshSlots(chocobo, player);
    }

    public ChocoboEntity getChocobo() {
        return this.chocobo;
    }

    public void refreshSlots(ChocoboEntity chocobo, Inventory player) {
        Item item;
        this.f_38839_.clear();
        this.bindPlayerInventory(player);
        ItemStack saddleStack = chocobo.getSaddle();
        if (!saddleStack.m_41619_() && (item = saddleStack.m_41720_()) instanceof ChocoboSaddleItem) {
            ChocoboSaddleItem saddleItem = (ChocoboSaddleItem)item;
            switch (saddleItem.getInventorySize()) {
                case 18: {
                    this.bindInventorySmall((IItemHandler)chocobo.chocoboInventory);
                    break;
                }
                case 54: {
                    this.bindInventoryBig((IItemHandler)chocobo.chocoboInventory);
                }
            }
        }
        this.m_38897_((Slot)new SlotChocoboSaddle(chocobo.saddleItemStackHandler, 0, -16, 18));
    }

    private void bindInventorySmall(IItemHandler inventory) {
        if (inventory != null && inventory.getSlots() == 18) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 5; ++col) {
                    this.m_38897_((Slot)new SlotItemHandler(inventory, row * 5 + col, 44 + col * 18, 36 + row * 18));
                }
            }
        }
    }

    private void bindInventoryBig(IItemHandler inventory) {
        if (inventory != null && inventory.getSlots() == 54) {
            for (int row = 0; row < 5; ++row) {
                for (int col = 0; col < 9; ++col) {
                    this.m_38897_((Slot)new SlotItemHandler(inventory, row * 9 + col, 8 + col * 18, 18 + row * 18));
                }
            }
        }
    }

    private void bindPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 122 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 180));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.chocobo.m_6084_() && this.chocobo.m_20270_((Entity)playerIn) < 8.0f;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        return ItemStack.f_41583_;
    }
}

