/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entities.breeding;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.chococraft.Chococraft;
import net.chococraft.common.blockentities.ChocoboEggBlockEntity;
import net.chococraft.common.entities.ChocoboEntity;
import net.chococraft.common.entities.breeding.ChocoboBreedInfo;
import net.chococraft.common.entities.breeding.ChocoboStatSnapshot;
import net.chococraft.common.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ChocoboMateGoal
extends Goal {
    private static final Vec3i[] LAY_EGG_CHECK_OFFSETS = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(1, 0, -1), new Vec3i(1, 0, 0), new Vec3i(1, 0, 1), new Vec3i(0, 0, 1), new Vec3i(-1, 0, 1), new Vec3i(0, 1, 0), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(1, 1, -1), new Vec3i(1, 1, 0), new Vec3i(1, 1, 1), new Vec3i(0, 1, 1), new Vec3i(-1, 1, 1)};
    private final ChocoboEntity chocobo;
    private final Level world;
    private final double moveSpeed;
    private ChocoboEntity targetMate;
    private int spawnBabyDelay;

    public ChocoboMateGoal(ChocoboEntity chocobo, double moveSpeed) {
        this.chocobo = chocobo;
        this.world = chocobo.f_19853_;
        this.moveSpeed = moveSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.chocobo.m_27593_() && (this.targetMate = this.getNearbyMate()) != null;
    }

    public boolean m_8045_() {
        return this.targetMate.m_6084_() && this.targetMate.m_27593_() && this.spawnBabyDelay < 60;
    }

    public void m_8041_() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void m_8037_() {
        this.chocobo.m_21563_().m_24960_((Entity)this.targetMate, 10.0f, (float)this.chocobo.m_8132_());
        this.chocobo.m_21573_().m_5624_((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.chocobo.m_20280_((Entity)this.targetMate) < 9.0) {
            this.spawnEgg();
        }
    }

    @Nullable
    private ChocoboEntity getNearbyMate() {
        List list = this.world.m_45976_(ChocoboEntity.class, this.chocobo.m_142469_().m_82400_(8.0));
        double dist = Double.MAX_VALUE;
        ChocoboEntity closestMate = null;
        for (ChocoboEntity entry : list) {
            if (!this.chocobo.m_7848_((Animal)entry) || !(this.chocobo.m_20280_((Entity)entry) < dist)) continue;
            closestMate = entry;
            dist = this.chocobo.m_20280_((Entity)entry);
        }
        return closestMate;
    }

    private void spawnEgg() {
        if (this.chocobo.isMale()) {
            return;
        }
        this.chocobo.m_146762_(6000);
        this.targetMate.m_146762_(6000);
        this.chocobo.m_27594_();
        this.targetMate.m_27594_();
        BlockPos pos = this.chocobo.m_142538_();
        for (Vec3i offset : LAY_EGG_CHECK_OFFSETS) {
            BlockPos offsetPos = pos.m_141952_(offset);
            BlockState state = this.world.m_8055_(offsetPos);
            if (!state.m_60767_().m_76336_() || state.m_60767_().m_76332_() || !((Block)ModRegistry.CHOCOBO_EGG.get()).m_7898_(state, (LevelReader)this.world, offsetPos)) continue;
            if (!this.world.m_46597_(offsetPos, ((Block)ModRegistry.CHOCOBO_EGG.get()).m_49966_())) {
                Chococraft.log.error("Unable to place egg @ {}, setBlockState() returned false!", (Object)offsetPos);
                return;
            }
            BlockEntity tile = this.world.m_7702_(offsetPos);
            if (!(tile instanceof ChocoboEggBlockEntity)) {
                Chococraft.log.error("Unable to place egg @ {}, no tile entity was found at the given position!", (Object)offsetPos);
                return;
            }
            ChocoboEggBlockEntity eggTile = (ChocoboEggBlockEntity)tile;
            eggTile.setBreedInfo(new ChocoboBreedInfo(new ChocoboStatSnapshot(this.chocobo), new ChocoboStatSnapshot(this.targetMate)));
            return;
        }
    }
}

