/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entities.breeding;

import net.chococraft.common.ChocoConfig;
import net.chococraft.common.entities.ChocoboEntity;
import net.chococraft.common.entities.breeding.ChocoboBreedInfo;
import net.chococraft.common.entities.breeding.ChocoboStatSnapshot;
import net.chococraft.common.entities.properties.ChocoboColor;
import net.chococraft.common.init.ModAttributes;
import net.chococraft.common.init.ModEntities;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class BreedingHelper {
    public static ChocoboBreedInfo getBreedInfo(ChocoboEntity mother, ChocoboEntity father) {
        return new ChocoboBreedInfo(new ChocoboStatSnapshot(mother), new ChocoboStatSnapshot(father));
    }

    public static ChocoboEntity createChild(ChocoboBreedInfo breedInfo, Level world) {
        ChocoboEntity baby = (ChocoboEntity)((EntityType)ModEntities.CHOCOBO.get()).m_20615_(world);
        if (baby == null) {
            return null;
        }
        ChocoboStatSnapshot mother = breedInfo.getMother();
        ChocoboStatSnapshot father = breedInfo.getFather();
        baby.setGeneration((mother.generation + father.generation) / 2 + 1);
        float health = Math.round((mother.health + father.health) / 2.0f * (((Double)ChocoConfig.COMMON.poslossHealth.get()).floatValue() + (float)Math.random() * ((Double)ChocoConfig.COMMON.posgainHealth.get()).floatValue()));
        baby.m_21051_(Attributes.f_22276_).m_22100_((double)Math.min(health, ((Integer)ChocoConfig.COMMON.maxHealth.get()).floatValue()));
        float speed = (mother.speed + father.speed) / 2.0f * (((Double)ChocoConfig.COMMON.poslossSpeed.get()).floatValue() + (float)Math.random() * ((Double)ChocoConfig.COMMON.posgainSpeed.get()).floatValue());
        baby.m_21051_(Attributes.f_22279_).m_22100_((double)Math.min(speed, ((Integer)ChocoConfig.COMMON.maxSpeed.get()).floatValue() / 100.0f));
        float stamina = (float)Math.round((mother.stamina + father.stamina) / 2.0f) * (((Double)ChocoConfig.COMMON.poslossStamina.get()).floatValue() + (float)Math.random() * ((Double)ChocoConfig.COMMON.posgainStamina.get()).floatValue());
        baby.m_21051_((Attribute)ModAttributes.MAX_STAMINA.get()).m_22100_((double)Math.min(stamina, ((Double)ChocoConfig.COMMON.maxStamina.get()).floatValue()));
        float canFlyChance = BreedingHelper.calculateChance(0.005f, 0.15f, 0.35f, mother.canFly, father.canFly);
        float canflychancerandom = (float)Math.random();
        baby.setCanFly(canFlyChance > canflychancerandom);
        float canDiveChance = BreedingHelper.calculateChance(0.01f, 0.2f, 0.4f, mother.canDive, father.canDive);
        float candivechancerandom = (float)Math.random();
        baby.setCanDive(canDiveChance > candivechancerandom);
        float canGlideChance = BreedingHelper.calculateChance(0.01f, 0.2f, 0.45f, mother.canGlide, father.canGlide);
        float canglidechancerandom = (float)Math.random();
        baby.setCanGlide(canGlideChance > canglidechancerandom);
        float canSprintChance = BreedingHelper.calculateChance(0.03f, 0.25f, 0.5f, mother.canSprint, father.canSprint);
        float cansprintchancerandom = (float)Math.random();
        baby.setCanSprint(canSprintChance > cansprintchancerandom);
        baby.setMale(0.5f > (float)Math.random());
        ChocoboColor color = ChocoboColor.YELLOW;
        if (mother.color == ChocoboColor.FLAME && father.color == ChocoboColor.FLAME) {
            color = ChocoboColor.FLAME;
        } else if (canFlyChance > canflychancerandom) {
            color = ChocoboColor.GOLD;
        } else if (canDiveChance > candivechancerandom) {
            color = ChocoboColor.BLUE;
        } else if (canGlideChance > canglidechancerandom) {
            color = ChocoboColor.WHITE;
        } else if (canSprintChance > cansprintchancerandom) {
            color = ChocoboColor.GREEN;
        }
        baby.setChocoboColor(color);
        baby.m_146762_(-24000);
        return baby;
    }

    private static float calculateChance(float baseChance, float perParentChance, float bothParentsChance, boolean motherHasAbility, boolean fatherHasAbility) {
        return baseChance + (motherHasAbility || fatherHasAbility ? perParentChance : 0.0f) + (motherHasAbility && fatherHasAbility ? bothParentsChance : 0.0f);
    }
}

