/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entities;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.chococraft.client.gui.ChocoboInfoScreen;
import net.chococraft.common.ChocoConfig;
import net.chococraft.common.entities.breeding.ChocoboMateGoal;
import net.chococraft.common.entities.properties.ChocoboColor;
import net.chococraft.common.entities.properties.ModDataSerializers;
import net.chococraft.common.entities.properties.MovementType;
import net.chococraft.common.init.ModAttributes;
import net.chococraft.common.init.ModRegistry;
import net.chococraft.common.init.ModSounds;
import net.chococraft.common.inventory.SaddleBagContainer;
import net.chococraft.common.inventory.SaddleItemStackHandler;
import net.chococraft.common.items.ChocoDisguiseItem;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.chococraft.common.network.PacketManager;
import net.chococraft.common.network.packets.OpenChocoboGuiMessage;
import net.chococraft.utils.RandomHelper;
import net.chococraft.utils.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class ChocoboEntity
extends TamableAnimal {
    private static final String NBTKEY_CHOCOBO_COLOR = "Color";
    private static final String NBTKEY_CHOCOBO_IS_MALE = "Male";
    private static final String NBTKEY_MOVEMENTTYPE = "MovementType";
    private static final String NBTKEY_SADDLE_ITEM = "Saddle";
    private static final String NBTKEY_INVENTORY = "Inventory";
    private static final String NBTKEY_NEST_POSITION = "NestPos";
    private static final String NBTKEY_CHOCOBO_GENERATION = "Generation";
    private static final String NBTKEY_CHOCOBO_STAMINA = "Stamina";
    private static final String NBTKEY_CHOCOBO_CAN_FLY = "CanFly";
    private static final String NBTKEY_CHOCOBO_CAN_GLIDE = "CanGlide";
    private static final String NBTKEY_CHOCOBO_CAN_SPRINT = "CanSprint";
    private static final String NBTKEY_CHOCOBO_CAN_DIVE = "CanDive";
    private static final byte CAN_SPRINT_BIT = 1;
    private static final byte CAN_DIVE_BIT = 2;
    private static final byte CAN_GLIDE_BIT = 4;
    private static final byte CAN_FLY_BIT = 8;
    private static final EntityDataAccessor<ChocoboColor> PARAM_COLOR = SynchedEntityData.m_135353_(ChocoboEntity.class, ModDataSerializers.CHOCOBO_COLOR);
    private static final EntityDataAccessor<Boolean> PARAM_IS_MALE = SynchedEntityData.m_135353_(ChocoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<MovementType> PARAM_MOVEMENT_TYPE = SynchedEntityData.m_135353_(ChocoboEntity.class, ModDataSerializers.MOVEMENT_TYPE);
    private static final EntityDataAccessor<ItemStack> PARAM_SADDLE_ITEM = SynchedEntityData.m_135353_(ChocoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> PARAM_GENERATION = SynchedEntityData.m_135353_(ChocoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> PARAM_STAMINA = SynchedEntityData.m_135353_(ChocoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> PARAM_ABILITY_MASK = SynchedEntityData.m_135353_(ChocoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UUID CHOCOBO_SPRINTING_BOOST_ID = UUID.fromString("03ba3167-393e-4362-92b8-909841047640");
    private static final AttributeModifier CHOCOBO_SPRINTING_SPEED_BOOST = new AttributeModifier(CHOCOBO_SPRINTING_BOOST_ID, "Chocobo sprinting speed boost", 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private AvoidEntityGoal chocoboAvoidPlayerGoal;
    public final ItemStackHandler chocoboInventory = new ItemStackHandler(){};
    public final SaddleItemStackHandler saddleItemStackHandler = new SaddleItemStackHandler(){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41619_() || stack.m_41720_() instanceof ChocoboSaddleItem;
        }

        @Override
        protected void onStackChanged() {
            ChocoboEntity.this.setSaddleType(this.itemStack);
        }
    };
    private LazyOptional<IItemHandler> saddleHolder = LazyOptional.of(() -> this.saddleItemStackHandler);
    private float wingRotation;
    private float destPos;
    private boolean isChocoboJumping;
    private float wingRotDelta;
    private BlockPos nestPos;
    private final FollowOwnerGoal follow = new FollowOwnerGoal((TamableAnimal)this, 2.0, 3.0f, 10.0f, false);
    public float followingmrhuman = 2.0f;
    public int TimeSinceFeatherChance = 0;

    public ChocoboEntity(EntityType<? extends ChocoboEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new ChocoboMateGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.GYSAHL_GREEN.get()}), false));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_((Attribute)ModAttributes.MAX_STAMINA.get(), (double)((Integer)ChocoConfig.COMMON.defaultStamina.get()).intValue()).m_22268_(Attributes.f_22279_, (double)((float)((Integer)ChocoConfig.COMMON.defaultSpeed.get()).intValue() / 100.0f)).m_22268_(Attributes.f_22276_, (double)((Integer)ChocoConfig.COMMON.defaultHealth.get()).intValue());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARAM_COLOR, (Object)ChocoboColor.YELLOW);
        this.f_19804_.m_135372_(PARAM_IS_MALE, (Object)false);
        this.f_19804_.m_135372_(PARAM_MOVEMENT_TYPE, (Object)MovementType.WANDER);
        this.f_19804_.m_135372_(PARAM_SADDLE_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(PARAM_STAMINA, (Object)Float.valueOf(((Integer)ChocoConfig.COMMON.defaultStamina.get()).intValue()));
        this.f_19804_.m_135372_(PARAM_GENERATION, (Object)0);
        this.f_19804_.m_135372_(PARAM_ABILITY_MASK, (Object)0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setMale(this.f_19853_.f_46441_.nextBoolean());
        Biome currentBiome = this.f_19853_.m_46857_(this.m_142538_().m_7495_());
        if (currentBiome.m_47567_() == Biome.BiomeCategory.NETHER) {
            this.setChocoboColor(ChocoboColor.FLAME);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_5807_() {
        return this.m_21824_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setChocoboColor(ChocoboColor.values()[compound.m_128445_(NBTKEY_CHOCOBO_COLOR)]);
        this.setMale(compound.m_128471_(NBTKEY_CHOCOBO_IS_MALE));
        this.setMovementType(MovementType.values()[compound.m_128445_(NBTKEY_MOVEMENTTYPE)]);
        this.saddleItemStackHandler.deserializeNBT(compound.m_128469_(NBTKEY_SADDLE_ITEM));
        if (!this.getSaddle().m_41619_()) {
            this.chocoboInventory.deserializeNBT(compound.m_128469_(NBTKEY_INVENTORY));
        }
        if (compound.m_128441_(NBTKEY_NEST_POSITION)) {
            this.nestPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_(NBTKEY_NEST_POSITION));
        }
        this.setGeneration(compound.m_128451_(NBTKEY_CHOCOBO_GENERATION));
        this.setStamina(compound.m_128457_(NBTKEY_CHOCOBO_STAMINA));
        this.setCanFly(compound.m_128471_(NBTKEY_CHOCOBO_CAN_FLY));
        this.setCanGlide(compound.m_128471_(NBTKEY_CHOCOBO_CAN_GLIDE));
        this.setCanSprint(compound.m_128471_(NBTKEY_CHOCOBO_CAN_SPRINT));
        this.setCanDive(compound.m_128471_(NBTKEY_CHOCOBO_CAN_DIVE));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_(NBTKEY_CHOCOBO_COLOR, (byte)this.getChocoboColor().ordinal());
        compound.m_128379_(NBTKEY_CHOCOBO_IS_MALE, this.isMale());
        compound.m_128344_(NBTKEY_MOVEMENTTYPE, (byte)this.getMovementType().ordinal());
        compound.m_128365_(NBTKEY_SADDLE_ITEM, (net.minecraft.nbt.Tag)this.saddleItemStackHandler.serializeNBT());
        if (!this.getSaddle().m_41619_()) {
            compound.m_128365_(NBTKEY_INVENTORY, (net.minecraft.nbt.Tag)this.chocoboInventory.serializeNBT());
        }
        if (this.nestPos != null) {
            compound.m_128365_(NBTKEY_NEST_POSITION, (net.minecraft.nbt.Tag)NbtUtils.m_129224_((BlockPos)this.nestPos));
        }
        compound.m_128405_(NBTKEY_CHOCOBO_GENERATION, this.getGeneration());
        compound.m_128350_(NBTKEY_CHOCOBO_STAMINA, this.getStamina());
        compound.m_128379_(NBTKEY_CHOCOBO_CAN_FLY, this.canFly());
        compound.m_128379_(NBTKEY_CHOCOBO_CAN_GLIDE, this.canGlide());
        compound.m_128379_(NBTKEY_CHOCOBO_CAN_SPRINT, this.canSprint());
        compound.m_128379_(NBTKEY_CHOCOBO_CAN_DIVE, this.canDive());
    }

    public ChocoboColor getChocoboColor() {
        return (ChocoboColor)((Object)this.f_19804_.m_135370_(PARAM_COLOR));
    }

    public void setChocoboColor(ChocoboColor color) {
        this.f_19804_.m_135381_(PARAM_COLOR, (Object)color);
    }

    public boolean m_5825_() {
        return this.getChocoboColor() == ChocoboColor.FLAME;
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(PARAM_IS_MALE);
    }

    public void setMale(boolean isMale) {
        this.f_19804_.m_135381_(PARAM_IS_MALE, (Object)isMale);
    }

    public MovementType getMovementType() {
        return (MovementType)((Object)this.f_19804_.m_135370_(PARAM_MOVEMENT_TYPE));
    }

    public void setMovementType(MovementType type) {
        this.f_19804_.m_135381_(PARAM_MOVEMENT_TYPE, (Object)type);
    }

    public boolean isSaddled() {
        return !this.getSaddle().m_41619_();
    }

    public ItemStack getSaddle() {
        return (ItemStack)this.f_19804_.m_135370_(PARAM_SADDLE_ITEM);
    }

    private void setSaddleType(ItemStack saddleStack) {
        ItemStack newStack = saddleStack;
        ItemStack oldStack = this.getSaddle();
        if (oldStack.m_41720_() != newStack.m_41720_()) {
            this.f_19804_.m_135381_(PARAM_SADDLE_ITEM, (Object)newStack.m_41777_());
            this.reconfigureInventory(oldStack, newStack);
        }
    }

    private int getSaddleCount(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ChocoboSaddleItem) {
            ChocoboSaddleItem saddle = (ChocoboSaddleItem)item;
            return saddle.getInventorySize();
        }
        return 0;
    }

    @Nullable
    public BlockPos getNestPosition() {
        return this.nestPos;
    }

    public void setNestPosition(@Nullable BlockPos nestPos) {
        this.nestPos = nestPos;
    }

    public float getStamina() {
        return ((Float)this.f_19804_.m_135370_(PARAM_STAMINA)).floatValue();
    }

    public void setStamina(float value) {
        this.f_19804_.m_135381_(PARAM_STAMINA, (Object)Float.valueOf(value));
    }

    public float getStaminaPercentage() {
        return (float)((double)this.getStamina() / this.m_21051_((Attribute)ModAttributes.MAX_STAMINA.get()).m_22135_());
    }

    public int getGeneration() {
        return (Integer)this.f_19804_.m_135370_(PARAM_GENERATION);
    }

    public void setGeneration(int value) {
        this.f_19804_.m_135381_(PARAM_GENERATION, (Object)value);
    }

    private boolean useStamina(float value) {
        if (value == 0.0f) {
            return true;
        }
        float curStamina = ((Float)this.f_19804_.m_135370_(PARAM_STAMINA)).floatValue();
        if (curStamina < value) {
            return false;
        }
        float maxStamina = (float)this.m_21051_((Attribute)ModAttributes.MAX_STAMINA.get()).m_22135_();
        float newStamina = Mth.m_14036_((float)(curStamina - value), (float)0.0f, (float)maxStamina);
        this.f_19804_.m_135381_(PARAM_STAMINA, (Object)Float.valueOf(newStamina));
        return true;
    }

    public boolean canFly() {
        return ((Byte)this.f_19804_.m_135370_(PARAM_ABILITY_MASK) & 8) > 0;
    }

    public void setCanFly(boolean state) {
        this.setAbilityMaskBit(8, state);
    }

    public boolean canGlide() {
        return ((Byte)this.f_19804_.m_135370_(PARAM_ABILITY_MASK) & 4) > 0;
    }

    public void setCanGlide(boolean state) {
        this.setAbilityMaskBit(4, state);
    }

    public boolean canSprint() {
        return ((Byte)this.f_19804_.m_135370_(PARAM_ABILITY_MASK) & 1) > 0;
    }

    public void setCanSprint(boolean state) {
        this.setAbilityMaskBit(1, state);
    }

    public boolean canDive() {
        return ((Byte)this.f_19804_.m_135370_(PARAM_ABILITY_MASK) & 2) > 0;
    }

    public void setCanDive(boolean state) {
        this.setAbilityMaskBit(2, state);
    }

    private void setAbilityMaskBit(int bit, boolean state) {
        byte value = (Byte)this.f_19804_.m_135370_(PARAM_ABILITY_MASK);
        this.f_19804_.m_135381_(PARAM_ABILITY_MASK, (Object)((byte)(state ? value | bit : value & ~bit)));
    }

    public double m_6048_() {
        return 1.65;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    protected boolean m_20073_() {
        this.f_19799_.clear();
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double d0 = this.f_19853_.m_6042_().m_63951_() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.m_19943_((Tag)FluidTags.f_13132_, d0);
        return this.m_20069_() || flag;
    }

    private void updateInWaterStateAndDoWaterCurrentPushing() {
        if (this.m_20202_() instanceof ChocoboEntity) {
            this.f_19798_ = false;
        } else if (this.m_19943_((Tag)FluidTags.f_13131_, 0.014)) {
            if (!this.f_19798_ && !this.f_19803_) {
                this.m_5841_();
            }
            this.f_19789_ = 0.0f;
            this.f_19798_ = true;
            this.m_20095_();
        } else {
            this.f_19798_ = false;
        }
    }

    public void m_7023_(Vec3 travelVector) {
        Vec3 newVector = travelVector;
        Entity entity = this.m_6688_();
        if (entity instanceof Player) {
            Player rider = (Player)entity;
            this.f_19859_ = rider.m_146908_();
            this.f_19860_ = rider.m_146909_();
            this.m_146922_(rider.m_146908_());
            this.m_146926_(rider.m_146909_());
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.m_146908_();
            this.f_20883_ = this.m_146908_();
            newVector = new Vec3((double)(rider.f_20900_ * 0.5f), newVector.f_82480_, (double)rider.f_20902_);
            if (newVector.m_7094_() <= 0.0) {
                newVector = new Vec3(newVector.f_82479_, newVector.f_82480_, newVector.f_82481_ * 0.25);
            }
            if (this.f_19861_) {
                this.isChocoboJumping = false;
            }
            if ((this.canGlide() || this.canFly()) && !rider.m_20069_()) {
                this.f_20887_ = 0.07f;
            } else if (rider.m_20069_() || !this.canGlide() && !this.canFly()) {
                this.f_20887_ = 0.05f;
            }
            if (this.m_6109_()) {
                Vec3 motion;
                if (rider.f_20899_) {
                    if (rider.m_20142_() && this.canFly() && !rider.m_20069_() && this.useStamina(((Double)ChocoConfig.COMMON.flyStaminaCost.get()).floatValue())) {
                        motion = this.m_20184_();
                        double groundValue = this.f_19861_ ? 0.5 : (double)0.1f;
                        this.m_20256_(new Vec3(motion.f_82479_, motion.f_82480_ + groundValue, motion.f_82481_));
                        if (this.m_20184_().f_82480_ > 0.5) {
                            this.m_20256_(new Vec3(motion.f_82479_, 0.5, motion.f_82481_));
                        }
                        this.m_6858_(false);
                    } else if (!this.isChocoboJumping && this.f_19861_ && this.useStamina(((Double)ChocoConfig.COMMON.jumpStaminaCost.get()).floatValue())) {
                        motion = this.m_20184_();
                        this.m_20256_(new Vec3(motion.f_82479_, (double)0.6f, motion.f_82481_));
                        this.isChocoboJumping = true;
                    }
                }
                if (rider.m_20069_()) {
                    int distance;
                    motion = this.m_20184_();
                    if (this.canDive()) {
                        if (rider.m_6144_()) {
                            this.m_20256_(new Vec3(motion.f_82479_, motion.f_82480_ - (double)0.05f, motion.f_82481_));
                            if (this.m_20184_().f_82480_ < (double)-0.7f) {
                                this.m_20256_(new Vec3(motion.f_82479_, (double)0.7f, motion.f_82481_));
                            }
                        }
                        if (rider.f_20899_) {
                            this.m_20256_(new Vec3(motion.f_82479_, 0.5, motion.f_82481_));
                        }
                        this.f_19798_ = false;
                        this.m_6858_(false);
                    } else if (rider.f_20899_) {
                        this.m_20256_(new Vec3(motion.f_82479_, 0.5, motion.f_82481_));
                    } else if (this.m_20184_().f_82480_ < 0.0 && (distance = WorldUtils.getDistanceToSurface(this.m_142538_(), this.m_20193_())) > 0) {
                        this.m_20256_(new Vec3(motion.f_82479_, (double)0.01f + Math.min((double)(0.05f * (float)distance), 0.7), motion.f_82481_));
                    }
                }
                if (!this.f_19861_ && !this.m_20069_() && !rider.m_6144_() && this.m_20184_().f_82480_ < 0.0 && this.canGlide() && this.useStamina(((Double)ChocoConfig.COMMON.glideStaminaCost.get()).floatValue())) {
                    motion = this.m_20184_();
                    this.m_20256_(new Vec3(motion.f_82479_, motion.f_82480_ * (double)0.65f, motion.f_82481_));
                }
                if (this.m_20142_() && !this.useStamina(((Double)ChocoConfig.COMMON.sprintStaminaCost.get()).floatValue()) || this.m_20142_() && this.m_20069_() && this.useStamina(((Double)ChocoConfig.COMMON.sprintStaminaCost.get()).floatValue()) || this.m_20142_() && !this.canSprint() && this.useStamina(((Double)ChocoConfig.COMMON.sprintStaminaCost.get()).floatValue())) {
                    this.m_6858_(false);
                }
                this.m_7910_((float)this.m_21051_(Attributes.f_22279_).m_22135_());
                super.m_7023_(newVector);
            }
        } else {
            super.m_7023_(newVector);
        }
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (passenger instanceof Mob && this.m_6688_() == passenger) {
            this.f_20883_ = ((LivingEntity)passenger).f_20883_;
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this || !(otherAnimal instanceof ChocoboEntity)) {
            return false;
        }
        ChocoboEntity otherChocobo = (ChocoboEntity)otherAnimal;
        if (!this.m_27593_() || !otherAnimal.m_27593_()) {
            return false;
        }
        return otherChocobo.isMale() != this.isMale();
    }

    public void m_6858_(boolean sprinting) {
        this.m_20115_(3, sprinting);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
        if (attributeInstance.m_22111_(CHOCOBO_SPRINTING_BOOST_ID) != null) {
            attributeInstance.m_22130_(CHOCOBO_SPRINTING_SPEED_BOOST);
        }
        if (sprinting && this.canSprint()) {
            attributeInstance.m_22118_(CHOCOBO_SPRINTING_SPEED_BOOST);
        }
    }

    public void dropFeather() {
        if (this.m_20193_().f_46443_) {
            return;
        }
        if (this.m_6162_()) {
            return;
        }
        this.m_5552_(new ItemStack((ItemLike)ModRegistry.CHOCOBO_FEATHER.get(), 1), 0.0f);
    }

    protected boolean m_7341_(Entity entityIn) {
        return !this.getSaddle().m_41619_() && super.m_7341_(entityIn);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.regenerateStamina();
        this.f_19793_ = 1.0f;
        this.f_19789_ = 0.0f;
        if (this.TimeSinceFeatherChance == 3000) {
            this.TimeSinceFeatherChance = 0;
            if ((double)((float)Math.random()) < 0.25) {
                this.dropFeather();
            }
        } else {
            ++this.TimeSinceFeatherChance;
        }
        if (!this.m_20193_().f_46443_) {
            if (this.f_19797_ % 60 == 0) {
                Entity controller;
                if (this.canDive()) {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 100, 0, true, false));
                    if (this.m_20160_() && (controller = this.m_6688_()) instanceof Player) {
                        ((Player)controller).m_7292_(new MobEffectInstance(MobEffects.f_19608_, 100, 0, true, false));
                    }
                }
                if (this.getChocoboColor() == ChocoboColor.FLAME) {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0, true, false));
                    if (this.m_20160_() && (controller = this.m_6688_()) instanceof Player) {
                        ((Player)controller).m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0, true, false));
                    }
                }
            }
        } else {
            this.destPos = (float)((double)this.destPos + (double)(this.f_19861_ ? -1 : 4) * 0.3);
            this.destPos = Mth.m_14036_((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.f_19861_) {
                this.wingRotDelta = Math.min(this.wingRotation, 1.0f);
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            this.wingRotation += this.wingRotDelta * 2.0f;
            if (this.f_19861_) {
                double d0;
                this.f_20923_ = this.f_20924_;
                double d1 = this.m_20185_() - this.f_19854_;
                float f4 = (float)Math.sqrt(d1 * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.f_20924_ += (f4 - this.f_20924_) * 0.4f;
                this.f_20925_ += this.f_20924_;
            } else {
                this.f_20925_ = 0.0f;
                this.f_20924_ = 0.0f;
                this.f_20923_ = 0.0f;
            }
        }
    }

    private void regenerateStamina() {
        if (!(this.f_19861_ || this.m_20069_() || this.m_20077_() || this.m_20142_())) {
            return;
        }
        float regen = ((Double)ChocoConfig.COMMON.staminaRegenRate.get()).floatValue();
        Vec3 motion = this.m_20184_();
        if (motion.f_82479_ != 0.0 || motion.f_82481_ != 0.0) {
            regen = (float)((double)regen * 0.85);
        }
        this.useStamina(-regen);
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        Optional<ChocoboColor> color;
        ItemStack heldItemStack = player.m_21120_(hand);
        if (heldItemStack.m_41720_() == ModRegistry.GYSAHL_CAKE.get()) {
            this.m_142075_(player, hand, heldItemStack);
            this.m_142669_();
            return InteractionResult.SUCCESS;
        }
        if (heldItemStack.m_41720_() == ModRegistry.CHOCOPEDIA.get()) {
            if (this.f_19853_.f_46443_) {
                ChocoboInfoScreen.openScreen(this, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && player.m_6144_() && !this.m_6162_()) {
            if (player instanceof ServerPlayer) {
                this.displayChocoboInventory((ServerPlayer)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_20193_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.isSaddled() && heldItemStack.m_41619_() && !player.m_6144_() && !this.m_6162_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_21824_() && heldItemStack.m_41720_() == ModRegistry.GYSAHL_GREEN_ITEM.get()) {
            this.m_142075_(player, hand, player.m_150109_().m_36056_());
            if ((float)Math.random() < ((Double)ChocoConfig.COMMON.tameChance.get()).floatValue()) {
                this.m_21816_(player.m_142081_());
                this.m_7105_(true);
                player.m_5661_((Component)new TranslatableComponent("chococraft.entity_chocobo.tame_success"), true);
            } else {
                player.m_5661_((Component)new TranslatableComponent("chococraft.entity_chocobo.tame_fail"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && heldItemStack.m_41720_() == ModRegistry.GYSAHL_GREEN_ITEM.get()) {
            if (this.m_21223_() != this.m_21233_()) {
                this.m_142075_(player, hand, player.m_150109_().m_36056_());
                this.m_5634_(5.0f);
            } else {
                player.m_5661_((Component)new TranslatableComponent("chococraft.entity_chocobo.heal_fail"), true);
            }
        }
        if (this.m_21824_() && heldItemStack.m_41720_() == ModRegistry.CHOCOBO_WHISTLE.get() && !this.m_6162_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (this.followingmrhuman == 3.0f) {
                    this.m_5496_((SoundEvent)ModSounds.WHISTLE_SOUND_FOLLOW.get(), 1.0f, 1.0f);
                    this.m_21557_(false);
                    this.f_21345_.m_25352_(0, (Goal)this.follow);
                    this.followingmrhuman = 1.0f;
                    player.m_5661_((Component)new TranslatableComponent("chococraft.entity_chocobo.chocobo_followcmd"), true);
                } else if (this.followingmrhuman == 1.0f) {
                    this.m_5496_((SoundEvent)ModSounds.WHISTLE_SOUND_WANDER.get(), 1.0f, 1.0f);
                    this.f_21345_.m_25363_((Goal)this.follow);
                    this.followingmrhuman = 2.0f;
                    player.m_5661_((Component)new TranslatableComponent("chococraft.entity_chocobo.chocobo_wandercmd"), true);
                } else if (this.followingmrhuman == 2.0f) {
                    this.m_5496_((SoundEvent)ModSounds.WHISTLE_SOUND_STAY.get(), 1.0f, 1.0f);
                    this.m_21557_(true);
                    this.followingmrhuman = 3.0f;
                    player.m_5661_((Component)new TranslatableComponent("chococraft.entity_chocobo.chocobo_staycmd"), true);
                }
            } else {
                player.m_5661_((Component)new TranslatableComponent("chococraft.entity_chocobo.not_owner"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && !this.m_27593_() && heldItemStack.m_41720_() == ModRegistry.LOVELY_GYSAHL_GREEN.get() && !this.m_6162_()) {
            this.m_142075_(player, hand, player.m_150109_().m_36056_());
            this.m_27595_(player);
            return InteractionResult.SUCCESS;
        }
        if (heldItemStack.m_41720_() instanceof ChocoboSaddleItem && this.m_21824_() && !this.isSaddled() && !this.m_6162_()) {
            this.saddleItemStackHandler.setStackInSlot(0, heldItemStack.m_41777_().m_41620_(1));
            this.setSaddleType(heldItemStack);
            this.m_142075_(player, hand, heldItemStack);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && !heldItemStack.m_41619_() && (color = ChocoboColor.getColorForItemstack(heldItemStack)).isPresent()) {
            if (this.m_21830_((LivingEntity)player)) {
                this.m_142075_(player, hand, heldItemStack);
                this.setChocoboColor(color.get());
            } else {
                player.m_5661_((Component)new TranslatableComponent("chococraft.entity_chocobo.not_owner"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && heldItemStack.m_41720_() == Items.f_42656_ && !this.m_21830_((LivingEntity)player)) {
            player.m_5661_((Component)new TranslatableComponent("chococraft.entity_chocobo.not_owner"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec, hand);
    }

    private void displayChocoboInventory(ServerPlayer player) {
        if (player.f_36096_ != player.f_36095_) {
            player.m_6915_();
        }
        player.m_9217_();
        PacketManager.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenChocoboGuiMessage(this, player.f_8940_));
        player.f_36096_ = new SaddleBagContainer(player.f_8940_, player.m_150109_(), this);
        player.m_143399_(player.f_36096_);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
    }

    private void reconfigureInventory(ItemStack oldSaddle, ItemStack newSaddle) {
        if (!this.m_20193_().f_46443_) {
            for (int i = 0; i < this.chocoboInventory.getSlots(); ++i) {
                if (!this.m_6084_()) continue;
                ItemStack stack = this.chocoboInventory.extractItem(i, Integer.MAX_VALUE, false);
                Containers.m_18992_((Level)this.m_20193_(), (double)this.m_20185_(), (double)(this.m_20186_() + 0.5), (double)this.m_20189_(), (ItemStack)stack);
            }
        }
        this.chocoboInventory.setSize(this.getSaddleCount(newSaddle));
        for (Player player : this.f_19853_.m_6907_()) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (!(abstractContainerMenu instanceof SaddleBagContainer)) continue;
            SaddleBagContainer bagContainer = (SaddleBagContainer)abstractContainerMenu;
            bagContainer.refreshSlots(bagContainer.getChocobo(), player.m_150109_());
        }
    }

    protected void m_7625_(DamageSource damageSourceIn, boolean attackedRecently) {
        super.m_7625_(damageSourceIn, attackedRecently);
        if (this.chocoboInventory != null && this.isSaddled()) {
            for (int i = 0; i < this.chocoboInventory.getSlots(); ++i) {
                if (this.chocoboInventory.getStackInSlot(i).m_41619_()) continue;
                this.m_5552_(this.chocoboInventory.getStackInSlot(i), 0.0f);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.AMBIENT_SOUND.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.AMBIENT_SOUND.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.AMBIENT_SOUND.get();
    }

    protected float m_6121_() {
        return 0.6f;
    }

    public int m_8100_() {
        return 24 * (int)(Math.random() * 100.0);
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER).contains(this.f_19853_.m_46857_(new BlockPos((Vec3i)this.m_142538_()).m_7495_()))) {
            return true;
        }
        return super.m_5545_(worldIn, spawnReasonIn);
    }

    protected void m_5849_() {
        super.m_5849_();
        if (this.chocoboAvoidPlayerGoal == null) {
            this.chocoboAvoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, livingEntity -> {
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    int chance = 0;
                    for (ItemStack stack : player.m_150109_().f_35975_) {
                        if (stack == null || !(stack.m_41720_() instanceof ChocoDisguiseItem)) continue;
                        chance += 25;
                    }
                    return !RandomHelper.getChanceResult(chance);
                }
                return false;
            }, 10.0f, 1.0, 1.2, EntitySelector.f_20406_);
        }
        if (this.m_21824_()) {
            this.f_21345_.m_25363_((Goal)this.chocoboAvoidPlayerGoal);
        } else {
            this.f_21345_.m_25352_(5, (Goal)this.chocoboAvoidPlayerGoal);
        }
    }
}

