/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.blockentities;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.chococraft.common.ChocoConfig;
import net.chococraft.common.blocks.ChocoboEggBlock;
import net.chococraft.common.blocks.StrawNestBlock;
import net.chococraft.common.entities.ChocoboEntity;
import net.chococraft.common.entities.breeding.BreedingHelper;
import net.chococraft.common.entities.breeding.ChocoboBreedInfo;
import net.chococraft.common.init.ModRegistry;
import net.chococraft.common.inventory.NestContainer;
import net.chococraft.common.items.ChocoboEggBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ChocoboNestBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final CheckOffset[] SHELTER_CHECK_OFFSETS = new CheckOffset[]{new CheckOffset(new Vec3i(0, 1, 0), true), new CheckOffset(new Vec3i(0, 2, 0), true), new CheckOffset(new Vec3i(-1, 3, -1), false), new CheckOffset(new Vec3i(-1, 3, 0), false), new CheckOffset(new Vec3i(-1, 3, 1), false), new CheckOffset(new Vec3i(0, 3, -1), false), new CheckOffset(new Vec3i(0, 3, 0), false), new CheckOffset(new Vec3i(0, 3, 1), false), new CheckOffset(new Vec3i(1, 3, -1), false), new CheckOffset(new Vec3i(1, 3, 0), false), new CheckOffset(new Vec3i(1, 3, 1), false)};
    public static final String NBTKEY_IS_SHELTERED = "IsSheltered";
    public static final String NBTKEY_TICKS = "Ticks";
    public static final String NBTKEY_NEST_INVENTORY = "Inventory";
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41720_() instanceof ChocoboEggBlockItem;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            ChocoboNestBlockEntity.this.onInventoryChanged();
        }
    };
    private LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);
    private boolean isSheltered;
    private int ticks = 0;

    public ChocoboNestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.STRAW_NEST_TILE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ChocoboNestBlockEntity nestBlockEntity) {
        ++nestBlockEntity.ticks;
        if (nestBlockEntity.ticks > 1000000) {
            nestBlockEntity.ticks = 0;
        }
        boolean changed = false;
        if (nestBlockEntity.ticks % 5 == 0 && !nestBlockEntity.getEggItemStack().m_41619_()) {
            changed = nestBlockEntity.updateEgg();
        }
        if (nestBlockEntity.ticks % 200 == 100) {
            changed |= nestBlockEntity.updateSheltered();
        }
        if (changed) {
            nestBlockEntity.f_58857_.m_46597_(pos, state);
        }
    }

    private boolean updateEgg() {
        ItemStack egg = this.getEggItemStack();
        if (!ChocoboEggBlock.isChocoboEgg(egg)) {
            return false;
        }
        if (!egg.m_41782_()) {
            return false;
        }
        CompoundTag nbt = egg.m_41698_("HatchingState");
        int time = nbt.m_128451_("Time");
        nbt.m_128405_("Time", time += this.isSheltered ? 2 : 1);
        if (time < (Integer)ChocoConfig.COMMON.eggHatchTimeTicks.get()) {
            return false;
        }
        ChocoboBreedInfo breedInfo = ChocoboBreedInfo.getFromNbtOrDefault(egg.m_41737_("BreedInfo"));
        ChocoboEntity baby = BreedingHelper.createChild(breedInfo, this.f_58857_);
        if (baby == null) {
            return false;
        }
        baby.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.2, (double)this.f_58858_.m_123343_() + 0.5, 0.0f, 0.0f);
        this.f_58857_.m_7967_((Entity)baby);
        Random random = baby.m_21187_();
        for (int i = 0; i < 7; ++i) {
            double d0 = random.nextGaussian() * 0.02;
            double d1 = random.nextGaussian() * 0.02;
            double d2 = random.nextGaussian() * 0.02;
            double d3 = random.nextDouble() * (double)baby.m_20205_() * 2.0 - (double)baby.m_20205_();
            double d4 = 0.5 + random.nextDouble() * (double)baby.m_20206_();
            double d5 = random.nextDouble() * (double)baby.m_20205_() * 2.0 - (double)baby.m_20205_();
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, baby.m_20185_() + d3, baby.m_20186_() + d4, baby.m_20189_() + d5, d0, d1, d2);
        }
        this.setEggItemStack(ItemStack.f_41583_);
        return true;
    }

    private boolean updateSheltered() {
        boolean sheltered = this.isSheltered();
        if (this.isSheltered != sheltered) {
            this.isSheltered = sheltered;
            return true;
        }
        return false;
    }

    public ItemStack getEggItemStack() {
        return this.inventory.getStackInSlot(0);
    }

    public void setEggItemStack(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        } else if (ChocoboEggBlock.isChocoboEgg(itemStack)) {
            this.inventory.setStackInSlot(0, itemStack);
            if (itemStack.m_41782_()) {
                CompoundTag nbt = itemStack.m_41698_("HatchingState");
                int time = nbt.m_128451_("Time");
                nbt.m_128405_("Time", time);
            }
        }
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isSheltered = nbt.m_128471_(NBTKEY_IS_SHELTERED);
        this.ticks = nbt.m_128451_(NBTKEY_TICKS);
        this.inventory.deserializeNBT(nbt.m_128469_(NBTKEY_NEST_INVENTORY));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_(NBTKEY_IS_SHELTERED, this.isSheltered);
        nbt.m_128405_(NBTKEY_TICKS, this.ticks);
        nbt.m_128365_(NBTKEY_NEST_INVENTORY, (Tag)this.inventory.serializeNBT());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.inventory.deserializeNBT(pkt.m_131708_().m_128469_(NBTKEY_NEST_INVENTORY));
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new NestContainer(id, playerInventory, this);
    }

    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent("chococraft.container.nest");
    }

    public void onInventoryChanged() {
        this.m_6596_();
        BlockState newState = (BlockState)((Block)ModRegistry.STRAW_NEST.get()).m_49966_().m_61124_((Property)StrawNestBlock.HAS_EGG, (Comparable)Boolean.valueOf(!this.getEggItemStack().m_41619_()));
        this.m_58904_().m_46597_(this.m_58899_(), newState);
    }

    public boolean isSheltered() {
        boolean sheltered = true;
        for (CheckOffset checkOffset : SHELTER_CHECK_OFFSETS) {
            if (this.f_58857_.m_46859_(this.m_58899_().m_141952_(checkOffset.offset)) == checkOffset.shouldBeAir) continue;
            sheltered = false;
            break;
        }
        return sheltered;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHolder.invalidate();
    }

    private static class CheckOffset {
        Vec3i offset;
        boolean shouldBeAir;

        CheckOffset(Vec3i offset, boolean shouldBeAir) {
            this.offset = offset;
            this.shouldBeAir = shouldBeAir;
        }
    }
}

