/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common;

import net.chococraft.Chococraft;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ChocoConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Chococraft.log.debug("Loaded Chococraft's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Chococraft.log.debug("Chococraft's config just got changed on the file system!");
        if (configEvent.getConfig().getModId() == "chococraft") {
            if ((Integer)ChocoConfig.COMMON.chocoboPackSizeMin.get() > (Integer)ChocoConfig.COMMON.chocoboPackSizeMax.get()) {
                int t = (Integer)ChocoConfig.COMMON.chocoboPackSizeMax.get();
                ChocoConfig.COMMON.chocoboPackSizeMax.set((Object)((Integer)ChocoConfig.COMMON.chocoboPackSizeMin.get()));
                ChocoConfig.COMMON.chocoboPackSizeMin.set((Object)t);
            }
            configEvent.getConfig().save();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue addAbilityFruitsToDungeonLoot;
        public final ForgeConfigSpec.IntValue abilityFruitDungeonLootWeight;
        public final ForgeConfigSpec.IntValue gysahlGreenSpawnWeight;
        public final ForgeConfigSpec.IntValue gysahlGreenPatchSize;
        public final ForgeConfigSpec.DoubleValue gysahlGreenSpawnChance;
        public final ForgeConfigSpec.BooleanValue gysahlGreensSpawnOnlyInOverworld;
        public final ForgeConfigSpec.IntValue chocoboSpawnWeight;
        public final ForgeConfigSpec.IntValue chocoboPackSizeMin;
        public final ForgeConfigSpec.IntValue chocoboPackSizeMax;
        public final ForgeConfigSpec.DoubleValue tameChance;
        public final ForgeConfigSpec.DoubleValue sprintStaminaCost;
        public final ForgeConfigSpec.DoubleValue glideStaminaCost;
        public final ForgeConfigSpec.DoubleValue flyStaminaCost;
        public final ForgeConfigSpec.DoubleValue jumpStaminaCost;
        public final ForgeConfigSpec.DoubleValue staminaRegenRate;
        public final ForgeConfigSpec.IntValue defaultStamina;
        public final ForgeConfigSpec.IntValue defaultSpeed;
        public final ForgeConfigSpec.IntValue defaultHealth;
        public final ForgeConfigSpec.IntValue ExpCostSprint;
        public final ForgeConfigSpec.IntValue ExpCostGlide;
        public final ForgeConfigSpec.IntValue ExpCostDive;
        public final ForgeConfigSpec.IntValue ExpCostFly;
        public final ForgeConfigSpec.IntValue maxHealth;
        public final ForgeConfigSpec.IntValue maxSpeed;
        public final ForgeConfigSpec.DoubleValue maxStamina;
        public final ForgeConfigSpec.DoubleValue posgainHealth;
        public final ForgeConfigSpec.DoubleValue posgainSpeed;
        public final ForgeConfigSpec.DoubleValue posgainStamina;
        public final ForgeConfigSpec.DoubleValue poslossHealth;
        public final ForgeConfigSpec.DoubleValue poslossSpeed;
        public final ForgeConfigSpec.DoubleValue poslossStamina;
        public final ForgeConfigSpec.IntValue eggHatchTimeTicks;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("World generation related configuration").push("World");
            builder.comment("Ability Fruit").push("ability_fruit");
            this.addAbilityFruitsToDungeonLoot = builder.worldRestart().comment("Add ability fruit to dungeon loot [Default: true]").define("addAbilityFruitsToDungeonLoot", true);
            this.abilityFruitDungeonLootWeight = builder.worldRestart().comment("This number controls the weight ability fruit has compared to other items in a loot table. [Default: 1]").defineInRange("abilityFruitDungeonLootWeight", 1, 0, Integer.MAX_VALUE);
            builder.pop();
            this.gysahlGreenSpawnWeight = builder.worldRestart().comment("Controls the weight compared to other world gen [Default: 3]").defineInRange("gysahlGreenSpawnWeight", 3, 0, Integer.MAX_VALUE);
            this.gysahlGreenPatchSize = builder.worldRestart().comment("Controls the Patch Size compared to other world gen [Default: 64]").defineInRange("gysahlGreenPatchSize", 64, 0, Integer.MAX_VALUE);
            this.gysahlGreenSpawnChance = builder.worldRestart().comment("Controls the Spawn Chance compared to other world gen [Default: 0.1]").defineInRange("gysahlGreenSpawnChance", 0.1, 0.0, 1.0);
            this.gysahlGreensSpawnOnlyInOverworld = builder.worldRestart().comment("Controls the weight compared to other world gen [Default: true]").define("gysahlGreensSpawnOnlyInOverworld", true);
            builder.pop();
            builder.comment("Spawning configuration").push("spawning");
            this.chocoboSpawnWeight = builder.comment("Controls Chocobo Spawn Weight [Default: 10]").defineInRange("chocoboSpawnWeight", 10, 0, Integer.MAX_VALUE);
            this.chocoboPackSizeMin = builder.comment("Controls Chocobo Pack Size Min [Default: 1]").defineInRange("chocoboPackSizeMin", 1, 0, Integer.MAX_VALUE);
            this.chocoboPackSizeMax = builder.comment("Controls Chocobo Pack Size Max [Default: 3]").defineInRange("chocoboPackSizeMax", 3, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Chocobo configuration").push("Chocobo");
            this.tameChance = builder.comment("This multiplier controls the tame chance per gysahl used, so .15 results in 15% chance to tame [Default: 0.15]").defineInRange("tameChance", 0.15, 0.0, 1.0);
            builder.comment("Stamina Costs").push("stamina_costs");
            this.sprintStaminaCost = builder.comment("Controls the Sprint Stamina cost [Default: 0.06]").defineInRange("sprintStaminaCost", 0.06, 0.0, 1.0);
            this.glideStaminaCost = builder.comment("Controls the Glide Stamina cost [Default: 0.005]").defineInRange("glideStaminaCost", 0.005, 0.0, 1.0);
            this.flyStaminaCost = builder.comment("Controls the Fly Stamina cost [Default: 0.08]").defineInRange("flyStaminaCost", 0.08, 0.0, 1.0);
            this.jumpStaminaCost = builder.comment("Controls the Jump Stamina cost [Default: 0.00]").defineInRange("jumpStaminaCost", 0.0, 0.0, 1.0);
            this.staminaRegenRate = builder.comment("Controls the amount of Stamina recharged per tick [Default: 0.025]").defineInRange("staminaRegenRate", 0.025, 0.0, 1.0);
            builder.pop();
            builder.comment("Defaults").push("defaults");
            this.defaultStamina = builder.comment("Controls the default Stamina [Default: 10]").defineInRange("defaultStamina", 10, 0, Integer.MAX_VALUE);
            this.defaultSpeed = builder.comment("Controls the default Speed [Default: 20]").defineInRange("defaultSpeed", 20, 0, Integer.MAX_VALUE);
            this.defaultHealth = builder.comment("Controls the default Health [Default: 20]").defineInRange("defaultHealth", 20, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Experience Costs").push("xp_costs");
            this.ExpCostSprint = builder.comment("Controls the experience required to unlock the Sprint Ability [Default: 1500]").defineInRange("ExpCostSprint", 1500, 1, Integer.MAX_VALUE);
            this.ExpCostGlide = builder.comment("Controls the experience required to unlock the Glide Ability [Default: 1500]").defineInRange("ExpCostGlide", 1500, 1, Integer.MAX_VALUE);
            this.ExpCostDive = builder.comment("Controls the experience required to unlock the Dive Ability [Default: 1000]").defineInRange("ExpCostDive", 1000, 1, Integer.MAX_VALUE);
            this.ExpCostFly = builder.comment("Controls the experience required to unlock the Fly Ability [Default: 2000]").defineInRange("ExpCostFly", 2000, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.comment("Breeding configuration").push("breeding");
            builder.comment("Max Stats").push("Max");
            this.maxHealth = builder.comment("Controls the Max Health a Chocobo can have [Default: 50]").defineInRange("maxHealth", 50, 0, Integer.MAX_VALUE);
            this.maxSpeed = builder.comment("Controls the Max Speed a Chocobo can have [Default: 40]").defineInRange("maxSpeed", 40, 0, Integer.MAX_VALUE);
            this.maxStamina = builder.comment("Controls the Max Stamina a Chocobo can have [Default: 25]").defineInRange("maxStamina", 25.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Gain Stats").push("gain_stats");
            this.posgainHealth = builder.comment("Controls the multiplier the Health stat gains (for example 0.05 would result in a max gain of 5% so 20 to 21) [Default: .1]").defineInRange("posgainHealth", 0.1, 0.0, 2.147483647E9);
            this.posgainSpeed = builder.comment("Controls the multiplier the Speed stat gains (for example 0.05 would result in a max gain of 5% so 20 to 21) [Default: .1]").defineInRange("posgainSpeed", 0.1, 0.0, 2.147483647E9);
            this.posgainStamina = builder.comment("Controls the multiplier the Stamina stat gains (for example 0.05 would result in a max gain of 5% so 20 to 21) [Default: .1]").defineInRange("posgainStamina", 0.1, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Loss Stats").push("loss_stats");
            this.poslossHealth = builder.comment("Controls the multiplier the Health stat loss (for example 0.95 would result in a max loss of 5% so 20 to 19) [Default: .95]").defineInRange("poslossHealth", 0.95, 0.0, 2.147483647E9);
            this.poslossSpeed = builder.comment("Controls the multiplier the Speed stat gains (for example 0.95 would result in a max loss of 5% so 20 to 19) [Default: .95]").defineInRange("poslossSpeed", 0.95, 0.0, 2.147483647E9);
            this.poslossStamina = builder.comment("Controls the multiplier the Stamina stat gains (for example 0.95 would result in a max loss of 5% so 20 to 19) [Default: .95]").defineInRange("poslossStamina", 0.95, 0.0, 2.147483647E9);
            builder.pop();
            this.eggHatchTimeTicks = builder.comment("Controls the amount of ticks / time till an egg hatches. This value isn't super accurate [Default: 10000]").defineInRange("eggHatchTimeTicks", 10000, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

