/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.chococraft.client.gui.TexturedButton;
import net.chococraft.common.ChocoConfig;
import net.chococraft.common.entities.ChocoboEntity;
import net.chococraft.common.handler.ExperienceHandler;
import net.chococraft.common.init.ModAttributes;
import net.chococraft.common.network.PacketManager;
import net.chococraft.common.network.packets.UpgradeChocoboMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class ChocoboInfoScreen
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("chococraft", "textures/gui/chocobo_stats.png");
    private final ChocoboEntity chocobo;
    private final Player player;
    private int xSize = 176;
    private int ySize = 89;
    private int guiLeft;
    private int guiTop;
    private TexturedButton[] abilityButton = new TexturedButton[4];

    public ChocoboInfoScreen(ChocoboEntity chocobo, Player player) {
        super((Component)new TranslatableComponent("IF YOU SEE THIS, YELL AT BYSCO"));
        this.chocobo = chocobo;
        this.player = player;
    }

    public static void openScreen(ChocoboEntity chocobo, Player player) {
        Minecraft.m_91087_().m_91152_((Screen)new ChocoboInfoScreen(chocobo, player));
    }

    public void m_7856_() {
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.abilityButton[0] = (TexturedButton)this.m_142416_((GuiEventListener)new TexturedButton(25, 52, 18, 18, 0, 107, 0, TEXTURE, 256, 256, button -> {
            UpgradeChocoboMessage packet = new UpgradeChocoboMessage(this.chocobo, 1);
            PacketManager.CHANNEL.sendToServer((Object)packet);
        }, (button, poseStack, mouseX, mouseY) -> {
            boolean flag = this.chocobo.canSprint();
            String abilityText = I18n.m_118938_((String)this.getAbilityFromButton(0), (Object[])new Object[0]);
            int centerX = this.f_96543_ / 2;
            String tooltip = flag ? I18n.m_118938_((String)"gui.chocoinfo.button.already_unlocked_ability", (Object[])new Object[]{abilityText}) : I18n.m_118938_((String)"gui.chocoinfo.button.ability", (Object[])new Object[]{ExperienceHandler.getExperience(this.player), this.getAbilityXPCost(0), abilityText});
            int width = this.f_96547_.m_92895_(tooltip);
            this.f_96547_.m_92883_(poseStack, tooltip, (float)(90 - centerX), 93.0f, -1);
            ArrayList<TranslatableComponent> text = new ArrayList<TranslatableComponent>();
            text.add(new TranslatableComponent("gui.chocoinfo.button.button_format", new Object[]{new TranslatableComponent(this.getAbilityFromButton(0))}));
            this.m_96597_(poseStack, text, mouseX, mouseY);
        }, (Component)new TextComponent("Sprint")));
        this.abilityButton[1] = (TexturedButton)this.m_142416_((GuiEventListener)new TexturedButton(61, 52, 18, 18, 18, 107, 0, TEXTURE, 256, 256, button -> {
            UpgradeChocoboMessage packet = new UpgradeChocoboMessage(this.chocobo, 2);
            PacketManager.CHANNEL.sendToServer((Object)packet);
        }, (button, poseStack, mouseX, mouseY) -> {
            boolean flag = this.chocobo.canGlide();
            String abilityText = I18n.m_118938_((String)this.getAbilityFromButton(1), (Object[])new Object[0]);
            int centerX = this.f_96543_ / 2;
            String tooltip = flag ? I18n.m_118938_((String)"gui.chocoinfo.button.already_unlocked_ability", (Object[])new Object[]{abilityText}) : I18n.m_118938_((String)"gui.chocoinfo.button.ability", (Object[])new Object[]{ExperienceHandler.getExperience(this.player), this.getAbilityXPCost(1), abilityText});
            int width = this.f_96547_.m_92895_(tooltip);
            this.f_96547_.m_92883_(poseStack, tooltip, (float)(90 - centerX), 93.0f, -1);
            ArrayList<TranslatableComponent> text = new ArrayList<TranslatableComponent>();
            text.add(new TranslatableComponent("gui.chocoinfo.button.button_format", new Object[]{new TranslatableComponent(this.getAbilityFromButton(1))}));
            this.m_96597_(poseStack, text, mouseX, mouseY);
        }, (Component)new TextComponent("Glide")));
        this.abilityButton[2] = (TexturedButton)this.m_142416_((GuiEventListener)new TexturedButton(97, 52, 18, 18, 36, 107, 0, TEXTURE, 256, 256, button -> {
            UpgradeChocoboMessage packet = new UpgradeChocoboMessage(this.chocobo, 3);
            PacketManager.CHANNEL.sendToServer((Object)packet);
        }, (button, poseStack, mouseX, mouseY) -> {
            boolean flag = this.chocobo.canDive();
            String abilityText = I18n.m_118938_((String)this.getAbilityFromButton(2), (Object[])new Object[0]);
            int centerX = this.f_96543_ / 2;
            String tooltip = flag ? I18n.m_118938_((String)"gui.chocoinfo.button.already_unlocked_ability", (Object[])new Object[]{abilityText}) : I18n.m_118938_((String)"gui.chocoinfo.button.ability", (Object[])new Object[]{ExperienceHandler.getExperience(this.player), this.getAbilityXPCost(2), abilityText});
            int width = this.f_96547_.m_92895_(tooltip);
            this.f_96547_.m_92883_(poseStack, tooltip, (float)(90 - centerX), 93.0f, -1);
            ArrayList<TranslatableComponent> text = new ArrayList<TranslatableComponent>();
            text.add(new TranslatableComponent("gui.chocoinfo.button.button_format", new Object[]{new TranslatableComponent(this.getAbilityFromButton(2))}));
            this.m_96597_(poseStack, text, mouseX, mouseY);
        }, (Component)new TextComponent("Dive")));
        this.abilityButton[3] = (TexturedButton)this.m_142416_((GuiEventListener)new TexturedButton(133, 52, 18, 18, 54, 107, 0, TEXTURE, 256, 256, button -> {
            UpgradeChocoboMessage packet = new UpgradeChocoboMessage(this.chocobo, 4);
            PacketManager.CHANNEL.sendToServer((Object)packet);
        }, (button, poseStack, mouseX, mouseY) -> {
            boolean flag = this.chocobo.canFly();
            String abilityText = I18n.m_118938_((String)this.getAbilityFromButton(3), (Object[])new Object[0]);
            int centerX = this.f_96543_ / 2;
            String tooltip = flag ? I18n.m_118938_((String)"gui.chocoinfo.button.already_unlocked_ability", (Object[])new Object[]{abilityText}) : I18n.m_118938_((String)"gui.chocoinfo.button.ability", (Object[])new Object[]{ExperienceHandler.getExperience(this.player), this.getAbilityXPCost(3), abilityText});
            int width = this.f_96547_.m_92895_(tooltip);
            this.f_96547_.m_92883_(poseStack, tooltip, (float)(90 - centerX), 93.0f, -1);
            ArrayList<TranslatableComponent> text = new ArrayList<TranslatableComponent>();
            text.add(new TranslatableComponent("gui.chocoinfo.button.button_format", new Object[]{new TranslatableComponent(this.getAbilityFromButton(3))}));
            this.m_96597_(poseStack, text, mouseX, mouseY);
        }, (Component)new TextComponent("Fly")));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        mouseX -= this.guiLeft;
        mouseY -= this.guiTop;
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.guiLeft, (double)this.guiTop, 0.0);
        this.m_93228_(matrixStack, 0, 0, 0, 0, this.xSize, this.ySize);
        String name = this.chocobo.m_5446_().getString();
        int nameLength = this.f_96547_.m_92895_(name);
        this.f_96547_.m_92750_(matrixStack, name, (float)(this.xSize / 2 - nameLength / 2), 4.0f, -1);
        String ownerText = I18n.m_118938_((String)"gui.chocoinfo.text.not_tamed", (Object[])new Object[0]);
        if (this.chocobo.m_21824_()) {
            LivingEntity owner = this.chocobo.m_142480_();
            ownerText = owner == null ? I18n.m_118938_((String)"gui.chocoinfo.text.unknown_owner", (Object[])new Object[0]) : I18n.m_118938_((String)"gui.chocoinfo.text.owner_format", (Object[])new Object[]{owner.m_5446_().getString()});
        }
        int ownerTextLength = this.f_96547_.m_92895_(ownerText);
        this.f_96547_.m_92750_(matrixStack, ownerText, (float)(this.xSize / 2 - ownerTextLength / 2), 74.0f, -1);
        this.drawGenderInfo(matrixStack);
        this.drawHealthInfo(matrixStack);
        this.drawSpeedInfo(matrixStack);
        this.drawStaminaInfo(matrixStack);
        this.updateButtonTextures();
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.drawHover(matrixStack, mouseX, mouseY);
        matrixStack.m_85849_();
    }

    private void updateButtonTextures() {
        for (int i = 0; i < this.abilityButton.length; ++i) {
            this.abilityButton[i].setTexture(TEXTURE, i * 18 - 1, this.canUseAbility(i) ? 89 : 107, 256, 256);
        }
    }

    public void m_96624_() {
        for (int i = 0; i < this.abilityButton.length; ++i) {
            this.abilityButton[0].f_93623_ = this.getAbilityXPCost(i) <= ExperienceHandler.getExperience(this.player) && !this.canUseAbility(i);
        }
    }

    private void drawGenderInfo(PoseStack matrixStack) {
        this.m_93228_(matrixStack, 26, 18, 176, this.chocobo.isMale() ? 16 : 0, 16, 16);
        String value = I18n.m_118938_((String)(this.chocobo.isMale() ? "gui.chocoinfo.texture.male" : "gui.chocoinfo.texture.female"), (Object[])new Object[0]);
        int width = this.f_96547_.m_92895_(value);
        this.f_96547_.m_92750_(matrixStack, value, (float)(35 - width / 2), 36.0f, -1);
    }

    private void drawHealthInfo(PoseStack matrixStack) {
        String value = String.valueOf((int)this.chocobo.m_21051_(Attributes.f_22276_).m_22115_());
        int width = this.f_96547_.m_92895_(value);
        this.f_96547_.m_92750_(matrixStack, value, (float)(70 - width / 2), 36.0f, -1);
    }

    private void drawSpeedInfo(PoseStack matrixStack) {
        String value = String.valueOf((int)Math.round(this.chocobo.m_21051_(Attributes.f_22279_).m_22115_() * 100.0));
        int width = this.f_96547_.m_92895_(value);
        this.f_96547_.m_92750_(matrixStack, value, (float)(106 - width / 2), 36.0f, -1);
    }

    private void drawStaminaInfo(PoseStack matrixStack) {
        String value = String.valueOf((int)this.chocobo.m_21051_((Attribute)ModAttributes.MAX_STAMINA.get()).m_22115_());
        int width = this.f_96547_.m_92895_(value);
        this.f_96547_.m_92750_(matrixStack, value, (float)(142 - width / 2), 36.0f, -1);
    }

    private void drawHover(PoseStack poseStack, int mouseX, int mouseY) {
        ArrayList<TranslatableComponent> text;
        if (mouseX >= 25 && mouseY >= 17 && mouseX < 43 && mouseY < 35) {
            text = new ArrayList<TranslatableComponent>();
            text.add(new TranslatableComponent("gui.chocoinfo.texture.gender"));
            this.m_96597_(poseStack, text, mouseX, mouseY);
        }
        if (mouseX >= 61 && mouseY >= 17 && mouseX < 79 && mouseY < 35) {
            text = new ArrayList();
            text.add(new TranslatableComponent("gui.chocoinfo.texture.health"));
            this.m_96597_(poseStack, text, mouseX, mouseY);
        }
        if (mouseX >= 97 && mouseY >= 17 && mouseX < 115 && mouseY < 35) {
            text = new ArrayList();
            text.add(new TranslatableComponent("gui.chocoinfo.texture.speed"));
            this.m_96597_(poseStack, text, mouseX, mouseY);
        }
        if (mouseX >= 133 && mouseY >= 17 && mouseX < 151 && mouseY < 35) {
            text = new ArrayList();
            text.add(new TranslatableComponent("gui.chocoinfo.texture.stamina"));
            this.m_96597_(poseStack, text, mouseX, mouseY);
        }
    }

    private boolean canUseAbility(int i) {
        return switch (i) {
            case 0 -> this.chocobo.canSprint();
            case 1 -> this.chocobo.canGlide();
            case 2 -> this.chocobo.canDive();
            case 3 -> this.chocobo.canFly();
            default -> false;
        };
    }

    private String getAbilityFromButton(int i) {
        String key = "gui.chocoinfo.button.";
        return switch (i) {
            case 0 -> key + "sprint";
            case 1 -> key + "glide";
            case 2 -> key + "dive";
            case 3 -> key + "fly";
            default -> key;
        };
    }

    private int getAbilityXPCost(int i) {
        return switch (i) {
            case 0 -> (Integer)ChocoConfig.COMMON.ExpCostSprint.get();
            case 1 -> (Integer)ChocoConfig.COMMON.ExpCostGlide.get();
            case 2 -> (Integer)ChocoConfig.COMMON.ExpCostDive.get();
            case 3 -> (Integer)ChocoConfig.COMMON.ExpCostFly.get();
            default -> 0;
        };
    }
}

