/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SaveStructuresCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"savestructures").requires(source -> source.m_6761_(2));
        command.then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> SaveStructuresCommand.saveStructures((CommandContext<CommandSourceStack>)context, BoundingBox.m_162375_((Vec3i)BlockPosArgument.m_118242_((CommandContext)context, (String)"from"), (Vec3i)BlockPosArgument.m_118242_((CommandContext)context, (String)"to"))))));
        return command;
    }

    private static int saveStructures(CommandContext<CommandSourceStack> context, BoundingBox area) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        ArrayList<String> savedStructures = new ArrayList<String>();
        HashMap<BlockPos, String> duplicates = new HashMap<BlockPos, String>();
        for (BlockPos pos2 : BlockPos.m_121976_((int)area.m_162395_(), (int)area.m_162396_(), (int)area.m_162398_(), (int)area.m_162399_(), (int)area.m_162400_(), (int)area.m_162401_())) {
            StructureBlockEntity tile;
            if (!(level.m_7702_(pos2) instanceof StructureBlockEntity) || !(tile = (StructureBlockEntity)level.m_7702_(pos2)).m_59901_() || !tile.m_59830_()) continue;
            if (savedStructures.contains(tile.m_59895_())) {
                duplicates.put(new BlockPos((Vec3i)pos2), tile.m_59895_());
            }
            savedStructures.add(tile.m_59895_());
        }
        if (savedStructures.size() > 0) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[Saved " + savedStructures.size() + " Structures]").m_130940_(ChatFormatting.GREEN), true);
            if (savedStructures.size() <= 50) {
                savedStructures.stream().sorted().forEach(structure -> ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(" - " + structure), true));
            } else {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(" - Too many structures to print. Check the console."), true);
                StructureGelMod.log("Saved structures:", new Object[0]);
                savedStructures.stream().sorted().forEach(x$0 -> StructureGelMod.log(x$0, new Object[0]));
            }
            if (duplicates.size() > 0) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Warning: Found " + duplicates.size() + " structures with a duplicate name. Click to teleport.").m_130940_(ChatFormatting.RED), true);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[Duplicate Structures]").m_130940_(ChatFormatting.RED), true);
                if (duplicates.size() <= 50) {
                    duplicates.forEach((pos, structure) -> ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(String.format("%s at (%d, %d, %d)", structure, pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_()))), true));
                } else {
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(" - Too many duplicates to print. Check the console."), true);
                    StructureGelMod.log("Duplicate structures:", new Object[0]);
                    duplicates.forEach((pos, structure) -> StructureGelMod.log(String.format("%s /tp @s %d %d %d", structure, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), new Object[0]));
                }
            }
            return savedStructures.size();
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("No structures were saved."), true);
        return 0;
    }
}

