/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.api.registry.registrar.base.IForgeRegistrar;
import com.legacy.structure_gel.core.util.Internal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureRegistrar<C extends FeatureConfiguration, S extends StructureFeature<C>>
implements IForgeRegistrar<StructureRegistrar<C, S>, StructureFeature<?>> {
    @Internal
    public static final List<StructureRegistrar<?, ?>> REGISTRARS = new ArrayList();
    private final ResourceLocation registryName;
    private final S structure;
    private final Map<String, StructurePieceType> pieceTypes;
    private final Map<String, ConfiguredStructureFeature<C, S>> structureFeatures;
    private final GenerationStep.Decoration generationStage;
    private final Supplier<StructureFeatureConfiguration> featureConfiguration;

    protected StructureRegistrar(ResourceLocation registryName, S structure, Map<String, StructurePieceType> pieceTypes, Map<String, C> configs, GenerationStep.Decoration generationStage, Supplier<StructureFeatureConfiguration> featureConfiguration) {
        this.registryName = registryName;
        this.structure = structure;
        this.pieceTypes = pieceTypes;
        this.structureFeatures = configs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> structure.m_67065_((FeatureConfiguration)v.getValue())));
        this.generationStage = generationStage;
        this.featureConfiguration = featureConfiguration;
        REGISTRARS.add(this);
    }

    public static <C extends FeatureConfiguration, S extends StructureFeature<C>> StructureRegistrar<C, S> of(ResourceLocation registryName, S structure, StructurePieceType pieceType, C config, GenerationStep.Decoration generationStage, Supplier<StructureFeatureConfiguration> separationSettings) {
        return new StructureRegistrar<C, S>(registryName, structure, (Map<String, StructurePieceType>)ImmutableMap.of((Object)"", (Object)pieceType), ImmutableMap.of((Object)"", config), generationStage, separationSettings);
    }

    public static <C extends FeatureConfiguration, S extends StructureFeature<C>> StructureRegistrar<C, S> of(ResourceLocation registryName, S structure, StructurePieceType pieceType, Map<String, C> configs, GenerationStep.Decoration generationStage, Supplier<StructureFeatureConfiguration> separationSettings) {
        return new StructureRegistrar<C, S>(registryName, structure, (Map<String, StructurePieceType>)ImmutableMap.of((Object)"", (Object)pieceType), configs, generationStage, separationSettings);
    }

    public static <C extends FeatureConfiguration, S extends StructureFeature<C>> StructureRegistrar<C, S> of(ResourceLocation registryName, S structure, Map<String, StructurePieceType> pieceTypes, C config, GenerationStep.Decoration generationStage, Supplier<StructureFeatureConfiguration> separationSettings) {
        return new StructureRegistrar<C, S>(registryName, structure, pieceTypes, ImmutableMap.of((Object)"", config), generationStage, separationSettings);
    }

    public static <C extends FeatureConfiguration, S extends StructureFeature<C>> StructureRegistrar<C, S> of(ResourceLocation registryName, S structure, Map<String, StructurePieceType> pieceTypes, Map<String, C> configs, GenerationStep.Decoration generationStage, Supplier<StructureFeatureConfiguration> separationSettings) {
        return new StructureRegistrar<C, S>(registryName, structure, pieceTypes, configs, generationStage, separationSettings);
    }

    public S getStructure() {
        return this.structure;
    }

    public Map<String, StructurePieceType> getPieceTypes() {
        return this.pieceTypes;
    }

    @Nullable
    public StructurePieceType getPieceType(String name) {
        return this.getPieceTypes().get(name);
    }

    public StructurePieceType getPieceType() throws IllegalArgumentException {
        if (this.getPieceTypes().size() == 1) {
            return (StructurePieceType)this.getPieceTypes().values().toArray()[0];
        }
        throw new IllegalArgumentException(String.format("The structure %s has more than one piece type associated with it.", this.registryName));
    }

    public Map<String, ConfiguredStructureFeature<C, S>> getStructureFeatures() {
        return this.structureFeatures;
    }

    @Nullable
    public ConfiguredStructureFeature<C, S> getStructureFeature(String name) {
        return this.getStructureFeatures().get(name);
    }

    public ConfiguredStructureFeature<C, S> getStructureFeature() throws IllegalArgumentException {
        if (this.getStructureFeatures().size() == 1) {
            return (ConfiguredStructureFeature)this.getStructureFeatures().values().toArray()[0];
        }
        throw new IllegalArgumentException(String.format("The structure %s has more than one structure feature associated with it.", this.registryName));
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public GenerationStep.Decoration getGenerationStage() {
        return this.generationStage;
    }

    public StructureFeatureConfiguration getFeatureConfiguration() {
        return this.featureConfiguration.get();
    }

    @Override
    public StructureRegistrar<C, S> handleForge(IForgeRegistry<StructureFeature<?>> registry) {
        this.pieceTypes.forEach((name, pieceType) -> Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)(name.isEmpty() ? this.registryName : new ResourceLocation(this.registryName.m_135827_(), this.registryName.m_135815_() + "_" + name)), (Object)pieceType));
        this.structureFeatures.forEach((name, feature) -> BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)(name.isEmpty() ? this.registryName : new ResourceLocation(this.registryName.m_135827_(), this.registryName.m_135815_() + "_" + name)), (Object)feature));
        if (this.getStructure().getRegistryName() == null) {
            this.getStructure().setRegistryName(this.getRegistryName());
        }
        registry.register(this.getStructure());
        StructureFeature.f_67012_.put((Object)this.getRegistryName().toString(), this.getStructure());
        StructureFeature.f_67032_.put(this.getStructure(), this.getGenerationStage());
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(this.getStructure(), (Object)this.getFeatureConfiguration()).build();
        return this;
    }
}

